/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDQL;
import org.hsqldb.QueryExpression;
import org.hsqldb.QuerySpecification;
import org.hsqldb.RangeGroup;
import org.hsqldb.RangeVariableResolver;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.lib.OrderedLongHashSet;
import org.hsqldb.map.ValuePool;
import org.hsqldb.navigator.RangeIterator;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.types.Type;

public class RangeVariable {
    static final RangeVariable[] emptyArray = new RangeVariable[0];
    public static final int TABLE_RANGE = 1;
    public static final int TRANSITION_RANGE = 2;
    public static final int PARAMETER_RANGE = 3;
    public static final int VARIALBE_RANGE = 4;
    Table rangeTable;
    final HsqlNameManager.SimpleName tableAlias;
    private OrderedHashSet columnAliases;
    private HsqlNameManager.SimpleName[] columnAliasNames;
    private OrderedHashSet columnNames;
    OrderedHashSet namedJoinColumns;
    HashMap namedJoinColumnExpressions;
    private Object[] emptyData;
    boolean[] columnsInGroupBy;
    boolean hasKeyedColumnInGroupBy;
    boolean[] usedColumns;
    boolean[] updatedColumns;
    RangeVariableConditions[] joinConditions;
    RangeVariableConditions[] whereConditions;
    int subRangeCount;
    Expression joinCondition;
    boolean isLateral;
    boolean isLeftJoin;
    boolean isRightJoin;
    boolean isBoundary;
    boolean hasLateral;
    boolean hasLeftJoin;
    boolean hasRightJoin;
    int level;
    int indexDistinctCount;
    int rangePositionInJoin;
    int rangePosition;
    HashMappedList variables;
    int rangeType;
    boolean isGenerated;

    public RangeVariable(HashMappedList variables, HsqlNameManager.SimpleName rangeName, boolean isVariable, int rangeType) {
        this.variables = variables;
        this.rangeType = rangeType;
        this.rangeTable = null;
        this.tableAlias = rangeName;
        this.emptyData = null;
        this.columnsInGroupBy = null;
        this.usedColumns = null;
        this.joinConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, true)};
        this.whereConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, false)};
        switch (rangeType) {
            case 2: {
                this.usedColumns = new boolean[variables.size()];
            }
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw Error.runtimeError(201, "RangeVariable");
            }
        }
    }

    public RangeVariable(Table table, HsqlNameManager.SimpleName alias, OrderedHashSet columnList, HsqlNameManager.SimpleName[] columnNameList, ParserDQL.CompileContext compileContext) {
        this.rangeType = 1;
        this.rangeTable = table;
        this.tableAlias = alias;
        this.columnAliases = columnList;
        this.columnAliasNames = columnNameList;
        this.joinConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, true)};
        this.whereConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, false)};
        compileContext.registerRangeVariable(this);
        if (this.rangeTable.getColumnCount() != 0) {
            this.setRangeTableVariables();
        }
    }

    public RangeVariable(Table table, int position) {
        this.rangeType = 1;
        this.rangeTable = table;
        this.tableAlias = null;
        this.emptyData = this.rangeTable.getEmptyRowData();
        this.columnsInGroupBy = this.rangeTable.getNewColumnCheckList();
        this.usedColumns = this.rangeTable.getNewColumnCheckList();
        this.rangePosition = position;
        this.joinConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, true)};
        this.whereConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, false)};
    }

    public void setRangeTableVariables() {
        if (this.columnAliasNames != null && this.rangeTable.getColumnCount() != this.columnAliasNames.length) {
            throw Error.error(5593);
        }
        this.emptyData = this.rangeTable.getEmptyRowData();
        this.columnsInGroupBy = this.rangeTable.getNewColumnCheckList();
        this.usedColumns = this.rangeTable.getNewColumnCheckList();
        this.joinConditions[0].rangeIndex = this.rangeTable.getPrimaryIndex();
        this.whereConditions[0].rangeIndex = this.rangeTable.getPrimaryIndex();
    }

    public void setJoinType(boolean isLeft, boolean isRight) {
        this.isLeftJoin = isLeft;
        this.isRightJoin = isRight;
        if (this.isRightJoin) {
            this.whereConditions[0].rangeIndex = this.rangeTable.getPrimaryIndex();
        }
    }

    public void addNamedJoinColumns(OrderedHashSet columns) {
        this.namedJoinColumns = columns;
    }

    public void addColumn(int columnIndex) {
        if (this.usedColumns != null) {
            this.usedColumns[columnIndex] = true;
        }
    }

    public void addAllColumns() {
        if (this.usedColumns != null) {
            ArrayUtil.fillArray(this.usedColumns, true);
        }
    }

    public void addNamedJoinColumnExpression(String name, Expression e) {
        if (this.namedJoinColumnExpressions == null) {
            this.namedJoinColumnExpressions = new HashMap();
        }
        this.namedJoinColumnExpressions.put(name, e);
    }

    public ExpressionColumn getColumnExpression(String name) {
        return this.namedJoinColumnExpressions == null ? null : (ExpressionColumn)this.namedJoinColumnExpressions.get(name);
    }

    public Table getTable() {
        return this.rangeTable;
    }

    public boolean hasAnyTerminalCondition() {
        int i;
        for (i = 0; i < this.joinConditions.length; ++i) {
            if (this.joinConditions[0].terminalCondition == null) continue;
            return true;
        }
        for (i = 0; i < this.whereConditions.length; ++i) {
            if (this.whereConditions[0].terminalCondition == null) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyIndexCondition() {
        int i;
        for (i = 0; i < this.joinConditions.length; ++i) {
            if (this.joinConditions[0].indexedColumnCount <= 0) continue;
            return true;
        }
        for (i = 0; i < this.whereConditions.length; ++i) {
            if (this.whereConditions[0].indexedColumnCount <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasSingleIndexCondition() {
        return this.joinConditions.length == 1 && this.joinConditions[0].indexedColumnCount > 0;
    }

    public boolean setDistinctColumnsOnIndex(int[] colMap) {
        if (this.joinConditions.length != 1) {
            return false;
        }
        int[] indexColMap = this.joinConditions[0].rangeIndex.getColumns();
        if (colMap.length > indexColMap.length) {
            return false;
        }
        if (colMap.length == indexColMap.length && ArrayUtil.haveEqualSets(colMap, indexColMap, colMap.length)) {
            this.indexDistinctCount = colMap.length;
            return true;
        }
        if (ArrayUtil.haveEqualArrays(colMap, indexColMap, colMap.length)) {
            this.indexDistinctCount = colMap.length;
            return true;
        }
        return false;
    }

    public Index getSortIndex() {
        if (this.joinConditions.length == 1) {
            return this.joinConditions[0].rangeIndex;
        }
        return null;
    }

    public boolean setSortIndex(Index index, boolean reversed) {
        if (this.joinConditions.length == 1 && this.joinConditions[0].indexedColumnCount == 0) {
            this.joinConditions[0].rangeIndex = index;
            this.joinConditions[0].reversed = reversed;
            return true;
        }
        return false;
    }

    public boolean reverseOrder() {
        if (this.joinConditions.length == 1) {
            this.joinConditions[0].reverseIndexCondition();
            return true;
        }
        return false;
    }

    public OrderedHashSet getColumnNames() {
        if (this.columnNames == null) {
            this.columnNames = new OrderedHashSet();
            this.rangeTable.getColumnNames(this.usedColumns, this.columnNames);
        }
        return this.columnNames;
    }

    public OrderedHashSet getUniqueColumnNameSet() {
        OrderedHashSet set = new OrderedHashSet();
        if (this.columnAliases != null) {
            set.addAll(this.columnAliases);
            return set;
        }
        for (int i = 0; i < this.rangeTable.columnList.size(); ++i) {
            String name = this.rangeTable.getColumn((int)i).getName().name;
            boolean added = set.add(name);
            if (added) continue;
            throw Error.error(5578, name);
        }
        return set;
    }

    public int findColumn(String schemaName, String tableName, String columnName) {
        if (this.namedJoinColumnExpressions != null && this.namedJoinColumnExpressions.containsKey(columnName) && tableName != null) {
            return -1;
        }
        if (this.resolvesSchemaAndTableName(schemaName, tableName)) {
            return this.findColumn(columnName);
        }
        return -1;
    }

    private int findColumn(String columnName) {
        if (this.variables != null) {
            return this.variables.getIndex(columnName);
        }
        if (this.columnAliases != null) {
            return this.columnAliases.getIndex(columnName);
        }
        return this.rangeTable.findColumn(columnName);
    }

    public ColumnSchema getColumn(int i) {
        if (this.variables == null) {
            return this.rangeTable.getColumn(i);
        }
        return (ColumnSchema)this.variables.get(i);
    }

    public HsqlNameManager.SimpleName getColumnAlias(int i) {
        if (this.columnAliases == null) {
            return this.rangeTable.getColumn(i).getName();
        }
        return this.columnAliasNames[i];
    }

    public boolean hasColumnAlias() {
        return this.columnAliases != null;
    }

    public boolean hasTableAlias() {
        return this.tableAlias != null;
    }

    public boolean isVariable() {
        return this.variables != null;
    }

    public HsqlNameManager.SimpleName getTableAlias() {
        return this.tableAlias == null ? this.rangeTable.getName() : this.tableAlias;
    }

    public RangeVariable getRangeForTableName(String name) {
        if (this.resolvesTableName(name)) {
            return this;
        }
        return null;
    }

    private boolean resolvesSchemaAndTableName(String schemaName, String tableName) {
        return this.resolvesSchemaName(schemaName) && this.resolvesTableName(tableName);
    }

    private boolean resolvesTableName(String name) {
        if (name == null) {
            return true;
        }
        if (this.variables != null) {
            if (this.tableAlias != null) {
                return name.equals(this.tableAlias.name);
            }
            return false;
        }
        return this.tableAlias == null ? name.equals(this.rangeTable.getName().name) : name.equals(this.tableAlias.name);
    }

    private boolean resolvesSchemaName(String name) {
        if (name == null) {
            return true;
        }
        if (this.variables != null) {
            return false;
        }
        if (this.tableAlias != null) {
            return false;
        }
        return name.equals(this.rangeTable.getSchemaName().name);
    }

    public void addTableColumns(HsqlArrayList exprList) {
        if (this.namedJoinColumns != null) {
            int count = exprList.size();
            int position = 0;
            for (int i = 0; i < count; ++i) {
                Expression e = (Expression)exprList.get(i);
                String columnName = e.getColumnName();
                if (!this.namedJoinColumns.contains(columnName)) continue;
                if (position != i) {
                    exprList.remove(i);
                    exprList.add(position, e);
                }
                e = this.getColumnExpression(columnName);
                exprList.set(position, e);
                ++position;
            }
        }
        this.addTableColumns(exprList, exprList.size(), (HashSet)this.namedJoinColumns);
    }

    public int addTableColumns(HsqlArrayList exprList, int position, HashSet exclude) {
        Table table = this.getTable();
        int count = table.getColumnCount();
        for (int i = 0; i < count; ++i) {
            String columnName;
            ColumnSchema column = table.getColumn(i);
            String string = columnName = this.columnAliases == null ? column.getName().name : (String)this.columnAliases.get(i);
            if (exclude != null && exclude.contains(columnName)) continue;
            ExpressionColumn e = new ExpressionColumn(this, i);
            exprList.add(position++, e);
        }
        return position;
    }

    public void addTableColumns(RangeVariable subRange, Expression expression, HashSet exclude) {
        if (subRange == this) {
            Table table = this.getTable();
            int count = table.getColumnCount();
            this.addTableColumns(expression, 0, count, exclude);
        }
    }

    protected int getFirstColumnIndex(RangeVariable subRange) {
        if (subRange == this) {
            return 0;
        }
        return -1;
    }

    protected void addTableColumns(Expression expression, int start, int count, HashSet exclude) {
        Table table = this.getTable();
        HsqlArrayList list = new HsqlArrayList();
        for (int i = start; i < start + count; ++i) {
            String columnName;
            ColumnSchema column = table.getColumn(i);
            String string = columnName = this.columnAliases == null ? column.getName().name : (String)this.columnAliases.get(i);
            if (exclude != null && exclude.contains(columnName)) continue;
            ExpressionColumn e = new ExpressionColumn(this, i);
            list.add(e);
        }
        Expression[] nodes = new Expression[list.size()];
        list.toArray(nodes);
        expression.nodes = nodes;
    }

    public void setForCheckConstraint() {
        this.joinConditions[0].rangeIndex = null;
        this.whereConditions[0].rangeIndex = null;
        this.rangePosition = 0;
    }

    public Expression getJoinCondition() {
        return this.joinCondition;
    }

    public void addJoinCondition(Expression e) {
        this.joinCondition = ExpressionLogical.andExpressions(this.joinCondition, e);
    }

    public void resetConditions() {
        Index index = this.joinConditions[0].rangeIndex;
        this.joinConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, true)};
        this.joinConditions[0].rangeIndex = index;
        index = this.whereConditions[0].rangeIndex;
        this.whereConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, false)};
        this.whereConditions[0].rangeIndex = index;
    }

    public OrderedHashSet getSubqueries() {
        OrderedHashSet set = null;
        if (this.joinCondition != null) {
            set = this.joinCondition.collectAllSubqueries(set);
        }
        if (this.rangeTable instanceof TableDerived) {
            QueryExpression queryExpression = ((TableDerived)this.rangeTable).getQueryExpression();
            if (queryExpression == null) {
                Expression dataExpression = ((TableDerived)this.rangeTable).getDataExpression();
                if (dataExpression != null) {
                    if (set == null) {
                        set = new OrderedHashSet();
                    }
                    OrderedHashSet.addAll(set, dataExpression.getSubqueries());
                }
            } else {
                OrderedHashSet temp = queryExpression.getSubqueries();
                set = OrderedHashSet.addAll(set, temp);
                set = OrderedHashSet.add(set, this.rangeTable);
            }
        }
        return set;
    }

    public OrderedHashSet collectAllExpressions(OrderedHashSet set, OrderedIntHashSet typeSet, OrderedIntHashSet stopAtTypeSet) {
        if (this.joinCondition != null) {
            set = this.joinCondition.collectAllExpressions(set, typeSet, stopAtTypeSet);
        }
        QueryExpression queryExpression = this.rangeTable.getQueryExpression();
        Expression dataExpression = this.rangeTable.getDataExpression();
        if (queryExpression != null) {
            set = queryExpression.collectAllExpressions(set, typeSet, stopAtTypeSet);
        }
        if (dataExpression != null) {
            set = dataExpression.collectAllExpressions(set, typeSet, stopAtTypeSet);
        }
        return set;
    }

    public void replaceColumnReferences(RangeVariable range, Expression[] list) {
        int i;
        QueryExpression queryExpression = this.rangeTable.getQueryExpression();
        Expression dataExpression = this.rangeTable.getDataExpression();
        if (dataExpression != null) {
            dataExpression = dataExpression.replaceColumnReferences(range, list);
        }
        if (queryExpression != null) {
            queryExpression.replaceColumnReferences(range, list);
        }
        if (this.joinCondition != null) {
            this.joinCondition = this.joinCondition.replaceColumnReferences(range, list);
        }
        for (i = 0; i < this.joinConditions.length; ++i) {
            this.joinConditions[i].replaceColumnReferences(range, list);
        }
        for (i = 0; i < this.whereConditions.length; ++i) {
            this.whereConditions[i].replaceColumnReferences(range, list);
        }
    }

    public void replaceRangeVariables(RangeVariable[] ranges, RangeVariable[] newRanges) {
        if (this.joinCondition != null) {
            this.joinCondition.replaceRangeVariables(ranges, newRanges);
        }
    }

    public void resolveRangeTable(Session session, RangeGroup rangeGroup, RangeGroup[] rangeGroups) {
        HsqlList unresolved;
        QueryExpression queryExpression = this.rangeTable.getQueryExpression();
        Expression dataExpression = this.rangeTable.getDataExpression();
        if (queryExpression == null && dataExpression == null) {
            return;
        }
        rangeGroups = (RangeGroup[])ArrayUtil.toAdjustedArray(rangeGroups, rangeGroup, rangeGroups.length, 1);
        if (dataExpression != null) {
            unresolved = dataExpression.resolveColumnReferences(session, RangeGroup.emptyGroup, rangeGroups, null);
            unresolved = Expression.resolveColumnSet(session, emptyArray, RangeGroup.emptyArray, unresolved);
            ExpressionColumn.checkColumnsResolved(unresolved);
            dataExpression.resolveTypes(session, null);
            this.setRangeTableVariables();
        }
        if (queryExpression != null) {
            queryExpression.resolveReferences(session, rangeGroups);
            unresolved = queryExpression.getUnresolvedExpressions();
            unresolved = Expression.resolveColumnSet(session, emptyArray, RangeGroup.emptyArray, unresolved);
            ExpressionColumn.checkColumnsResolved(unresolved);
            queryExpression.resolveTypesPartOne(session);
            queryExpression.resolveTypesPartTwo(session);
            this.rangeTable.prepareTable(session);
            this.setRangeTableVariables();
        }
    }

    void resolveRangeTableTypes(Session session, RangeVariable[] ranges) {
        QueryExpression queryExpression = this.rangeTable.getQueryExpression();
        if (queryExpression != null) {
            if (queryExpression instanceof QuerySpecification) {
                QuerySpecification qs = (QuerySpecification)queryExpression;
                if (!(qs.isGrouped || qs.isAggregated || qs.isOrderSensitive)) {
                    this.moveConditionsToInner(session, ranges);
                }
            }
            queryExpression.resolveTypesPartThree(session);
        }
    }

    void moveConditionsToInner(Session session, RangeVariable[] ranges) {
        int i;
        Expression condition = null;
        if (this.whereConditions.length > 1) {
            return;
        }
        if (this.joinConditions.length > 1) {
            return;
        }
        for (i = 0; i < ranges.length; ++i) {
            if (!ranges[i].isLeftJoin && !ranges[i].isRightJoin) continue;
            return;
        }
        int exclude = ArrayUtil.find(ranges, this);
        HsqlArrayList conditionsList = new HsqlArrayList();
        RangeVariable.addConditionsToList(conditionsList, this.joinConditions[0].indexCond);
        if (this.joinConditions[0].indexCond != null && this.joinConditions[0].indexCond[0] != this.joinConditions[0].indexEndCond[0]) {
            RangeVariable.addConditionsToList(conditionsList, this.joinConditions[0].indexEndCond);
        }
        RangeVariable.addConditionsToList(conditionsList, this.whereConditions[0].indexCond);
        RangeVariable.addConditionsToList(conditionsList, this.whereConditions[0].indexEndCond);
        RangeVariableResolver.decomposeAndConditions(session, this.joinConditions[0].nonIndexCondition, conditionsList);
        RangeVariableResolver.decomposeAndConditions(session, this.whereConditions[0].nonIndexCondition, conditionsList);
        for (i = conditionsList.size() - 1; i >= 0; --i) {
            Expression e = (Expression)conditionsList.get(i);
            if (e != null && !e.isTrue() && !e.hasReference(ranges, exclude)) continue;
            conditionsList.remove(i);
        }
        if (conditionsList.size() == 0) {
            if (this.rangeTable.isView()) {
                ((TableDerived)this.rangeTable).resetToView();
            }
            return;
        }
        OrderedHashSet subquerySet = null;
        for (int i2 = 0; i2 < conditionsList.size(); ++i2) {
            Expression e = (Expression)conditionsList.get(i2);
            subquerySet = e.collectAllSubqueries(subquerySet);
            if (subquerySet == null) continue;
            return;
        }
        QueryExpression queryExpression = this.rangeTable.getQueryExpression();
        Expression[] colExpr = ((QuerySpecification)queryExpression).exprColumns;
        for (int i3 = 0; i3 < conditionsList.size(); ++i3) {
            Expression e = (Expression)conditionsList.get(i3);
            e = e.duplicate();
            OrderedHashSet set = (e = e.replaceColumnReferences(this, colExpr)).collectRangeVariables(null);
            if (set != null) {
                for (int j = 0; j < set.size(); ++j) {
                    RangeVariable range = (RangeVariable)set.get(j);
                    if (this == range || range.rangeType != 1) continue;
                    queryExpression.setCorrelated();
                    break;
                }
            }
            condition = ExpressionLogical.andExpressions(condition, e);
        }
        queryExpression.addExtraConditions(condition);
    }

    private static void addConditionsToList(HsqlArrayList list, Expression[] array) {
        if (array == null) {
            return;
        }
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null || !array[i].isSingleColumnCondition && !array[i].isSingleColumnNull && !array[i].isSingleColumnNotNull) continue;
            list.add(array[i]);
        }
    }

    public String describe(Session session, int blanks) {
        StringBuffer b = new StringBuffer(blanks);
        for (int i = 0; i < blanks; ++i) {
            b.append(' ');
        }
        StringBuffer sb = new StringBuffer();
        String temp = "INNER";
        if (this.isLeftJoin) {
            temp = "LEFT OUTER";
            if (this.isRightJoin) {
                temp = "FULL";
            }
        } else if (this.isRightJoin) {
            temp = "RIGHT OUTER";
        }
        sb.append(b).append("join type=").append(temp).append("\n");
        sb.append(b).append("table=").append(this.rangeTable.getName().name).append("\n");
        if (this.tableAlias != null) {
            sb.append(b).append("alias=").append(this.tableAlias.name).append("\n");
        }
        RangeVariableConditions[] conditions = this.joinConditions;
        if (this.whereConditions[0].hasIndexCondition()) {
            conditions = this.whereConditions;
        }
        sb.append(b).append("cardinality=");
        sb.append(this.rangeTable.getRowStore(session).elementCount()).append("\n");
        boolean fullScan = !conditions[0].hasIndexCondition();
        sb.append(b);
        if (conditions == this.whereConditions && this.joinConditions[0].nonIndexCondition != null) {
            sb.append("join condition = [");
            sb.append(this.joinConditions[0].nonIndexCondition.describe(session, blanks));
            sb.append(b).append("]\n");
            sb.append(b);
        }
        sb.append("access=").append(fullScan ? "FULL SCAN" : "INDEX PRED").append("\n");
        for (int i = 0; i < conditions.length; ++i) {
            if (i > 0) {
                sb.append(b).append("OR condition = [");
            } else {
                sb.append(b);
                if (conditions == this.whereConditions) {
                    sb.append("where condition = [");
                } else {
                    sb.append("join condition = [");
                }
            }
            sb.append(conditions[i].describe(session, blanks + 2));
            sb.append(b).append("]\n");
        }
        if (conditions == this.joinConditions) {
            sb.append(b);
            if (this.whereConditions[0].nonIndexCondition != null) {
                sb.append("where condition = [");
                sb.append(this.whereConditions[0].nonIndexCondition.describe(session, blanks));
                sb.append(b).append("]\n");
                sb.append(b);
            }
        }
        return sb.toString();
    }

    public RangeIteratorMain getIterator(Session session) {
        RangeIteratorMain it = this.isRightJoin ? new RangeIteratorRight(session, this, null) : new RangeIteratorMain(session, this);
        session.sessionContext.setRangeIterator(it);
        return it;
    }

    public static RangeIterator getIterator(Session session, RangeVariable[] rangeVars) {
        if (rangeVars.length == 1) {
            return rangeVars[0].getIterator(session);
        }
        RangeIteratorMain[] iterators = new RangeIteratorMain[rangeVars.length];
        for (int i = 0; i < rangeVars.length; ++i) {
            iterators[i] = rangeVars[i].getIterator(session);
        }
        return new RangeIteratorJoined(iterators);
    }

    public static class RangeVariableConditions {
        final RangeVariable rangeVar;
        Expression[] indexCond;
        Expression[] indexEndCond;
        int[] opTypes;
        int[] opTypesEnd;
        Expression indexEndCondition;
        int indexedColumnCount;
        Index rangeIndex;
        final boolean isJoin;
        Expression excludeConditions;
        Expression nonIndexCondition;
        Expression terminalCondition;
        int opType;
        int opTypeEnd;
        boolean isFalse;
        boolean reversed;
        boolean hasIndex;

        RangeVariableConditions(RangeVariable rangeVar, boolean isJoin) {
            this.rangeVar = rangeVar;
            this.isJoin = isJoin;
        }

        RangeVariableConditions(RangeVariableConditions base) {
            this.rangeVar = base.rangeVar;
            this.isJoin = base.isJoin;
            this.nonIndexCondition = base.nonIndexCondition;
        }

        boolean hasIndexCondition() {
            return this.indexedColumnCount > 0;
        }

        boolean hasIndex() {
            return this.hasIndex;
        }

        void addCondition(Expression e) {
            if (e == null) {
                return;
            }
            if (e instanceof ExpressionLogical && ((ExpressionLogical)e).isTerminal) {
                this.terminalCondition = e;
            }
            this.nonIndexCondition = ExpressionLogical.andExpressions(this.nonIndexCondition, e);
            if (Expression.EXPR_FALSE.equals(this.nonIndexCondition)) {
                this.isFalse = true;
            }
            if (this.rangeIndex == null || this.rangeIndex.getColumnCount() == 0) {
                return;
            }
            if (this.indexedColumnCount == 0) {
                return;
            }
            if (e.getIndexableExpression(this.rangeVar) == null) {
                return;
            }
            int colIndex = e.getLeftNode().getColumnIndex();
            int[] indexCols = this.rangeIndex.getColumns();
            switch (e.getType()) {
                case 41: 
                case 42: 
                case 43: {
                    if (this.opType == 48) {
                        if (indexCols[this.indexedColumnCount - 1] != colIndex) break;
                        this.nonIndexCondition = ExpressionLogical.andExpressions(this.nonIndexCondition, this.indexCond[this.indexedColumnCount - 1]);
                        this.indexCond[this.indexedColumnCount - 1] = e;
                        this.opType = e.opType;
                        this.opTypes[this.indexedColumnCount - 1] = e.opType;
                        if (e.getType() != 42 || this.indexedColumnCount != 1) break;
                        this.indexEndCond[this.indexedColumnCount - 1] = ExpressionLogical.andExpressions(this.indexEndCond[this.indexedColumnCount - 1], e.nodes[2]);
                        break;
                    }
                    this.addToIndexConditions(e);
                    break;
                }
                case 44: 
                case 45: {
                    if (this.opType == 43 || this.opType == 41 || this.opType == 42 || this.opType == 48) {
                        if (this.opTypeEnd != 74 || indexCols[this.indexedColumnCount - 1] != colIndex) break;
                        this.indexEndCond[this.indexedColumnCount - 1] = e;
                        this.indexEndCondition = ExpressionLogical.andExpressions(this.indexEndCondition, e);
                        this.opTypeEnd = e.opType;
                        this.opTypesEnd[this.indexedColumnCount - 1] = e.opType;
                        break;
                    }
                    this.addToIndexEndConditions(e);
                    break;
                }
            }
        }

        private boolean addToIndexConditions(Expression e) {
            if ((this.opType == 40 || this.opType == 47) && this.indexedColumnCount < this.rangeIndex.getColumnCount() && this.rangeIndex.getColumns()[this.indexedColumnCount] == e.getLeftNode().getColumnIndex()) {
                this.indexCond[this.indexedColumnCount] = e;
                this.opType = e.opType;
                this.opTypes[this.indexedColumnCount] = e.opType;
                this.opTypeEnd = 74;
                this.opTypesEnd[this.indexedColumnCount] = 74;
                ++this.indexedColumnCount;
                return true;
            }
            return false;
        }

        private boolean addToIndexEndConditions(Expression e) {
            if ((this.opType == 40 || this.opType == 47) && this.indexedColumnCount < this.rangeIndex.getColumnCount() && this.rangeIndex.getColumns()[this.indexedColumnCount] == e.getLeftNode().getColumnIndex()) {
                ExpressionLogical condition = ExpressionLogical.newNotNullCondition(e.getLeftNode());
                this.indexCond[this.indexedColumnCount] = condition;
                this.indexEndCond[this.indexedColumnCount] = e;
                this.indexEndCondition = ExpressionLogical.andExpressions(this.indexEndCondition, e);
                this.opType = 48;
                this.opTypes[this.indexedColumnCount] = 48;
                this.opTypeEnd = e.opType;
                this.opTypesEnd[this.indexedColumnCount] = e.opType;
                ++this.indexedColumnCount;
                return true;
            }
            return false;
        }

        void addIndexCondition(Expression[] exprList, Index index, int colCount) {
            int indexColCount = index.getColumnCount();
            this.rangeIndex = index;
            this.indexCond = new Expression[indexColCount];
            this.indexEndCond = new Expression[indexColCount];
            this.opTypes = new int[indexColCount];
            this.opTypesEnd = new int[indexColCount];
            this.opType = exprList[0].opType;
            this.opTypes[0] = exprList[0].opType;
            switch (this.opType) {
                case 48: {
                    this.indexCond = exprList;
                    this.opTypeEnd = 74;
                    this.opTypesEnd[0] = 74;
                    break;
                }
                case 41: 
                case 42: 
                case 43: {
                    this.indexCond = exprList;
                    if (exprList[0].getType() == 42) {
                        this.indexEndCond[0] = this.indexEndCondition = exprList[0].nodes[2];
                    }
                    this.opTypeEnd = 74;
                    this.opTypesEnd[0] = 74;
                    break;
                }
                case 44: 
                case 45: {
                    Expression e = exprList[0].getLeftNode();
                    e = new ExpressionLogical(47, e);
                    this.indexCond[0] = e = new ExpressionLogical(48, e);
                    this.indexEndCond[0] = this.indexEndCondition = exprList[0];
                    this.opTypeEnd = this.opType;
                    this.opTypesEnd[0] = this.opType;
                    this.opType = 48;
                    this.opTypes[0] = 48;
                    break;
                }
                case 40: 
                case 47: {
                    this.indexCond = exprList;
                    for (int i = 0; i < colCount; ++i) {
                        Expression e;
                        this.indexEndCond[i] = e = exprList[i];
                        this.indexEndCondition = ExpressionLogical.andExpressions(this.indexEndCondition, e);
                        this.opType = e.opType;
                        this.opTypes[0] = e.opType;
                        this.opTypesEnd[0] = e.opType;
                    }
                    this.opTypeEnd = this.opType;
                    break;
                }
                default: {
                    throw Error.runtimeError(201, "RangeVariable");
                }
            }
            this.indexedColumnCount = colCount;
            this.hasIndex = true;
        }

        private void reverseIndexCondition() {
            if (this.indexedColumnCount == 0) {
                this.reversed = true;
                return;
            }
            if (this.opType != 40 && this.opType != 47) {
                this.indexEndCondition = null;
                for (int i = 0; i < this.indexedColumnCount; ++i) {
                    Expression e = this.indexCond[i];
                    int opTypeCurrent = this.opTypes[i];
                    this.indexCond[i] = this.indexEndCond[i];
                    this.indexEndCond[i] = e;
                    this.indexEndCondition = ExpressionLogical.andExpressions(this.indexEndCondition, e);
                    this.opTypes[i] = this.opTypesEnd[i];
                    this.opTypesEnd[i] = opTypeCurrent;
                }
                this.opType = this.opTypes[this.indexedColumnCount - 1];
                this.opTypeEnd = this.opTypesEnd[this.indexedColumnCount - 1];
            }
            this.reversed = true;
        }

        String describe(Session session, int blanks) {
            StringBuffer sb = new StringBuffer();
            StringBuffer b = new StringBuffer(blanks);
            for (int i = 0; i < blanks; ++i) {
                b.append(' ');
            }
            sb.append("index=").append(this.rangeIndex.getName().name).append("\n");
            if (this.hasIndexCondition()) {
                if (this.indexedColumnCount > 0) {
                    sb.append(b).append("start conditions=[");
                    for (int j = 0; j < this.indexedColumnCount; ++j) {
                        if (this.indexCond == null || this.indexCond[j] == null) continue;
                        sb.append(this.indexCond[j].describe(session, blanks));
                    }
                    sb.append("]\n");
                }
                if (this.opTypeEnd != 40 && this.indexEndCondition != null) {
                    String temp = this.indexEndCondition.describe(session, blanks);
                    sb.append(b).append("end condition=[").append(temp).append("]\n");
                }
            }
            if (this.nonIndexCondition != null) {
                String temp = this.nonIndexCondition.describe(session, blanks);
                sb.append(b).append("other condition=[").append(temp).append("]\n");
            }
            return sb.toString();
        }

        private void replaceColumnReferences(RangeVariable range, Expression[] list) {
            int i;
            if (this.indexCond != null) {
                for (i = 0; i < this.indexCond.length; ++i) {
                    if (this.indexCond[i] == null) continue;
                    this.indexCond[i] = this.indexCond[i].replaceColumnReferences(range, list);
                }
            }
            if (this.indexEndCond != null) {
                for (i = 0; i < this.indexEndCond.length; ++i) {
                    if (this.indexEndCond[i] == null) continue;
                    this.indexEndCond[i] = this.indexEndCond[i].replaceColumnReferences(range, list);
                }
            }
            if (this.indexEndCondition != null) {
                this.indexEndCondition = this.indexEndCondition.replaceColumnReferences(range, list);
            }
            if (this.excludeConditions != null) {
                this.excludeConditions = this.excludeConditions.replaceColumnReferences(range, list);
            }
            if (this.nonIndexCondition != null) {
                this.nonIndexCondition = this.nonIndexCondition.replaceColumnReferences(range, list);
            }
            if (this.terminalCondition != null) {
                this.terminalCondition = this.terminalCondition.replaceColumnReferences(range, list);
            }
        }
    }

    public static class RangeIteratorJoined
    extends RangeIteratorBase {
        RangeIteratorMain[] rangeIterators;
        int currentIndex = 0;

        public RangeIteratorJoined(RangeIteratorMain[] rangeIterators) {
            this.rangeIterators = rangeIterators;
            this.isBeforeFirst = true;
        }

        @Override
        public boolean isBeforeFirst() {
            return this.isBeforeFirst;
        }

        @Override
        public boolean next() {
            while (this.currentIndex >= 0) {
                RangeIteratorMain it = this.rangeIterators[this.currentIndex];
                if (it.next()) {
                    if (this.currentIndex < this.rangeIterators.length - 1) {
                        ++this.currentIndex;
                        continue;
                    }
                    this.currentRow = this.rangeIterators[this.currentIndex].currentRow;
                    this.currentData = this.currentRow.getData();
                    return true;
                }
                it.reset();
                --this.currentIndex;
            }
            this.currentData = this.rangeIterators[this.rangeIterators.length - 1].rangeVar.emptyData;
            this.currentRow = null;
            for (int i = 0; i < this.rangeIterators.length; ++i) {
                this.rangeIterators[i].reset();
            }
            return false;
        }

        @Override
        public void removeCurrent() {
        }

        @Override
        public void release() {
            if (this.it != null) {
                this.it.release();
            }
            for (int i = 0; i < this.rangeIterators.length; ++i) {
                this.rangeIterators[i].reset();
            }
        }

        @Override
        public void reset() {
            super.reset();
            for (int i = 0; i < this.rangeIterators.length; ++i) {
                this.rangeIterators[i].reset();
            }
        }

        @Override
        public int getRangePosition() {
            return 0;
        }
    }

    public static class RangeIteratorRight
    extends RangeIteratorMain {
        boolean isOnRightOuterRows;

        private RangeIteratorRight(Session session, RangeVariable rangeVar, RangeIteratorMain main) {
            super(session, rangeVar);
            this.isFullIterator = true;
        }

        public void setOnOuterRows() {
            this.conditions = this.rangeVar.whereConditions;
            this.isOnRightOuterRows = true;
            this.hasLeftOuterRow = false;
            this.condIndex = 0;
            this.initialiseIterator();
        }

        @Override
        public boolean next() {
            if (this.isOnRightOuterRows) {
                if (this.it == null) {
                    return false;
                }
                return this.findNextRight();
            }
            return super.next();
        }

        private boolean findNextRight() {
            boolean result;
            block2: {
                result = false;
                do {
                    this.currentRow = this.it.getNextRow();
                    if (this.currentRow == null) break block2;
                    this.currentData = this.currentRow.getData();
                    if (this.conditions[this.condIndex].indexEndCondition != null && !this.conditions[this.condIndex].indexEndCondition.testCondition(this.session)) break block2;
                } while (this.conditions[this.condIndex].nonIndexCondition != null && !this.conditions[this.condIndex].nonIndexCondition.testCondition(this.session) || !this.lookupAndTest());
                result = true;
            }
            if (result) {
                return true;
            }
            this.it.release();
            this.currentRow = null;
            this.currentData = this.rangeVar.emptyData;
            return result;
        }

        private boolean lookupAndTest() {
            boolean result;
            boolean bl = result = !this.lookup.contains(this.currentRow.getPos());
            if (result) {
                this.currentData = this.currentRow.getData();
                if (this.conditions[this.condIndex].nonIndexCondition != null && !this.conditions[this.condIndex].nonIndexCondition.testCondition(this.session)) {
                    result = false;
                }
            }
            return result;
        }
    }

    public static class RangeIteratorMain
    extends RangeIteratorBase {
        boolean hasLeftOuterRow;
        boolean isFullIterator;
        RangeVariableConditions[] conditions;
        RangeVariableConditions[] whereConditions;
        RangeVariableConditions[] joinConditions;
        int condIndex = 0;
        OrderedLongHashSet lookup;
        Object[] currentJoinData = null;

        RangeIteratorMain() {
        }

        private RangeIteratorMain(Session session, RangeVariable rangeVar) {
            this.rangePosition = rangeVar.rangePosition;
            this.store = rangeVar.rangeTable.getRowStore(session);
            this.session = session;
            this.rangeVar = rangeVar;
            this.currentData = rangeVar.emptyData;
            this.isBeforeFirst = true;
            this.whereConditions = rangeVar.whereConditions;
            this.joinConditions = rangeVar.joinConditions;
            if (rangeVar.isRightJoin) {
                this.lookup = new OrderedLongHashSet();
            }
            this.conditions = rangeVar.joinConditions;
            if (rangeVar.whereConditions[0].hasIndexCondition()) {
                this.conditions = rangeVar.whereConditions;
            }
        }

        @Override
        public boolean isBeforeFirst() {
            return this.isBeforeFirst;
        }

        @Override
        public boolean next() {
            if (this.session.abortTransaction) {
                throw Error.error(4860);
            }
            while (this.condIndex < this.conditions.length) {
                boolean result;
                if (this.isBeforeFirst) {
                    this.isBeforeFirst = false;
                    this.initialiseIterator();
                }
                if (result = this.findNext()) {
                    return true;
                }
                this.reset();
                ++this.condIndex;
            }
            this.condIndex = 0;
            return false;
        }

        @Override
        public void removeCurrent() {
        }

        @Override
        public void reset() {
            if (this.it != null) {
                this.it.release();
            }
            this.it = null;
            this.currentData = this.rangeVar.emptyData;
            this.currentRow = null;
            this.isBeforeFirst = true;
        }

        @Override
        public int getRangePosition() {
            return this.rangeVar.rangePosition;
        }

        protected void initialiseIterator() {
            if (this.condIndex == 0) {
                this.hasLeftOuterRow = this.rangeVar.isLeftJoin;
            }
            if (this.conditions[this.condIndex].isFalse) {
                this.it = this.conditions[this.condIndex].rangeIndex.emptyIterator();
                return;
            }
            this.rangeVar.rangeTable.materialiseCorrelated(this.session);
            if (this.conditions[this.condIndex].indexCond == null) {
                this.it = this.conditions[this.condIndex].reversed ? this.conditions[this.condIndex].rangeIndex.lastRow(this.session, this.store, this.rangeVar.indexDistinctCount, null) : this.conditions[this.condIndex].rangeIndex.firstRow(this.session, this.store, this.rangeVar.indexDistinctCount, null);
            } else {
                this.getFirstRow();
                if (!this.conditions[this.condIndex].isJoin) {
                    this.hasLeftOuterRow = false;
                }
            }
        }

        private void getFirstRow() {
            if (this.currentJoinData == null || this.currentJoinData.length < this.conditions[this.condIndex].indexedColumnCount) {
                this.currentJoinData = new Object[this.conditions[this.condIndex].indexedColumnCount];
            }
            for (int i = 0; i < this.conditions[this.condIndex].indexedColumnCount; ++i) {
                Object value;
                block11: {
                    int exprType;
                    int range;
                    block12: {
                        int opType;
                        range = 0;
                        int n = opType = i == this.conditions[this.condIndex].indexedColumnCount - 1 ? this.conditions[this.condIndex].opType : this.conditions[this.condIndex].indexCond[i].getType();
                        if (opType == 47 || opType == 48 || opType == 74) {
                            this.currentJoinData[i] = null;
                            continue;
                        }
                        Type valueType = this.conditions[this.condIndex].indexCond[i].getRightNode().getDataType();
                        value = this.conditions[this.condIndex].indexCond[i].getRightNode().getValue(this.session);
                        Type targetType = this.conditions[this.condIndex].indexCond[i].getLeftNode().getDataType();
                        if (targetType != valueType && (range = targetType.compareToTypeRange(value)) == 0 && targetType.typeComparisonGroup != valueType.typeComparisonGroup) {
                            value = targetType.convertToType(this.session, value, valueType);
                        }
                        if (i != 0) break block11;
                        exprType = this.conditions[this.condIndex].indexCond[0].getType();
                        if (range >= 0) break block12;
                        switch (exprType) {
                            case 41: 
                            case 42: 
                            case 43: {
                                value = null;
                                break block11;
                            }
                            default: {
                                this.it = this.conditions[this.condIndex].rangeIndex.emptyIterator();
                                return;
                            }
                        }
                    }
                    if (range > 0) {
                        switch (exprType) {
                            case 48: {
                                value = null;
                                break;
                            }
                            default: {
                                this.it = this.conditions[this.condIndex].rangeIndex.emptyIterator();
                                return;
                            }
                        }
                    }
                }
                this.currentJoinData[i] = value;
            }
            this.it = this.conditions[this.condIndex].rangeIndex.findFirstRow(this.session, this.store, this.currentJoinData, this.conditions[this.condIndex].indexedColumnCount, this.rangeVar.indexDistinctCount, this.conditions[this.condIndex].opType, this.conditions[this.condIndex].reversed, null);
        }

        private boolean findNext() {
            boolean result;
            block5: {
                result = false;
                while (true) {
                    this.currentRow = this.it.getNextRow();
                    if (this.currentRow == null) break block5;
                    this.currentData = this.currentRow.getData();
                    if (this.conditions[this.condIndex].terminalCondition != null && !this.conditions[this.condIndex].terminalCondition.testCondition(this.session)) break block5;
                    if (this.conditions[this.condIndex].indexEndCondition != null && !this.conditions[this.condIndex].indexEndCondition.testCondition(this.session)) {
                        if (!this.conditions[this.condIndex].isJoin) {
                            this.hasLeftOuterRow = false;
                        }
                        break block5;
                    }
                    if (this.joinConditions[this.condIndex].nonIndexCondition != null && !this.joinConditions[this.condIndex].nonIndexCondition.testCondition(this.session)) continue;
                    if (this.whereConditions[this.condIndex].nonIndexCondition != null && !this.whereConditions[this.condIndex].nonIndexCondition.testCondition(this.session)) {
                        this.hasLeftOuterRow = false;
                        this.addFoundRow();
                        continue;
                    }
                    Expression e = this.conditions[this.condIndex].excludeConditions;
                    if (e == null || !e.testCondition(this.session)) break;
                }
                this.addFoundRow();
                this.hasLeftOuterRow = false;
                return true;
            }
            this.it.release();
            this.currentRow = null;
            this.currentData = this.rangeVar.emptyData;
            if (this.hasLeftOuterRow && this.condIndex == this.conditions.length - 1) {
                result = this.whereConditions[this.condIndex].nonIndexCondition == null || this.whereConditions[this.condIndex].nonIndexCondition.testCondition(this.session);
                this.hasLeftOuterRow = false;
            }
            return result;
        }

        private void addFoundRow() {
            if (this.rangeVar.isRightJoin) {
                this.lookup.add(this.currentRow.getPos());
            }
        }
    }

    public static class RangeIteratorBase
    implements RangeIterator {
        Session session;
        int rangePosition;
        RowIterator it;
        PersistentStore store;
        Object[] currentData;
        Row currentRow;
        boolean isBeforeFirst;
        RangeVariable rangeVar;

        private RangeIteratorBase() {
        }

        @Override
        public boolean isBeforeFirst() {
            return this.isBeforeFirst;
        }

        @Override
        public boolean next() {
            if (this.isBeforeFirst) {
                this.isBeforeFirst = false;
            } else if (this.it == null) {
                return false;
            }
            if (this.session.abortTransaction) {
                throw Error.error(4860);
            }
            this.currentRow = this.it.getNextRow();
            if (this.currentRow == null) {
                return false;
            }
            this.currentData = this.currentRow.getData();
            return true;
        }

        @Override
        public Row getCurrentRow() {
            return this.currentRow;
        }

        @Override
        public Object[] getCurrent() {
            return this.currentData;
        }

        @Override
        public Object getCurrent(int i) {
            return this.currentData == null ? null : this.currentData[i];
        }

        @Override
        public void setCurrent(Object[] data) {
            this.currentData = data;
        }

        @Override
        public long getRowId() {
            return this.currentRow == null ? 0L : ((long)this.rangeVar.rangeTable.getId() << 32) + this.currentRow.getPos();
        }

        @Override
        public Object getRowidObject() {
            return this.currentRow == null ? null : ValuePool.getLong(this.getRowId());
        }

        @Override
        public void removeCurrent() {
        }

        @Override
        public void reset() {
            if (this.it != null) {
                this.it.release();
            }
            this.it = null;
            this.currentRow = null;
            this.isBeforeFirst = true;
        }

        @Override
        public int getRangePosition() {
            return this.rangePosition;
        }

        @Override
        public Row getNextRow() {
            throw Error.runtimeError(201, "RangeVariable");
        }

        @Override
        public boolean hasNext() {
            throw Error.runtimeError(201, "RangeVariable");
        }

        @Override
        public Object[] getNext() {
            throw Error.runtimeError(201, "RangeVariable");
        }

        @Override
        public boolean setRowColumns(boolean[] columns) {
            throw Error.runtimeError(201, "RangeVariable");
        }

        @Override
        public void release() {
            if (this.it != null) {
                this.it.release();
            }
        }
    }
}

