/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.lang.reflect.Method;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Constraint;
import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.ParserRoutine;
import org.hsqldb.QueryExpression;
import org.hsqldb.Routine;
import org.hsqldb.RoutineSchema;
import org.hsqldb.Scanner;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Statement;
import org.hsqldb.StatementCommand;
import org.hsqldb.StatementQuery;
import org.hsqldb.StatementSchema;
import org.hsqldb.StatementSchemaDefinition;
import org.hsqldb.StatementSession;
import org.hsqldb.Table;
import org.hsqldb.Token;
import org.hsqldb.View;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.map.ValuePool;
import org.hsqldb.rights.Grantee;
import org.hsqldb.rights.GranteeManager;
import org.hsqldb.rights.Right;
import org.hsqldb.rights.User;
import org.hsqldb.types.Charset;
import org.hsqldb.types.Collation;
import org.hsqldb.types.Type;
import org.hsqldb.types.UserTypeModifier;

public class ParserDDL
extends ParserRoutine {
    static final int[] schemaCommands = new int[]{55, 121};
    static final short[] startStatementTokens = new short[]{55, 121, 4, 88};
    static final short[] startStatementTokensSchema = new short[]{55, 121};

    ParserDDL(Session session, Scanner scanner) {
        super(session, scanner);
    }

    @Override
    void reset(String sql) {
        super.reset(sql);
    }

    StatementSchema compileCreate() {
        int tableType;
        boolean isTable = false;
        boolean isOrReplace = false;
        this.read();
        switch (this.token.tokenType) {
            case 120: {
                this.read();
                this.readThis(523);
                this.readIfThis(608);
                this.readThis(278);
                isTable = true;
                tableType = 3;
                break;
            }
            case 632: {
                this.read();
                this.readThis(278);
                isTable = true;
                tableType = 3;
                break;
            }
            case 523: {
                this.read();
                this.readThis(278);
                isTable = true;
                tableType = 3;
                break;
            }
            case 608: {
                this.read();
                this.readThis(278);
                isTable = true;
                tableType = 4;
                break;
            }
            case 570: {
                this.read();
                this.readThis(278);
                isTable = true;
                tableType = 5;
                break;
            }
            case 633: {
                this.read();
                this.readThis(278);
                isTable = true;
                tableType = 7;
                break;
            }
            case 278: {
                this.read();
                isTable = true;
                tableType = this.database.schemaManager.getDefaultTableType();
                break;
            }
            default: {
                tableType = 4;
            }
        }
        if (isTable) {
            return this.compileCreateTable(tableType);
        }
        if (this.database.sqlSyntaxOra && this.token.tokenType == 197) {
            this.read();
            this.readThis(729);
            switch (this.token.tokenType) {
                case 117: 
                case 215: 
                case 291: 
                case 535: 
                case 545: {
                    break;
                }
                default: {
                    throw this.unexpectedToken("OR");
                }
            }
            isOrReplace = true;
        }
        switch (this.token.tokenType) {
            case 558: {
                return this.compileCreateAlias();
            }
            case 505: {
                return this.compileCreateSequence();
            }
            case 497: {
                return this.compileCreateSchema();
            }
            case 291: {
                return this.compileCreateTrigger(isOrReplace);
            }
            case 305: {
                return this.compileCreateUser();
            }
            case 490: {
                return this.compileCreateRole();
            }
            case 545: {
                return this.compileCreateView(false, isOrReplace);
            }
            case 393: {
                return this.compileCreateDomain();
            }
            case 535: {
                return this.compileCreateType(isOrReplace);
            }
            case 35: {
                return this.compileCreateCharacterSet();
            }
            case 358: {
                return this.compileCreateCollation();
            }
            case 299: {
                this.read();
                this.checkIsThis(598);
                return this.compileCreateIndex(true);
            }
            case 598: {
                return this.compileCreateIndex(false);
            }
            case 559: {
                return this.compileCreateProcedureOrFunction(isOrReplace);
            }
            case 117: 
            case 215: {
                return this.compileCreateProcedureOrFunction(isOrReplace);
            }
        }
        throw this.unexpectedToken();
    }

    Statement compileAlter() {
        this.read();
        switch (this.token.tokenType) {
            case 598: {
                this.read();
                HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(20, true);
                name.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
                if (this.token.tokenType == 624) {
                    this.read();
                    this.readThis(285);
                    return this.compileRenameObject(name, 20);
                }
                this.readThis(10);
                Index index = (Index)this.database.schemaManager.getSchemaObject(name);
                if (index == null) {
                    throw Error.error(5501);
                }
                Table table = (Table)this.database.schemaManager.getSchemaObject(index.getName().parent);
                int[] indexColumns = this.readColumnList(table, true);
                String sql = this.getLastPart();
                Object[] args = new Object[]{table, indexColumns, index.getName()};
                HsqlNameManager.HsqlName[] writeLockNames = new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()};
                return new StatementSchema(sql, 1121, args, null, writeLockNames);
            }
            case 497: {
                this.read();
                HsqlNameManager.HsqlName name = this.readSchemaName();
                this.readThis(624);
                this.readThis(285);
                return this.compileRenameObject(name, 2);
            }
            case 348: {
                this.read();
                this.checkIsSimpleName();
                String name = this.token.tokenString;
                this.checkValidCatalogName(name);
                this.read();
                this.readThis(624);
                this.readThis(285);
                return this.compileRenameObject(this.database.getCatalogName(), 1);
            }
            case 505: {
                return this.compileAlterSequence();
            }
            case 278: {
                return this.compileAlterTable();
            }
            case 305: {
                return this.compileAlterUser();
            }
            case 393: {
                return this.compileAlterDomain();
            }
            case 545: {
                return this.compileCreateView(true, false);
            }
            case 508: {
                return this.compileAlterSession();
            }
            case 259: {
                return this.compileAlterSpecificRoutine();
            }
            case 491: {
                return this.compileAlterRoutine();
            }
            case 48: {
                this.read();
                Constraint constraint = (Constraint)this.readSchemaObjectName(5);
                this.readThis(624);
                this.readThis(285);
                return this.compileRenameObject(constraint.getName(), 5);
            }
        }
        throw this.unexpectedToken();
    }

    Statement compileAlterRoutine() {
        this.readThis(491);
        RoutineSchema routine = (RoutineSchema)this.readSchemaObjectName(18);
        this.readThis(624);
        this.readThis(285);
        return this.compileRenameObject(routine.getName(), routine.getName().type);
    }

    Statement compileDrop() {
        HsqlNameManager.HsqlName[] writeLockNames;
        SchemaObject object;
        int objectType;
        int statementType;
        boolean canCascade = false;
        boolean cascade = false;
        boolean useIfExists = false;
        boolean ifExists = false;
        this.read();
        int objectTokenType = this.token.tokenType;
        switch (objectTokenType) {
            case 598: {
                this.read();
                statementType = 1129;
                objectType = 20;
                useIfExists = true;
                break;
            }
            case 339: {
                this.read();
                statementType = 24;
                objectType = 6;
                canCascade = true;
                break;
            }
            case 259: {
                this.read();
                switch (this.token.tokenType) {
                    case 117: 
                    case 215: 
                    case 491: {
                        this.read();
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                statementType = 30;
                objectType = 24;
                canCascade = true;
                useIfExists = true;
                break;
            }
            case 215: {
                this.read();
                statementType = 30;
                objectType = 17;
                canCascade = true;
                useIfExists = true;
                break;
            }
            case 117: {
                this.read();
                statementType = 30;
                objectType = 16;
                canCascade = true;
                useIfExists = true;
                break;
            }
            case 497: {
                this.read();
                statementType = 31;
                objectType = 2;
                canCascade = true;
                useIfExists = true;
                break;
            }
            case 505: {
                this.read();
                statementType = 135;
                objectType = 7;
                canCascade = true;
                useIfExists = true;
                break;
            }
            case 291: {
                this.read();
                statementType = 34;
                objectType = 8;
                canCascade = false;
                useIfExists = true;
                break;
            }
            case 305: {
                this.read();
                statementType = 1131;
                objectType = 11;
                canCascade = true;
                break;
            }
            case 490: {
                this.read();
                statementType = 29;
                objectType = 11;
                canCascade = true;
                break;
            }
            case 393: {
                this.read();
                statementType = 27;
                objectType = 13;
                canCascade = true;
                useIfExists = true;
                break;
            }
            case 535: {
                this.read();
                statementType = 35;
                objectType = 12;
                canCascade = true;
                useIfExists = true;
                break;
            }
            case 35: {
                this.read();
                this.readThis(254);
                statementType = 25;
                objectType = 14;
                canCascade = false;
                useIfExists = true;
                break;
            }
            case 358: {
                this.read();
                statementType = 26;
                objectType = 15;
                canCascade = false;
                useIfExists = true;
                break;
            }
            case 545: {
                this.read();
                statementType = 36;
                objectType = 4;
                canCascade = true;
                useIfExists = true;
                break;
            }
            case 278: {
                this.read();
                statementType = 32;
                objectType = 3;
                canCascade = true;
                useIfExists = true;
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        if (useIfExists && this.token.tokenType == 412) {
            int position = this.getPosition();
            this.read();
            if (this.token.tokenType == 101) {
                this.read();
                ifExists = true;
            } else {
                this.rewind(position);
            }
        }
        this.checkIsIdentifier();
        HsqlNameManager.HsqlName name = null;
        switch (objectTokenType) {
            case 305: {
                this.checkIsSimpleName();
                this.checkDatabaseUpdateAuthorisation();
                object = this.database.getUserManager().get(this.token.tokenString);
                this.read();
                break;
            }
            case 490: {
                this.checkIsSimpleName();
                this.checkDatabaseUpdateAuthorisation();
                object = this.database.getGranteeManager().getRole(this.token.tokenString);
                this.read();
                break;
            }
            case 497: {
                name = this.readNewSchemaName();
                object = this.database.schemaManager.findSchema(name.name);
                break;
            }
            case 278: {
                boolean isModule;
                boolean bl = isModule = this.token.namePrePrefix == null && ("MODULE".equals(this.token.namePrefix) || "SESSION".equals(this.token.namePrefix));
                if (isModule) {
                    name = this.readNewSchemaObjectName(objectType, false);
                    if (!ifExists && this.token.tokenType == 412) {
                        this.read();
                        this.readThis(101);
                        ifExists = true;
                    }
                    Object[] args = new Object[]{name, ifExists};
                    return new StatementSession(32, args);
                }
            }
            default: {
                name = this.readNewSchemaObjectName(objectType, false);
                name.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
                object = this.database.schemaManager.findSchemaObject(name.name, name.schema.name, name.type);
            }
        }
        if (!ifExists && useIfExists && this.token.tokenType == 412) {
            this.read();
            this.readThis(101);
            ifExists = true;
        }
        if (canCascade) {
            if (this.token.tokenType == 347) {
                cascade = true;
                this.read();
                if (this.database.sqlSyntaxOra) {
                    this.readIfThis(373);
                }
            } else if (this.token.tokenType == 485) {
                this.read();
            }
        }
        if (object == null) {
            writeLockNames = null;
        } else {
            name = object.getName();
            writeLockNames = this.database.schemaManager.getCatalogAndBaseTableNames(name);
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{name, new Integer(objectType), cascade, ifExists};
        StatementSchema cs = new StatementSchema(sql, statementType, args, null, writeLockNames);
        return cs;
    }

    Statement compileAlterTable() {
        this.read();
        String tableName = this.token.tokenString;
        HsqlNameManager.HsqlName schema = this.session.getSchemaHsqlName(this.token.namePrefix);
        this.checkSchemaUpdateAuthorisation(schema);
        Table t = this.database.schemaManager.getUserTable(this.session, tableName, schema.name);
        this.read();
        switch (this.token.tokenType) {
            case 624: {
                this.read();
                if (this.database.sqlSyntaxPgs && this.token.tokenType == 43) {
                    this.read();
                    this.checkIsIdentifier();
                    int columnIndex = t.getColumnIndex(this.token.tokenString);
                    ColumnSchema column = t.getColumn(columnIndex);
                    this.read();
                    this.readThis(285);
                    return this.compileAlterColumnRename(t, column);
                }
                this.readThis(285);
                return this.compileRenameObject(t.getName(), 3);
            }
            case 334: {
                this.read();
                HsqlNameManager.HsqlName cname = null;
                if (this.token.tokenType == 48) {
                    this.read();
                    cname = this.readNewDependentSchemaObjectName(t.getName(), 5);
                }
                switch (this.token.tokenType) {
                    case 113: {
                        this.read();
                        this.readThis(427);
                        return this.compileAlterTableAddForeignKeyConstraint(t, cname);
                    }
                    case 299: {
                        this.read();
                        if (this.database.sqlSyntaxMys && !this.readIfThis(598)) {
                            this.readIfThis(427);
                        }
                        return this.compileAlterTableAddUniqueConstraint(t, cname);
                    }
                    case 37: {
                        this.read();
                        return this.compileAlterTableAddCheckConstraint(t, cname);
                    }
                    case 214: {
                        this.read();
                        this.readThis(427);
                        return this.compileAlterTableAddPrimaryKey(t, cname);
                    }
                    case 43: {
                        if (cname != null) {
                            throw this.unexpectedToken();
                        }
                        this.read();
                        this.checkIsSimpleName();
                        return this.compileAlterTableAddColumn(t);
                    }
                }
                if (cname != null) {
                    throw this.unexpectedToken();
                }
                this.checkIsSimpleName();
                return this.compileAlterTableAddColumn(t);
            }
            case 88: {
                this.read();
                switch (this.token.tokenType) {
                    case 214: {
                        this.read();
                        this.readThis(427);
                        return this.compileAlterTableDropPrimaryKey(t);
                    }
                    case 48: {
                        this.read();
                        return this.compileAlterTableDropConstraint(t);
                    }
                    case 43: {
                        this.read();
                    }
                }
                this.checkIsSimpleName();
                String name = this.token.tokenString;
                boolean cascade = false;
                this.read();
                if (this.token.tokenType == 485) {
                    this.read();
                } else if (this.token.tokenType == 347) {
                    this.read();
                    cascade = true;
                }
                return this.compileAlterTableDropColumn(t, name, cascade);
            }
            case 4: {
                this.read();
                if (this.token.tokenType == 43) {
                    this.read();
                }
                int columnIndex = t.getColumnIndex(this.token.tokenString);
                ColumnSchema column = t.getColumn(columnIndex);
                this.read();
                return this.compileAlterColumn(t, column, columnIndex);
            }
        }
        throw this.unexpectedToken();
    }

    private Statement compileAlterTableDropConstraint(Table table) {
        boolean cascade = false;
        SchemaObject object = this.readSchemaObjectName(table.getSchemaName(), 5);
        if (this.token.tokenType == 485) {
            this.read();
        } else if (this.token.tokenType == 347) {
            this.read();
            cascade = true;
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{object.getName(), ValuePool.getInt(5), cascade, Boolean.FALSE};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        HsqlNameManager.HsqlName mainTableName = ((Constraint)object).getMainTableName();
        if (mainTableName != null && mainTableName != table.getName()) {
            writeLockNames = (HsqlNameManager.HsqlName[])ArrayUtil.toAdjustedArray(writeLockNames, mainTableName, writeLockNames.length, 1);
        }
        StatementSchema cs = new StatementSchema(sql, 1130, args, null, writeLockNames);
        return cs;
    }

    private Statement compileAlterTableDropPrimaryKey(Table table) {
        boolean cascade = false;
        if (this.token.tokenType == 485) {
            this.read();
        } else if (this.token.tokenType == 347) {
            this.read();
            cascade = true;
        }
        if (!table.hasPrimaryKey()) {
            throw Error.error(5501);
        }
        String sql = this.getLastPart();
        Constraint object = table.getPrimaryConstraint();
        Object[] args = new Object[]{object.getName(), ValuePool.getInt(5), cascade, Boolean.FALSE};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        StatementSchema cs = new StatementSchema(sql, 1130, args, null, writeLockNames);
        return cs;
    }

    StatementSession compileDeclareLocalTableOrNull() {
        StatementSchema cs;
        int position = super.getPosition();
        try {
            this.readThis(77);
            this.readThis(157);
            this.readThis(523);
            this.readThis(278);
        }
        catch (HsqlException e) {
            this.lastError = e;
            this.rewind(position);
            return null;
        }
        if (this.token.namePrePrefix != null || this.token.namePrefix != null && !"MODULE".equals(this.token.namePrefix) && !"SESSION".equals(this.token.namePrefix)) {
            throw this.unexpectedToken();
        }
        HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(3, false);
        name.schema = SqlInvariants.MODULE_HSQLNAME;
        Table table = new Table(this.database, name, 3);
        if (this.token.tokenType == 10) {
            cs = this.compileCreateTableAsSubqueryDefinition(table);
        } else {
            cs = this.compileCreateTableBody(table, false);
            HsqlArrayList constraints = (HsqlArrayList)cs.arguments[1];
            for (int i = 0; i < constraints.size(); ++i) {
                Constraint c = (Constraint)constraints.get(i);
                if (c.getConstraintType() != 0) continue;
                throw this.unexpectedToken("FOREIGN");
            }
        }
        StatementSession ss = new StatementSession(1119, cs.arguments);
        return ss;
    }

    StatementSchema compileCreateView(boolean alter, boolean orReplace) {
        QueryExpression queryExpression;
        this.read();
        HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(4, true);
        name.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
        this.checkSchemaUpdateAuthorisation(name.schema);
        HsqlNameManager.HsqlName[] colList = null;
        if (this.token.tokenType == 816) {
            try {
                colList = this.readColumnNames(name);
            }
            catch (HsqlException e) {
                if (this.session.isProcessingScript() && this.database.getProperties().isVersion18()) {
                    while (this.token.tokenType != 10) {
                        this.read();
                    }
                }
                throw e;
            }
        }
        this.readThis(10);
        this.startRecording();
        int position = this.getPosition();
        try {
            queryExpression = this.XreadQueryExpression();
        }
        catch (HsqlException e) {
            queryExpression = this.XreadJoinedTableAsView();
        }
        Token[] tokenisedStatement = this.getRecordedStatement();
        int check = 0;
        if (this.token.tokenType == 319) {
            this.read();
            check = 2;
            if (this.readIfThis(157)) {
                check = 1;
            } else {
                this.readIfThis(28);
            }
            this.readThis(37);
            this.readThis(455);
        }
        View view = new View(this.database, name, colList, check);
        queryExpression.setView(view);
        queryExpression.resolve(this.session);
        view.setStatement(Token.getSQL(tokenisedStatement));
        StatementQuery s = new StatementQuery(this.session, queryExpression, this.compileContext);
        String fullSQL = this.getLastPart();
        Object[] args = new Object[]{view};
        int type = alter ? 1122 : 84;
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(fullSQL, type, args, s.readTableNames, writeLockNames);
    }

    StatementSchema compileCreateSequence() {
        this.read();
        boolean ifNot = false;
        if (this.token.tokenType == 412) {
            int position = this.getPosition();
            this.read();
            if (this.token.tokenType == 183) {
                this.read();
                this.readThis(101);
                ifNot = true;
            } else {
                this.rewind(position);
            }
        }
        HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(7, false);
        NumberSequence sequence = new NumberSequence(name, Type.SQL_INTEGER);
        this.readSequenceOptions(sequence, true, false, false);
        String sql = this.getLastPart();
        Object[] args = new Object[]{sequence, ifNot};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(sql, 133, args, null, writeLockNames);
    }

    StatementSchema compileCreateDomain() {
        boolean end;
        UserTypeModifier userTypeModifier = null;
        this.read();
        HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(13, false);
        this.readIfThis(10);
        Type type = this.readTypeDefinition(true, false).duplicate();
        Expression defaultClause = null;
        if (this.readIfThis(78)) {
            defaultClause = this.readDefaultClause(type);
        }
        userTypeModifier = new UserTypeModifier(name, 13, type);
        userTypeModifier.setDefaultClause(defaultClause);
        type.userTypeModifier = userTypeModifier;
        HsqlArrayList tempConstraints = new HsqlArrayList();
        this.compileContext.currentDomain = type;
        do {
            end = false;
            switch (this.token.tokenType) {
                case 37: 
                case 48: {
                    this.readConstraint(type, tempConstraints);
                    break;
                }
                default: {
                    end = true;
                }
            }
        } while (!end);
        this.compileContext.currentDomain = null;
        for (int i = 0; i < tempConstraints.size(); ++i) {
            Constraint c = (Constraint)tempConstraints.get(i);
            c.prepareCheckConstraint(this.session, null);
            userTypeModifier.addConstraint(c);
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{type};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(sql, 23, args, null, writeLockNames);
    }

    StatementSchema compileCreateType(boolean orReplace) {
        UserTypeModifier userTypeModifier;
        this.read();
        HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(12, false);
        this.readThis(10);
        Type type = this.readTypeDefinition(true, false).duplicate();
        this.readIfThis(400);
        type.userTypeModifier = userTypeModifier = new UserTypeModifier(name, 12, type);
        String sql = this.getLastPart();
        Object[] args = new Object[]{type};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(sql, 83, args, null, writeLockNames);
    }

    StatementSchema compileCreateCharacterSet() {
        this.read();
        this.readThis(254);
        HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(14, false);
        this.readIfThis(10);
        this.readThis(119);
        String schema = this.token.namePrefix;
        Charset source = (Charset)this.database.schemaManager.getCharacterSet(this.session, this.token.tokenString, schema);
        this.read();
        if (this.token.tokenType == 358) {
            this.read();
            this.readThis(115);
            this.readThis(78);
        }
        Charset charset = new Charset(name);
        charset.base = source.getName();
        String sql = this.getLastPart();
        Object[] args = new Object[]{charset};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(sql, 8, args, null, writeLockNames);
    }

    StatementSchema compileCreateCollation() {
        this.read();
        HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(15, false);
        name.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
        this.readThis(112);
        HsqlNameManager.HsqlName charsetName = this.readNewSchemaObjectName(14, false);
        this.readThis(115);
        HsqlNameManager.HsqlName sourceName = this.readNewSchemaObjectName(15, false);
        Boolean padSpace = null;
        if (this.readIfThis(180)) {
            this.readThis(463);
            padSpace = Boolean.FALSE;
        } else if (this.readIfThis(463)) {
            this.readThis(514);
            padSpace = Boolean.TRUE;
        }
        String schemaName = charsetName.schema == null ? null : charsetName.schema.name;
        Charset charset = (Charset)this.database.schemaManager.getCharacterSet(this.session, charsetName.name, schemaName);
        if (charset == null) {
            throw Error.error(5501, charsetName.getSchemaQualifiedStatementName());
        }
        schemaName = sourceName.schema == null ? null : sourceName.schema.name;
        Collation source = this.database.schemaManager.getCollation(this.session, sourceName.name, schemaName);
        Collation collation = new Collation(name, source, charset, padSpace);
        String sql = this.getLastPart();
        Object[] args = new Object[]{collation};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(sql, 10, args, null, writeLockNames);
    }

    StatementSchema compileCreateAlias() {
        String alias;
        HsqlNameManager.HsqlName name = null;
        Routine[] routines = null;
        String methodFQN = null;
        if (!this.session.isProcessingScript()) {
            throw super.unsupportedFeature();
        }
        this.read();
        try {
            alias = this.token.tokenString;
            this.read();
            this.readThis(112);
            methodFQN = this.token.tokenString;
            this.read();
        }
        catch (HsqlException e) {
            alias = null;
        }
        if (alias != null) {
            HsqlNameManager.HsqlName schema = this.database.schemaManager.getDefaultSchemaHsqlName();
            name = this.database.nameManager.newHsqlName(schema, alias, 16);
            Method[] methods = Routine.getMethods(methodFQN);
            routines = Routine.newRoutines(this.session, methods);
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{name, routines};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(sql, 1124, args, null, writeLockNames);
    }

    StatementSchema compileCreateIndex(boolean unique) {
        String[] qualifiers = null;
        HsqlArrayList list = new HsqlArrayList();
        this.read();
        HsqlNameManager.HsqlName indexHsqlName = this.readNewSchemaObjectName(20, true);
        while (this.token.tokenType != 194) {
            this.checkIsIdentifier();
            list.add(this.token.tokenString);
            this.read();
        }
        qualifiers = new String[list.size()];
        list.toArray(qualifiers);
        this.readThis(194);
        Table table = this.readTableName();
        HsqlNameManager.HsqlName tableSchema = table.getSchemaName();
        indexHsqlName.setSchemaIfNull(tableSchema);
        indexHsqlName.parent = table.getName();
        if (indexHsqlName.schema != tableSchema) {
            throw Error.error(5505);
        }
        indexHsqlName.schema = table.getSchemaName();
        int[] indexColumns = this.readColumnList(table, true);
        String sql = this.getLastPart();
        Object[] args = new Object[]{table, indexColumns, indexHsqlName, unique, qualifiers};
        return new StatementSchema(sql, 1125, args, null, new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()});
    }

    StatementSchema compileCreateSchema() {
        boolean swapped;
        Grantee owner;
        HsqlNameManager.HsqlName schemaName = null;
        String authorisation = null;
        HsqlNameManager.HsqlName characterSetName = null;
        this.read();
        if (this.token.tokenType != 15) {
            schemaName = this.readNewSchemaName();
        }
        if (this.token.tokenType == 15) {
            this.read();
            this.checkIsSimpleName();
            authorisation = this.token.tokenString;
            this.read();
            if (schemaName == null) {
                owner = this.database.getGranteeManager().get(authorisation);
                if (owner == null) {
                    throw Error.error(4001, authorisation);
                }
                schemaName = this.database.nameManager.newHsqlName(owner.getName().name, this.isDelimitedIdentifier(), 2);
                SqlInvariants.checkSchemaNameNotSystem(this.token.tokenString);
            }
        }
        if ("PUBLIC".equals(authorisation)) {
            throw Error.error(4002, authorisation);
        }
        Grantee grantee = owner = authorisation == null ? this.session.getGrantee() : this.database.getGranteeManager().get(authorisation);
        if (owner == null) {
            throw Error.error(4001, authorisation);
        }
        if (!this.session.getGrantee().isSchemaCreator()) {
            throw Error.error(2051, this.session.getGrantee().getName().getNameString());
        }
        if (owner instanceof User && ((User)owner).isExternalOnly) {
            throw Error.error(2000, this.session.getGrantee().getName().getNameString());
        }
        if (!(!this.database.schemaManager.schemaExists(schemaName.name) || this.session.isProcessingScript() && "PUBLIC".equals(schemaName.name))) {
            throw Error.error(5504, schemaName.name);
        }
        if (schemaName.name.equals("SYSTEM_LOBS")) {
            schemaName = SqlInvariants.LOBS_SCHEMA_HSQLNAME;
            owner = schemaName.owner;
        }
        if (this.readIfThis(78)) {
            this.readThis(35);
            this.readThis(254);
            characterSetName = this.readNewSchemaObjectName(14, false);
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{schemaName, owner};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.catalogNameArray;
        StatementSchema cs = new StatementSchema(sql, 64, args, null, writeLockNames);
        cs.setSchemaHsqlName(schemaName);
        HsqlArrayList list = new HsqlArrayList();
        list.add(cs);
        this.getCompiledStatementBody(list);
        StatementSchema[] array = new StatementSchema[list.size()];
        list.toArray(array);
        do {
            swapped = false;
            for (int i = 0; i < array.length - 1; ++i) {
                if (array[i].order <= array[i + 1].order) continue;
                StatementSchema temp = array[i + 1];
                array[i + 1] = array[i];
                array[i] = temp;
                swapped = true;
            }
        } while (swapped);
        return new StatementSchemaDefinition(array);
    }

    void getCompiledStatementBody(HsqlList list) {
        boolean end = false;
        while (!end) {
            StatementSchema cs = null;
            int position = this.getPosition();
            block0 : switch (this.token.tokenType) {
                case 55: {
                    this.read();
                    switch (this.token.tokenType) {
                        case 299: 
                        case 305: 
                        case 497: {
                            throw this.unexpectedToken();
                        }
                        case 598: {
                            int statementType = 1125;
                            String sql = this.getStatement(position, startStatementTokensSchema);
                            cs = new StatementSchema(sql, statementType);
                            break block0;
                        }
                        case 505: {
                            cs = this.compileCreateSequence();
                            cs.sql = this.getLastPart(position);
                            break block0;
                        }
                        case 490: {
                            cs = this.compileCreateRole();
                            cs.sql = this.getLastPart(position);
                            break block0;
                        }
                        case 393: {
                            int statementType = 23;
                            String sql = this.getStatement(position, startStatementTokensSchema);
                            cs = new StatementSchema(sql, statementType);
                            break block0;
                        }
                        case 535: {
                            cs = this.compileCreateType(false);
                            cs.sql = this.getLastPart(position);
                            break block0;
                        }
                        case 35: {
                            cs = this.compileCreateCharacterSet();
                            cs.sql = this.getLastPart(position);
                            break block0;
                        }
                        case 339: {
                            throw this.unexpectedToken();
                        }
                        case 120: 
                        case 278: 
                        case 523: 
                        case 570: 
                        case 608: 
                        case 632: 
                        case 633: {
                            int statementType = 77;
                            String sql = this.getStatement(position, startStatementTokensSchema);
                            cs = new StatementSchema(sql, statementType);
                            break block0;
                        }
                        case 291: {
                            int statementType = 80;
                            String sql = this.getStatement(position, startStatementTokensSchema);
                            cs = new StatementSchema(sql, statementType);
                            break block0;
                        }
                        case 545: {
                            int statementType = 84;
                            String sql = this.getStatement(position, startStatementTokensSchema);
                            cs = new StatementSchema(sql, statementType);
                            break block0;
                        }
                        case 117: {
                            int statementType = 14;
                            String sql = this.getStatementForRoutine(position, startStatementTokensSchema);
                            cs = new StatementSchema(sql, statementType);
                            break block0;
                        }
                        case 215: {
                            int statementType = 14;
                            String sql = this.getStatementForRoutine(position, startStatementTokensSchema);
                            cs = new StatementSchema(sql, statementType);
                            break block0;
                        }
                    }
                    throw this.unexpectedToken();
                }
                case 121: {
                    cs = this.compileGrantOrRevoke();
                    cs.sql = this.getLastPart(position);
                    break;
                }
                case 821: {
                    this.read();
                    end = true;
                    break;
                }
                case 872: {
                    end = true;
                    break;
                }
                default: {
                    throw this.unexpectedToken();
                }
            }
            if (cs == null) continue;
            cs.isSchemaDefinition = true;
            list.add(cs);
        }
    }

    StatementSchema compileCreateRole() {
        this.read();
        HsqlNameManager.HsqlName name = this.readNewUserIdentifier();
        String sql = this.getLastPart();
        Object[] args = new Object[]{name};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(sql, 61, args, null, writeLockNames);
    }

    StatementSchema compileCreateUser() {
        Boolean admin = Boolean.FALSE;
        Boolean isDigest = Boolean.FALSE;
        Grantee grantor = this.session.getGrantee();
        this.read();
        HsqlNameManager.HsqlName name = this.readNewUserIdentifier();
        this.readThis(616);
        if (this.readIfThis(586)) {
            isDigest = Boolean.TRUE;
        }
        String password = this.readPassword();
        if (this.token.tokenType == 335) {
            this.read();
            admin = Boolean.TRUE;
        }
        this.checkDatabaseUpdateAuthorisation();
        String sql = this.getLastPart();
        Object[] args = new Object[]{name, password, grantor, admin, isDigest};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(sql, 1126, args, null, writeLockNames);
    }

    HsqlNameManager.HsqlName readNewUserIdentifier() {
        this.checkIsSimpleName();
        String tokenS = this.token.tokenString;
        boolean isQuoted = this.isDelimitedIdentifier();
        if (tokenS.equalsIgnoreCase("SA")) {
            tokenS = "SA";
            isQuoted = false;
        }
        HsqlNameManager.HsqlName name = this.database.nameManager.newHsqlName(tokenS, isQuoted, 11);
        this.read();
        return name;
    }

    String readPassword() {
        String tokenS = this.token.tokenString;
        if (this.isUndelimitedSimpleName() || this.isDelimitedSimpleName()) {
            this.read();
        } else {
            this.readQuotedString();
        }
        return tokenS;
    }

    Statement compileRenameObject(HsqlNameManager.HsqlName name, int type) {
        HsqlNameManager.HsqlName newName = this.readNewSchemaObjectName(type, true);
        String sql = this.getLastPart();
        switch (type) {
            case 1: {
                break;
            }
            case 2: {
                this.checkSchemaUpdateAuthorisation(this.session, name);
                break;
            }
            default: {
                name.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
                this.checkSchemaUpdateAuthorisation(this.session, name.schema);
            }
        }
        Object[] args = new Object[]{name, newName};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogNameArray();
        return new StatementSchema(sql, 1152, args, null, writeLockNames);
    }

    Statement compileAlterTableAddUniqueConstraint(Table table, HsqlNameManager.HsqlName name) {
        if (name == null) {
            name = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
        }
        int[] cols = this.readColumnList(table, false);
        HsqlNameManager.HsqlName indexname = this.database.nameManager.newAutoName("IDX", name.name, table.getSchemaName(), table.getName(), 20);
        Index index = table.createIndexStructure(indexname, cols, null, null, true, true, false);
        Constraint c = new Constraint(name, table, index, 2);
        String sql = this.getLastPart();
        Object[] args = new Object[]{1134, table, c};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(sql, 4, args, null, writeLockNames);
    }

    Statement compileAlterTableAddForeignKeyConstraint(Table table, HsqlNameManager.HsqlName name) {
        if (name == null) {
            name = this.database.nameManager.newAutoName("FK", table.getSchemaName(), table.getName(), 5);
        }
        OrderedHashSet set = this.readColumnNames(false);
        Constraint c = this.readFKReferences(table, name, set);
        HsqlNameManager.HsqlName mainTableName = c.getMainTableName();
        c.core.mainTable = this.database.schemaManager.getUserTable(this.session, mainTableName.name, mainTableName.schema.name);
        c.setColumnsIndexes(table);
        if (c.core.mainCols.length != c.core.refCols.length) {
            throw Error.error(5593);
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{1134, table, c};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        if (mainTableName != table.getName()) {
            writeLockNames = (HsqlNameManager.HsqlName[])ArrayUtil.toAdjustedArray(writeLockNames, mainTableName, writeLockNames.length, 1);
        }
        return new StatementSchema(sql, 4, args, null, writeLockNames);
    }

    Statement compileAlterTableAddCheckConstraint(Table table, HsqlNameManager.HsqlName name) {
        if (name == null) {
            name = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
        }
        Constraint check = new Constraint(name, null, 3);
        this.readCheckConstraintCondition(check);
        String sql = this.getLastPart();
        Object[] args = new Object[]{1134, table, check};
        HsqlNameManager.HsqlName[] writeLockNames = new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()};
        return new StatementSchema(sql, 4, args, null, writeLockNames);
    }

    Statement compileAlterTableAddColumn(Table table) {
        int colIndex = table.getColumnCount();
        HsqlArrayList list = new HsqlArrayList();
        Constraint constraint = new Constraint(null, null, 5);
        list.add(constraint);
        this.checkIsSchemaObjectName();
        HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newColumnHsqlName(table.getName(), this.token.tokenString, this.isDelimitedIdentifier());
        this.read();
        ColumnSchema column = this.readColumnDefinitionOrNull(table, hsqlName, list);
        if (column == null) {
            throw Error.error(5000);
        }
        if (this.token.tokenType == 343) {
            this.read();
            colIndex = table.getColumnIndex(this.token.tokenString);
            this.read();
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{1133, table, column, new Integer(colIndex), list};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(sql, 4, args, null, writeLockNames);
    }

    Statement compileAlterTableAddPrimaryKey(Table table, HsqlNameManager.HsqlName name) {
        if (name == null) {
            name = this.session.database.nameManager.newAutoName("PK", table.getSchemaName(), table.getName(), 5);
        }
        OrderedHashSet set = this.readColumnNames(false);
        Constraint constraint = new Constraint(name, set, 4);
        constraint.setColumnsIndexes(table);
        String sql = this.getLastPart();
        Object[] args = new Object[]{1134, table, constraint};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(sql, 4, args, null, writeLockNames);
    }

    Statement compileAlterTableDropColumn(Table table, String colName, boolean cascade) {
        int colindex = table.getColumnIndex(colName);
        if (table.getColumnCount() == 1) {
            throw Error.error(5591);
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{table.getColumn(colindex).getName(), ValuePool.getInt(9), cascade, Boolean.FALSE};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(sql, 1128, args, null, writeLockNames);
    }

    Statement compileAlterColumn(Table table, ColumnSchema column, int columnIndex) {
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        int position = this.getPosition();
        switch (this.token.tokenType) {
            case 624: {
                this.read();
                this.readThis(285);
                return this.compileAlterColumnRename(table, column);
            }
            case 88: {
                this.read();
                if (this.token.tokenType == 78) {
                    this.read();
                    String sql = this.getLastPart();
                    Object[] args = new Object[]{1141, table, column, columnIndex};
                    return new StatementSchema(sql, 4, args, null, writeLockNames);
                }
                if (this.token.tokenType == 407) {
                    this.read();
                    String sql = this.getLastPart();
                    Object[] args = new Object[]{1142, table, column, columnIndex};
                    return new StatementSchema(sql, 4, args, null, writeLockNames);
                }
                throw this.unexpectedToken();
            }
            case 254: {
                this.read();
                switch (this.token.tokenType) {
                    case 378: {
                        this.read();
                        this.readThis(535);
                        return this.compileAlterColumnDataType(table, column);
                    }
                    case 78: {
                        this.read();
                        Type type = column.getDataType();
                        Expression expr = this.readDefaultClause(type);
                        String sql = this.getLastPart();
                        Object[] args = new Object[]{1140, table, column, columnIndex, expr};
                        return new StatementSchema(sql, 4, args, null, writeLockNames);
                    }
                    case 183: {
                        this.read();
                        this.readThis(186);
                        return this.compileAlterColumnSetNullability(table, column, false);
                    }
                    case 186: {
                        this.read();
                        return this.compileAlterColumnSetNullability(table, column, true);
                    }
                    case 407: {
                        return this.compileAlterColumnAddSequence(table, column, columnIndex);
                    }
                }
                this.rewind(position);
                this.read();
                break;
            }
            case 407: {
                return this.compileAlterColumnAddSequence(table, column, columnIndex);
            }
        }
        if (this.token.tokenType == 254 || this.token.tokenType == 484) {
            if (!column.isIdentity()) {
                throw Error.error(5535);
            }
            return this.compileAlterColumnSequenceOptions(table, column, columnIndex);
        }
        return this.compileAlterColumnDataTypeIdentity(table, column);
    }

    private Statement compileAlterColumnDataTypeIdentity(Table table, ColumnSchema column) {
        if (column.isGenerated()) {
            throw Error.error(5561);
        }
        NumberSequence sequence = column.getIdentitySequence();
        Type type = column.getDataType();
        if (this.token.tokenType == 128) {
            this.read();
            if (!type.isIntegralType()) {
                throw Error.error(5561);
            }
            if (sequence == null) {
                sequence = new NumberSequence(null, type);
            }
        } else {
            type = this.readTypeDefinition(true, true);
            switch (this.token.tokenType) {
                case 128: {
                    if (!type.isIntegralType()) {
                        throw Error.error(5561);
                    }
                    this.read();
                    if (sequence != null) break;
                    sequence = new NumberSequence(null, type);
                    break;
                }
                case 407: {
                    sequence = this.readSequence(column);
                    break;
                }
                default: {
                    sequence = null;
                }
            }
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{1143, table, column, type, sequence};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(sql, 4, args, null, writeLockNames);
    }

    private Statement compileAlterColumnDataType(Table table, ColumnSchema column) {
        if (column.isGenerated()) {
            throw Error.error(5561);
        }
        Type type = this.readTypeDefinition(true, true);
        if (column.isIdentity() && !type.isIntegralType()) {
            throw Error.error(5561);
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{1136, table, column, type};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(sql, 4, args, null, writeLockNames);
    }

    private Statement compileAlterColumnSetNullability(Table table, ColumnSchema column, boolean b) {
        String sql = this.getLastPart();
        Object[] args = new Object[]{1139, table, column, b};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(sql, 4, args, null, writeLockNames);
    }

    Statement compileAlterSequence() {
        this.read();
        HsqlNameManager.HsqlName schema = this.session.getSchemaHsqlName(this.token.namePrefix);
        NumberSequence sequence = this.database.schemaManager.getSequence(this.token.tokenString, schema.name, true);
        this.read();
        if (this.token.tokenType == 624) {
            this.read();
            this.readThis(285);
            return this.compileRenameObject(sequence.getName(), 7);
        }
        this.checkSchemaUpdateAuthorisation(this.session, sequence.getName().schema);
        NumberSequence copy = sequence.duplicate();
        this.readSequenceOptions(copy, false, true, false);
        String sql = this.getLastPart();
        Object[] args = new Object[]{sequence, copy};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogNameArray();
        return new StatementSchema(sql, 134, args, null, writeLockNames);
    }

    StatementSchema compileAlterColumnAddSequence(Table table, ColumnSchema column, int colIndex) {
        if (!column.getDataType().isIntegralType()) {
            throw Error.error(5525);
        }
        if (column.isIdentity()) {
            throw Error.error(5525);
        }
        NumberSequence sequence = this.readSequence(column);
        String sql = this.getLastPart();
        Object[] args = new Object[]{1137, table, column, colIndex, sequence};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(sql, 4, args, null, writeLockNames);
    }

    NumberSequence readSequence(ColumnSchema column) {
        this.readThis(407);
        NumberSequence sequence = new NumberSequence(null, column.getDataType());
        boolean generatedAlways = false;
        if (this.token.tokenType == 24) {
            this.read();
            this.readThis(78);
        } else {
            this.readThis(337);
            generatedAlways = true;
        }
        this.readThis(10);
        this.readThis(128);
        sequence.setAlways(generatedAlways);
        if (this.token.tokenType == 816) {
            this.read();
            this.readSequenceOptions(sequence, false, false, false);
            this.readThis(802);
        }
        sequence.checkValues();
        return sequence;
    }

    StatementSchema compileAlterColumnSequenceOptions(Table table, ColumnSchema column, int columnIndex) {
        boolean end;
        OrderedIntHashSet set = new OrderedIntHashSet();
        NumberSequence sequence = column.getIdentitySequence().duplicate();
        do {
            end = false;
            block0 : switch (this.token.tokenType) {
                case 484: {
                    long value;
                    if (!set.add(this.token.tokenType)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    if (this.readIfThis(319)) {
                        value = this.readBigint();
                        sequence.setCurrentValueNoCheck(value);
                        break;
                    }
                    sequence.reset();
                    break;
                }
                case 254: {
                    long value;
                    this.read();
                    switch (this.token.tokenType) {
                        case 417: {
                            if (!set.add(this.token.tokenType)) {
                                throw this.unexpectedToken();
                            }
                            this.read();
                            this.readThis(24);
                            value = this.readBigint();
                            sequence.setIncrement(value);
                            break block0;
                        }
                        case 180: {
                            this.read();
                            if (this.token.tokenType == 438) {
                                sequence.setDefaultMaxValue();
                            } else if (this.token.tokenType == 442) {
                                sequence.setDefaultMinValue();
                            } else if (this.token.tokenType == 71) {
                                sequence.setCycle(false);
                            } else {
                                throw this.unexpectedToken();
                            }
                            if (!set.add(this.token.tokenType)) {
                                throw this.unexpectedToken();
                            }
                            this.read();
                            break block0;
                        }
                        case 438: {
                            if (!set.add(this.token.tokenType)) {
                                throw this.unexpectedToken();
                            }
                            this.read();
                            value = this.readBigint();
                            sequence.setMaxValueNoCheck(value);
                            break block0;
                        }
                        case 442: {
                            if (!set.add(this.token.tokenType)) {
                                throw this.unexpectedToken();
                            }
                            this.read();
                            value = this.readBigint();
                            sequence.setMinValueNoCheck(value);
                            break block0;
                        }
                        case 71: {
                            if (!set.add(this.token.tokenType)) {
                                throw this.unexpectedToken();
                            }
                            this.read();
                            sequence.setCycle(true);
                            break block0;
                        }
                    }
                    throw this.unexpectedToken();
                }
                default: {
                    end = true;
                }
            }
        } while (!end);
        sequence.checkValues();
        String sql = this.getLastPart();
        Object[] args = new Object[]{1137, table, column, columnIndex, sequence};
        HsqlNameManager.HsqlName[] writeLockNames = new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()};
        return new StatementSchema(sql, 4, args, null, writeLockNames);
    }

    private Statement compileAlterColumnRename(Table table, ColumnSchema column) {
        this.checkIsSimpleName();
        HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(9, true);
        if (table.findColumn(name.name) > -1) {
            throw Error.error(5504, name.name);
        }
        this.database.schemaManager.checkColumnIsReferenced(table.getName(), column.getName());
        String sql = this.getLastPart();
        Object[] args = new Object[]{column.getName(), name};
        HsqlNameManager.HsqlName[] writeLockNames = new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()};
        return new StatementSchema(sql, 1152, args, null, writeLockNames);
    }

    Statement compileAlterSchemaRename() {
        HsqlNameManager.HsqlName name = this.readSchemaName();
        this.checkSchemaUpdateAuthorisation(name);
        this.readThis(624);
        this.readThis(285);
        HsqlNameManager.HsqlName newName = this.readNewSchemaName();
        String sql = this.getLastPart();
        Object[] args = new Object[]{name, newName};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogNameArray();
        return new StatementSchema(sql, 1152, args, null, writeLockNames);
    }

    Statement compileAlterUser() {
        this.read();
        HsqlNameManager.HsqlName userName = this.readNewUserIdentifier();
        User userObject = this.database.getUserManager().get(userName.name);
        if (userName.name.equals("PUBLIC")) {
            throw Error.error(5503);
        }
        if (userName.name.equals("_SYSTEM")) {
            throw Error.error(5503);
        }
        this.readThis(254);
        switch (this.token.tokenType) {
            case 157: {
                this.read();
                Boolean mode = this.processTrueOrFalseObject();
                Object[] args = new Object[]{userObject, mode};
                return new StatementCommand(1091, args);
            }
            case 616: {
                this.read();
                boolean isDigest = false;
                if (this.readIfThis(586)) {
                    isDigest = Boolean.TRUE;
                }
                String password = this.readPassword();
                Object[] args = new Object[]{userObject, password, isDigest};
                StatementCommand cs = new StatementCommand(1093, args);
                String sql = userObject.getSetUserPasswordDigestSQL(password, isDigest);
                cs.setSQL(sql);
                return cs;
            }
            case 599: {
                this.read();
                this.readThis(497);
                HsqlNameManager.HsqlName schemaName = this.token.tokenType == 78 ? null : this.database.schemaManager.getSchemaHsqlName(this.token.tokenString);
                this.read();
                Object[] args = new Object[]{userObject, schemaName};
                return new StatementCommand(1092, args);
            }
        }
        throw this.unexpectedToken();
    }

    Statement compileAlterDomain() {
        this.read();
        HsqlNameManager.HsqlName schema = this.session.getSchemaHsqlName(this.token.namePrefix);
        this.checkSchemaUpdateAuthorisation(schema);
        Type domain = this.database.schemaManager.getDomain(this.token.tokenString, schema.name, true);
        this.read();
        switch (this.token.tokenType) {
            case 624: {
                this.read();
                this.readThis(285);
                return this.compileRenameObject(domain.getName(), 13);
            }
            case 88: {
                this.read();
                if (this.token.tokenType == 78) {
                    this.read();
                    String sql = this.getLastPart();
                    Object[] args = new Object[]{1132, domain};
                    HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogAndBaseTableNames(domain.getName());
                    return new StatementSchema(sql, 3, args, null, writeLockNames);
                }
                if (this.token.tokenType == 48) {
                    this.read();
                    this.checkIsSchemaObjectName();
                    HsqlNameManager.HsqlName name = this.database.schemaManager.getSchemaObjectName(domain.getSchemaName(), this.token.tokenString, 5, true);
                    this.read();
                    String sql = this.getLastPart();
                    Object[] args = new Object[]{1130, domain, name};
                    HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogAndBaseTableNames(domain.getName());
                    return new StatementSchema(sql, 3, args, null, writeLockNames);
                }
                throw this.unexpectedToken();
            }
            case 254: {
                this.read();
                this.readThis(78);
                Expression e = this.readDefaultClause(domain);
                String sql = this.getLastPart();
                Object[] args = new Object[]{1135, domain, e};
                HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogAndBaseTableNames(domain.getName());
                return new StatementSchema(sql, 3, args, null, writeLockNames);
            }
            case 334: {
                this.read();
                if (this.token.tokenType != 48 && this.token.tokenType != 37) break;
                HsqlArrayList tempConstraints = new HsqlArrayList();
                this.compileContext.currentDomain = domain;
                this.readConstraint(domain, tempConstraints);
                this.compileContext.currentDomain = null;
                Constraint c = (Constraint)tempConstraints.get(0);
                String sql = this.getLastPart();
                Object[] args = new Object[]{1134, domain, c};
                HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogAndBaseTableNames(domain.getName());
                return new StatementSchema(sql, 3, args, null, writeLockNames);
            }
        }
        throw this.unexpectedToken();
    }

    private boolean isGrantToken() {
        switch (this.token.tokenType) {
            case 2: 
            case 79: 
            case 100: 
            case 135: 
            case 222: 
            case 251: 
            case 303: 
            case 540: {
                return true;
            }
        }
        return false;
    }

    StatementSchema compileGrantOrRevoke() {
        boolean grant = this.token.tokenType == 121;
        this.read();
        if (this.isGrantToken() || !grant && (this.token.tokenType == 121 || this.token.tokenType == 411)) {
            return this.compileRightGrantOrRevoke(grant);
        }
        return this.compileRoleGrantOrRevoke(grant);
    }

    private StatementSchema compileRightGrantOrRevoke(boolean grant) {
        OrderedHashSet granteeList = new OrderedHashSet();
        Grantee grantor = null;
        Right right = null;
        HsqlNameManager.HsqlName objectName = null;
        boolean isTable = false;
        boolean isUsage = false;
        boolean isExec = false;
        boolean isAll = false;
        boolean isGrantOption = false;
        boolean cascade = false;
        if (!grant) {
            if (this.token.tokenType == 121) {
                this.read();
                this.readThis(455);
                this.readThis(112);
                isGrantOption = true;
            } else if (this.token.tokenType == 411) {
                throw this.unsupportedFeature();
            }
        }
        if (this.token.tokenType == 2) {
            this.read();
            if (this.token.tokenType == 478) {
                this.read();
            }
            right = Right.fullRights;
            isAll = true;
        } else {
            right = new Right();
            boolean loop = true;
            block21: while (loop) {
                this.checkIsUndelimitedIdentifer();
                int rightType = GranteeManager.getCheckSingleRight(this.token.tokenString);
                int grantType = this.token.tokenType;
                OrderedHashSet columnSet = null;
                this.read();
                switch (grantType) {
                    case 135: 
                    case 222: 
                    case 251: 
                    case 303: {
                        if (this.token.tokenType == 816) {
                            columnSet = this.readColumnNames(false);
                        }
                    }
                    case 291: {
                        if (right == null) {
                            right = new Right();
                        }
                        right.set(rightType, columnSet);
                        isTable = true;
                        break;
                    }
                    case 79: {
                        if (right == null) {
                            right = new Right();
                        }
                        right.set(rightType, null);
                        isTable = true;
                        break;
                    }
                    case 540: {
                        if (isTable) {
                            throw this.unexpectedToken();
                        }
                        right = Right.fullRights;
                        isUsage = true;
                        loop = false;
                        continue block21;
                    }
                    case 100: {
                        if (isTable) {
                            throw this.unexpectedToken();
                        }
                        right = Right.fullRights;
                        isExec = true;
                        loop = false;
                        continue block21;
                    }
                }
                if (this.token.tokenType != 804) break;
                this.read();
            }
        }
        this.readThis(194);
        int objectType = 0;
        switch (this.token.tokenType) {
            case 574: {
                if (!isExec && !isAll) {
                    throw this.unexpectedToken();
                }
                this.read();
                if (!this.isSimpleName() || !this.isDelimitedIdentifier()) {
                    throw Error.error(5569);
                }
                objectType = 16;
                break;
            }
            case 259: {
                if (!isExec && !isAll) {
                    throw this.unexpectedToken();
                }
                this.read();
                switch (this.token.tokenType) {
                    case 117: 
                    case 215: 
                    case 491: {
                        this.read();
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                objectType = 24;
                break;
            }
            case 117: {
                if (!isExec && !isAll) {
                    throw this.unexpectedToken();
                }
                this.read();
                objectType = 16;
                break;
            }
            case 215: {
                if (!isExec && !isAll) {
                    throw this.unexpectedToken();
                }
                this.read();
                objectType = 17;
                break;
            }
            case 491: {
                if (!isExec && !isAll) {
                    throw this.unexpectedToken();
                }
                this.read();
                objectType = 18;
                break;
            }
            case 535: {
                if (!isUsage && !isAll) {
                    throw this.unexpectedToken();
                }
                this.read();
                objectType = 12;
                break;
            }
            case 393: {
                if (!isUsage && !isAll) {
                    throw this.unexpectedToken();
                }
                this.read();
                objectType = 13;
                break;
            }
            case 505: {
                if (!isUsage && !isAll) {
                    throw this.unexpectedToken();
                }
                this.read();
                objectType = 7;
                break;
            }
            case 35: {
                if (!isUsage && !isAll) {
                    throw this.unexpectedToken();
                }
                this.read();
                this.readThis(254);
                objectType = 14;
                break;
            }
            default: {
                if (!isTable && !isAll) {
                    throw this.unexpectedToken();
                }
                this.readIfThis(278);
                objectType = 3;
            }
        }
        objectName = this.readNewSchemaObjectName(objectType, false);
        if (grant) {
            this.readThis(285);
        } else {
            this.readThis(115);
        }
        while (true) {
            this.checkIsSimpleName();
            granteeList.add(this.token.tokenString);
            this.read();
            if (this.token.tokenType != 804) break;
            this.read();
        }
        if (grant) {
            if (this.token.tokenType == 319) {
                this.read();
                this.readThis(121);
                this.readThis(455);
                isGrantOption = true;
            }
            if (this.token.tokenType == 410) {
                this.read();
                this.readThis(24);
                if (this.token.tokenType == 69) {
                    this.read();
                } else {
                    this.readThis(64);
                    if (this.session.getRole() == null) {
                        throw Error.error(2200);
                    }
                    grantor = this.session.getRole();
                }
            }
        } else if (this.token.tokenType == 347) {
            cascade = true;
            this.read();
        } else {
            this.readThis(485);
        }
        String sql = this.getLastPart();
        int type = grant ? 48 : 59;
        Object[] args = new Object[]{granteeList, objectName, right, grantor, cascade, isGrantOption};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogNameArray();
        StatementSchema cs = new StatementSchema(sql, type, args, null, writeLockNames);
        return cs;
    }

    private StatementSchema compileRoleGrantOrRevoke(boolean grant) {
        Grantee grantor = this.session.getGrantee();
        OrderedHashSet roleList = new OrderedHashSet();
        OrderedHashSet granteeList = new OrderedHashSet();
        boolean cascade = false;
        if (!grant && this.token.tokenType == 335) {
            throw this.unsupportedFeature();
        }
        while (true) {
            this.checkIsSimpleName();
            roleList.add(this.token.tokenString);
            this.read();
            if (this.token.tokenType != 804) break;
            this.read();
        }
        if (grant) {
            this.readThis(285);
        } else {
            this.readThis(115);
        }
        while (true) {
            this.checkIsSimpleName();
            granteeList.add(this.token.tokenString);
            this.read();
            if (this.token.tokenType != 804) break;
            this.read();
        }
        if (grant && this.token.tokenType == 319) {
            throw this.unsupportedFeature();
        }
        if (this.token.tokenType == 410) {
            this.read();
            this.readThis(24);
            if (this.token.tokenType == 69) {
                this.read();
            } else {
                this.readThis(64);
                if (this.session.getRole() == null) {
                    throw Error.error(2200);
                }
                grantor = this.session.getRole();
            }
        }
        if (!grant) {
            if (this.token.tokenType == 347) {
                cascade = true;
                this.read();
            } else {
                this.readThis(485);
            }
        }
        String sql = this.getLastPart();
        int type = grant ? 49 : 129;
        Object[] args = new Object[]{granteeList, roleList, grantor, cascade};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogNameArray();
        StatementSchema cs = new StatementSchema(sql, type, args, null, writeLockNames);
        return cs;
    }

    void checkDatabaseUpdateAuthorisation() {
        this.session.checkAdmin();
        this.session.checkDDLWrite();
    }

    void checkSchemaUpdateAuthorisation(Session session, HsqlNameManager.HsqlName schema) {
        if (session.isProcessingLog()) {
            return;
        }
        if (SqlInvariants.isSystemSchemaName(schema.name)) {
            throw Error.error(5503);
        }
        if (session.parser.isSchemaDefinition) {
            if (schema == session.getCurrentSchemaHsqlName()) {
                return;
            }
            Error.error(5505, schema.name);
        }
        session.getGrantee().checkSchemaUpdateOrGrantRights(schema.name);
        session.checkDDLWrite();
    }

    StatementSchema compileComment() {
        HsqlNameManager.HsqlName name;
        this.readThis(576);
        this.readThis(194);
        switch (this.token.tokenType) {
            case 278: 
            case 491: {
                int type = this.token.tokenType == 491 ? 18 : 3;
                this.read();
                this.checkIsSchemaObjectName();
                name = this.database.nameManager.newHsqlName(this.token.tokenString, this.token.isDelimitedIdentifier, type);
                name.schema = this.token.namePrefix == null ? this.session.getCurrentSchemaHsqlName() : this.database.nameManager.newHsqlName(this.token.namePrefix, this.token.isDelimitedPrefix, 2);
                this.read();
                break;
            }
            case 43: {
                this.read();
                this.checkIsSchemaObjectName();
                name = this.database.nameManager.newHsqlName(this.token.tokenString, this.token.isDelimitedIdentifier, 9);
                if (this.token.namePrefix == null) {
                    throw Error.error(5501);
                }
                name.parent = this.database.nameManager.newHsqlName(this.token.namePrefix, this.token.isDelimitedPrefix, 3);
                name.parent.schema = this.token.namePrePrefix == null ? this.session.getCurrentSchemaHsqlName() : this.database.nameManager.newHsqlName(this.token.namePrePrefix, this.token.isDelimitedPrePrefix, 3);
                this.read();
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        this.readThis(142);
        String comment = this.readQuotedString();
        Object[] arguments = new Object[]{name, comment};
        return new StatementSchema(null, 1123, arguments, null, null);
    }

    Statement compileAlterSession() {
        this.read();
        this.session.checkAdmin();
        if (this.token.tokenType == 625) {
            this.read();
            int action = this.token.tokenType;
            switch (this.token.tokenType) {
                case 2: {
                    this.read();
                    break;
                }
                case 236: {
                    this.read();
                    this.readThis(510);
                    break;
                }
                case 278: {
                    this.read();
                    this.readThis(378);
                    break;
                }
                default: {
                    throw this.unexpectedTokenRequire("ALL,RESULT,TABLE");
                }
            }
            Object[] args = new Object[]{this.session.getId(), action};
            return new StatementCommand(1005, args);
        }
        long sessionID = this.readBigint();
        Session targetSession = this.database.sessionManager.getSession(sessionID);
        if (targetSession == null) {
            throw Error.error(4500);
        }
        int action = this.token.tokenType;
        switch (this.token.tokenType) {
            case 39: {
                this.read();
                break;
            }
            case 233: {
                this.read();
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        Object[] args = new Object[]{sessionID, action};
        return new StatementCommand(1005, args);
    }

    boolean processTrueOrFalse() {
        if (this.token.namePrefix != null) {
            throw this.unexpectedToken();
        }
        if (this.token.tokenType == 294) {
            this.read();
            return true;
        }
        if (this.token.tokenType == 106) {
            this.read();
            return false;
        }
        throw this.unexpectedToken();
    }

    Boolean processTrueOrFalseObject() {
        return this.processTrueOrFalse();
    }
}

