/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.error.Error;
import org.hsqldb.result.Result;

public class HsqlException
extends RuntimeException {
    public static final HsqlException[] emptyArray = new HsqlException[0];
    public static final HsqlException noDataCondition = Error.error(1100);
    private String message;
    private String state;
    private int code;
    private int level;
    private int statementGroup;
    private int statementCode;
    public Object info;

    public HsqlException(Throwable t, String message, String state, int code) {
        super(t);
        this.message = message;
        this.state = state;
        this.code = code;
    }

    public HsqlException(Result r) {
        this.message = r.getMainString();
        this.state = r.getSubString();
        this.code = r.getErrorCode();
    }

    public HsqlException(Throwable t, String errorState, int errorCode) {
        super(t);
        this.message = t.toString();
        this.state = errorState;
        this.code = errorCode;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getSQLState() {
        return this.state;
    }

    public int getErrorCode() {
        return this.code;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    public int getStatementCode() {
        return this.statementCode;
    }

    public void setStatementType(int group, int code) {
        this.statementGroup = group;
        this.statementCode = code;
    }

    public int hashCode() {
        return this.code;
    }

    public boolean equals(Object other) {
        if (other instanceof HsqlException) {
            HsqlException o = (HsqlException)other;
            return this.code == o.code && HsqlException.equals(this.state, o.state) && HsqlException.equals(this.message, o.message);
        }
        return false;
    }

    private static boolean equals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public static class HsqlRuntimeMemoryError
    extends OutOfMemoryError {
        HsqlRuntimeMemoryError() {
        }
    }
}

