/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.RangeGroup;
import org.hsqldb.RangeVariable;
import org.hsqldb.Session;
import org.hsqldb.TableDerived;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayListIdentity;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.Set;
import org.hsqldb.map.ValuePool;
import org.hsqldb.navigator.RangeIterator;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.types.Type;

public class ExpressionColumn
extends Expression {
    public static final ExpressionColumn[] emptyArray = new ExpressionColumn[0];
    static final HsqlNameManager.SimpleName rownumName = HsqlNameManager.getSimpleName("ROWNUM", false);
    public static final HashMappedList diagnosticsList = new HashMappedList();
    static final String[] diagnosticsVariableTokens = new String[]{"NUMBER", "MORE", "ROW_COUNT"};
    public static final int idx_number = 0;
    public static final int idx_more = 1;
    public static final int idx_row_count = 2;
    ColumnSchema column;
    String schema;
    String tableName;
    String columnName;
    RangeVariable rangeVariable;
    NumberSequence sequence;
    boolean isWritable;
    boolean isParam;

    ExpressionColumn(String schema, String table, String column) {
        super(2);
        this.schema = schema;
        this.tableName = table;
        this.columnName = column;
    }

    ExpressionColumn(ColumnSchema column) {
        super(2);
        this.column = column;
        this.dataType = column.getDataType();
        this.columnName = column.getName().name;
    }

    ExpressionColumn(RangeVariable rangeVar, int index) {
        super(2);
        this.columnIndex = index;
        this.setAutoAttributesAsColumn(rangeVar, this.columnIndex);
    }

    ExpressionColumn(Expression e, int colIndex, int rangePosition) {
        super(5);
        this.dataType = e.dataType;
        this.columnIndex = colIndex;
        this.alias = e.alias;
        this.rangePosition = rangePosition;
    }

    ExpressionColumn() {
        super(11);
    }

    ExpressionColumn(int type) {
        super(type);
        if (type == 8) {
            this.isParam = true;
        } else if (type == 14) {
            this.columnName = ExpressionColumn.rownumName.name;
            this.dataType = Type.SQL_INTEGER;
        }
    }

    ExpressionColumn(int type, int columnIndex) {
        super(type);
        this.column = (ColumnSchema)diagnosticsList.get(columnIndex);
        this.columnIndex = columnIndex;
        this.dataType = this.column.dataType;
    }

    ExpressionColumn(Expression[] nodes, String name) {
        super(3);
        this.nodes = nodes;
        this.columnName = name;
    }

    ExpressionColumn(String schema, String table) {
        super(97);
        this.schema = schema;
        this.tableName = table;
    }

    ExpressionColumn(NumberSequence sequence, int opType) {
        super(opType);
        this.sequence = sequence;
        this.dataType = sequence.getDataType();
    }

    void setAutoAttributesAsColumn(RangeVariable range, int i) {
        this.columnIndex = i;
        this.column = range.getColumn(i);
        this.dataType = this.column.getDataType();
        this.columnName = range.getColumnAlias((int)i).name;
        this.tableName = range.getTableAlias().name;
        this.rangeVariable = range;
        this.rangeVariable.addColumn(this.columnIndex);
    }

    void setAttributesAsColumn(RangeVariable range, int i) {
        this.columnIndex = i;
        this.column = range.getColumn(i);
        this.dataType = this.column.getDataType();
        this.rangeVariable = range;
        this.rangeVariable.addColumn(this.columnIndex);
    }

    @Override
    public byte getNullability() {
        switch (this.opType) {
            case 2: {
                if (this.nullability == 2) {
                    return this.column.getNullability();
                }
                return this.nullability;
            }
            case 3: 
            case 12: 
            case 14: {
                return 0;
            }
        }
        return 2;
    }

    @Override
    void setAttributesAsColumn(ColumnSchema column, boolean isWritable) {
        this.column = column;
        this.dataType = column.getDataType();
        this.isWritable = isWritable;
    }

    @Override
    HsqlNameManager.SimpleName getSimpleName() {
        if (this.alias != null) {
            return this.alias;
        }
        if (this.rangeVariable != null && this.rangeVariable.hasColumnAlias()) {
            return this.rangeVariable.getColumnAlias(this.columnIndex);
        }
        if (this.column != null) {
            return this.column.getName();
        }
        if (this.opType == 3) {
            return this.nodes[0].getSimpleName();
        }
        if (this.opType == 14) {
            return rownumName;
        }
        return null;
    }

    @Override
    String getAlias() {
        if (this.alias != null) {
            return this.alias.name;
        }
        switch (this.opType) {
            case 2: 
            case 3: 
            case 14: {
                return this.columnName;
            }
        }
        return "";
    }

    @Override
    void collectObjectNames(Set set) {
        switch (this.opType) {
            case 12: {
                HsqlNameManager.HsqlName name = this.sequence.getName();
                set.add(name);
                return;
            }
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 97: {
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 2: {
                set.add(this.column.getName());
                if (this.column.getName().parent != null) {
                    set.add(this.column.getName().parent);
                }
                return;
            }
        }
    }

    @Override
    String getColumnName() {
        switch (this.opType) {
            case 2: 
            case 6: 
            case 7: {
                if (this.column != null) {
                    return this.column.getName().name;
                }
                if (this.columnName == null) break;
                return this.columnName;
            }
        }
        return this.getAlias();
    }

    @Override
    public ColumnSchema getColumn() {
        return this.column;
    }

    String getSchemaName() {
        return this.schema;
    }

    @Override
    RangeVariable getRangeVariable() {
        return this.rangeVariable;
    }

    @Override
    public HsqlList resolveColumnReferences(Session session, RangeGroup rangeGroup, int rangeCount, RangeGroup[] rangeGroups, HsqlList unresolvedSet, boolean acceptsSequences) {
        switch (this.opType) {
            case 12: {
                if (acceptsSequences) break;
                throw Error.error(5598);
            }
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 97: {
                break;
            }
            case 3: {
                for (int i = 0; i < this.nodes.length; ++i) {
                    this.nodes[i].resolveColumnReferences(session, rangeGroup, rangeGroups, unresolvedSet);
                }
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                boolean resolved = false;
                boolean tableQualified = this.tableName != null;
                RangeVariable[] rangeVarArray = rangeGroup.getRangeVariables();
                if (this.rangeVariable != null) {
                    return unresolvedSet;
                }
                for (int i = 0; i < rangeCount; ++i) {
                    RangeVariable rangeVar = rangeVarArray[i];
                    if (rangeVar == null) continue;
                    if (resolved) {
                        if (!session.database.sqlEnforceRefs || !this.resolvesDuplicateColumnReference(rangeVar)) continue;
                        String message = this.getColumnName();
                        if (this.alias != null) {
                            StringBuffer sb = new StringBuffer(message);
                            sb.append(' ').append("AS").append(' ').append(this.alias.getStatementName());
                            message = sb.toString();
                        }
                        throw Error.error(5580, message);
                    }
                    if (!this.resolveColumnReference(rangeVar, false)) continue;
                    resolved = true;
                    if (!session.database.sqlEnforceRefs) break;
                }
                if (resolved) {
                    return unresolvedSet;
                }
                if ((session.database.sqlSyntaxOra || session.database.sqlSyntaxDb2) && acceptsSequences && this.tableName != null) {
                    NumberSequence seq;
                    if ("CURRVAL".equals(this.columnName) || "PREVVAL".equals(this.columnName)) {
                        NumberSequence seq2 = session.database.schemaManager.getSequence(this.tableName, session.getSchemaName(this.schema), false);
                        if (seq2 != null) {
                            this.opType = 13;
                            this.dataType = seq2.getDataType();
                            this.sequence = seq2;
                            this.schema = null;
                            this.tableName = null;
                            this.columnName = null;
                            resolved = true;
                        }
                    } else if ("NEXTVAL".equals(this.columnName) && (seq = session.database.schemaManager.getSequence(this.tableName, session.getSchemaName(this.schema), false)) != null) {
                        this.opType = 12;
                        this.dataType = seq.getDataType();
                        this.sequence = seq;
                        this.schema = null;
                        this.tableName = null;
                        this.columnName = null;
                        resolved = true;
                    }
                }
                if (resolved) {
                    return unresolvedSet;
                }
                if (this.resolveCorrelated(rangeGroup, rangeGroups)) {
                    return unresolvedSet;
                }
                if (unresolvedSet == null) {
                    unresolvedSet = new ArrayListIdentity();
                }
                unresolvedSet.add(this);
            }
        }
        return unresolvedSet;
    }

    private boolean resolveCorrelated(RangeGroup rangeGroup, RangeGroup[] rangeGroups) {
        for (int idx = rangeGroups.length - 1; idx >= 0; --idx) {
            RangeVariable[] rangeVarArray = rangeGroups[idx].getRangeVariables();
            for (int i = 0; i < rangeVarArray.length; ++i) {
                RangeVariable rangeVar = rangeVarArray[i];
                if (rangeVar == null || !this.resolveColumnReference(rangeVar, true)) continue;
                if (this.opType == 2) {
                    rangeGroup.setCorrelated();
                    for (int idxx = rangeGroups.length - 1; idxx > idx; --idxx) {
                        rangeGroups[idxx].setCorrelated();
                    }
                }
                return true;
            }
        }
        return false;
    }

    private boolean resolveColumnReference(RangeVariable rangeVar, boolean outer) {
        ExpressionColumn e;
        if (this.tableName == null && (e = rangeVar.getColumnExpression(this.columnName)) != null) {
            this.opType = e.opType;
            this.nodes = e.nodes;
            this.dataType = e.dataType;
            return true;
        }
        int colIndex = rangeVar.findColumn(this.schema, this.tableName, this.columnName);
        if (colIndex == -1) {
            return false;
        }
        switch (rangeVar.rangeType) {
            case 3: 
            case 4: {
                if (this.tableName != null) {
                    return false;
                }
                ColumnSchema column = rangeVar.getColumn(colIndex);
                if (column.getParameterMode() == 4) {
                    return false;
                }
                this.opType = rangeVar.rangeType == 4 ? 6 : 7;
                break;
            }
            case 2: {
                if (this.tableName == null) {
                    return false;
                }
                if (this.schema != null) {
                    return false;
                }
                this.opType = 9;
                break;
            }
        }
        this.setAttributesAsColumn(rangeVar, colIndex);
        return true;
    }

    boolean resolvesDuplicateColumnReference(RangeVariable rangeVar) {
        ExpressionColumn e;
        if (this.tableName == null && (e = rangeVar.getColumnExpression(this.columnName)) != null) {
            return false;
        }
        switch (rangeVar.rangeType) {
            case 2: 
            case 3: 
            case 4: {
                return false;
            }
        }
        int colIndex = rangeVar.findColumn(this.schema, this.tableName, this.columnName);
        return colIndex != -1;
    }

    @Override
    public void resolveTypes(Session session, Expression parent) {
        switch (this.opType) {
            case 4: {
                if (parent == null || parent.opType == 25) break;
                throw Error.error(5544);
            }
            case 3: {
                Type type = null;
                this.nullability = 0;
                for (int i = 0; i < this.nodes.length; ++i) {
                    type = Type.getAggregateType(this.nodes[i].dataType, type);
                }
                this.dataType = type;
                break;
            }
        }
    }

    @Override
    public Object getValue(Session session) {
        switch (this.opType) {
            case 4: {
                return null;
            }
            case 10: {
                return this.getDiagnosticsVariable(session);
            }
            case 6: {
                return session.sessionContext.routineVariables[this.columnIndex];
            }
            case 7: {
                return session.sessionContext.routineArguments[this.columnIndex];
            }
            case 9: {
                return session.sessionContext.triggerArguments[this.rangeVariable.rangePosition][this.columnIndex];
            }
            case 2: {
                RangeIterator[] iterators = session.sessionContext.rangeIterators;
                Object value = iterators[this.rangeVariable.rangePosition].getCurrent(this.columnIndex);
                if (this.dataType != this.column.dataType) {
                    value = this.dataType.convertToType(session, value, this.column.dataType);
                }
                return value;
            }
            case 5: {
                Object value = session.sessionContext.rangeIterators[this.rangePosition].getCurrent(this.columnIndex);
                return value;
            }
            case 3: {
                Object value = null;
                for (int i = 0; i < this.nodes.length; ++i) {
                    value = this.nodes[i].getValue(session, this.dataType);
                    if (value == null) continue;
                    return value;
                }
                return value;
            }
            case 8: {
                return session.sessionContext.dynamicArguments[this.parameterIndex];
            }
            case 12: {
                return session.sessionData.getSequenceValue(this.sequence);
            }
            case 13: {
                return session.sessionData.getSequenceCurrent(this.sequence);
            }
            case 14: {
                return ValuePool.getInt(session.sessionContext.rownum);
            }
        }
        throw Error.runtimeError(201, "ExpressionColumn");
    }

    private Object getDiagnosticsVariable(Session session) {
        return session.sessionContext.diagnosticsVariables[this.columnIndex];
    }

    @Override
    public String getSQL() {
        switch (this.opType) {
            case 4: {
                return "DEFAULT";
            }
            case 8: {
                return "?";
            }
            case 11: {
                return "*";
            }
            case 3: {
                if (this.alias != null) {
                    return this.alias.getStatementName();
                }
                return "COALESCE";
            }
            case 6: 
            case 7: 
            case 10: {
                return this.column.getName().statementName;
            }
            case 14: {
                StringBuffer sb = new StringBuffer("ROWNUM");
                sb.append('(').append(')');
                return sb.toString();
            }
            case 2: {
                if (this.column == null) {
                    if (this.alias != null) {
                        return this.alias.getStatementName();
                    }
                    if (this.tableName == null) {
                        return this.columnName;
                    }
                    StringBuffer sb = new StringBuffer();
                    sb.append(this.tableName);
                    sb.append('.');
                    sb.append(this.columnName);
                    return sb.toString();
                }
                if (this.rangeVariable.tableAlias == null) {
                    return this.column.getName().getSchemaQualifiedStatementName();
                }
                StringBuffer sb = new StringBuffer();
                sb.append(this.rangeVariable.tableAlias.getStatementName());
                sb.append('.');
                sb.append(this.column.getName().statementName);
                return sb.toString();
            }
            case 97: {
                if (this.nodes.length == 0) {
                    return "*";
                }
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < this.nodes.length; ++i) {
                    Expression e = this.nodes[i];
                    if (i > 0) {
                        sb.append(',');
                    }
                    String s = e.getSQL();
                    sb.append(s);
                }
                return sb.toString();
            }
        }
        throw Error.runtimeError(201, "ExpressionColumn");
    }

    @Override
    protected String describe(Session session, int blanks) {
        StringBuffer sb = new StringBuffer(64);
        for (int i = 0; i < blanks; ++i) {
            sb.append(' ');
        }
        switch (this.opType) {
            case 4: {
                sb.append("DEFAULT");
                break;
            }
            case 11: {
                sb.append("OpTypes.ASTERISK ");
                break;
            }
            case 6: {
                sb.append("VARIABLE: ");
                sb.append(this.column.getName().name);
                break;
            }
            case 7: {
                sb.append("PARAMETER").append(": ");
                sb.append(this.column.getName().name);
                break;
            }
            case 3: {
                sb.append("COLUMN").append(": ");
                sb.append(this.columnName);
                if (this.alias == null) break;
                sb.append(" AS ").append(this.alias.name);
                break;
            }
            case 2: {
                sb.append("COLUMN").append(": ");
                sb.append(this.column.getName().getSchemaQualifiedStatementName());
                if (this.alias == null) break;
                sb.append(" AS ").append(this.alias.name);
                break;
            }
            case 8: {
                sb.append("DYNAMIC PARAM: ");
                sb.append(", TYPE = ").append(this.dataType.getNameString());
                break;
            }
            case 12: {
                sb.append("SEQUENCE").append(": ");
                sb.append(this.sequence.getName().name);
                break;
            }
        }
        sb.append('\n');
        return sb.toString();
    }

    String getTableName() {
        if (this.opType == 97) {
            return this.tableName;
        }
        if (this.opType == 2) {
            if (this.rangeVariable == null) {
                return this.tableName;
            }
            return this.rangeVariable.getTable().getName().name;
        }
        return "";
    }

    static void checkColumnsResolved(HsqlList set) {
        if (set != null && !set.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            Expression e = (Expression)set.get(0);
            if (e instanceof ExpressionColumn) {
                ExpressionColumn c = (ExpressionColumn)e;
                if (c.schema != null) {
                    sb.append(c.schema + '.');
                }
                if (c.tableName != null) {
                    sb.append(c.tableName + '.');
                }
                sb.append(c.getColumnName());
                throw Error.error(5501, sb.toString());
            }
            OrderedHashSet newSet = new OrderedHashSet();
            e.collectAllExpressions(newSet, Expression.columnExpressionSet, Expression.emptyExpressionSet);
            ExpressionColumn.checkColumnsResolved(newSet);
            throw Error.error(5501);
        }
    }

    @Override
    public OrderedHashSet getUnkeyedColumns(OrderedHashSet unresolvedSet) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            unresolvedSet = this.nodes[i].getUnkeyedColumns(unresolvedSet);
        }
        if (this.opType == 2 && !this.rangeVariable.hasKeyedColumnInGroupBy) {
            if (unresolvedSet == null) {
                unresolvedSet = new OrderedHashSet();
            }
            unresolvedSet.add(this);
        }
        return unresolvedSet;
    }

    @Override
    OrderedHashSet collectRangeVariables(OrderedHashSet set) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            set = this.nodes[i].collectRangeVariables(set);
        }
        if (this.rangeVariable != null) {
            if (set == null) {
                set = new OrderedHashSet();
            }
            set.add(this.rangeVariable);
        }
        return set;
    }

    @Override
    OrderedHashSet collectRangeVariables(RangeVariable[] rangeVariables, OrderedHashSet set) {
        int i;
        for (i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            set = this.nodes[i].collectRangeVariables(rangeVariables, set);
        }
        if (this.rangeVariable != null) {
            for (i = 0; i < rangeVariables.length; ++i) {
                if (rangeVariables[i] != this.rangeVariable) continue;
                if (set == null) {
                    set = new OrderedHashSet();
                }
                set.add(this.rangeVariable);
                break;
            }
        }
        return set;
    }

    @Override
    Expression replaceAliasInOrderBy(Session session, Expression[] columns, int length) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i] = this.nodes[i].replaceAliasInOrderBy(session, columns, length);
        }
        switch (this.opType) {
            case 2: 
            case 3: {
                int i;
                int matchIndex = -1;
                for (i = 0; i < length; ++i) {
                    String alias;
                    HsqlNameManager.SimpleName aliasName = columns[i].alias;
                    String string = alias = aliasName == null ? null : aliasName.name;
                    if (this.schema != null || this.tableName != null || !this.columnName.equals(alias)) continue;
                    if (matchIndex < 0) {
                        matchIndex = i;
                        continue;
                    }
                    if (!session.database.sqlEnforceRefs) continue;
                    String message = this.getColumnName();
                    throw Error.error(5580, message);
                }
                if (matchIndex >= 0) {
                    return columns[matchIndex];
                }
                for (i = 0; i < length; ++i) {
                    String message;
                    if (!(columns[i] instanceof ExpressionColumn)) continue;
                    if (this.equals(columns[i])) {
                        if (matchIndex < 0) {
                            matchIndex = i;
                        } else if (session.database.sqlEnforceRefs) {
                            message = this.getColumnName();
                            throw Error.error(5580, message);
                        }
                    }
                    if (this.tableName != null || this.schema != null || !this.columnName.equals(((ExpressionColumn)columns[i]).columnName)) continue;
                    if (matchIndex < 0) {
                        matchIndex = i;
                        continue;
                    }
                    if (!session.database.sqlEnforceRefs) continue;
                    message = this.getColumnName();
                    throw Error.error(5580, message);
                }
                if (matchIndex < 0) break;
                return columns[matchIndex];
            }
        }
        return this;
    }

    @Override
    Expression replaceColumnReferences(RangeVariable range, Expression[] list) {
        if (this.opType == 2 && this.rangeVariable == range) {
            return list[this.columnIndex];
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i] = this.nodes[i].replaceColumnReferences(range, list);
        }
        return this;
    }

    @Override
    boolean hasReference(RangeVariable range) {
        if (range == this.rangeVariable) {
            return true;
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null || !this.nodes[i].hasReference(range)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Expression other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.opType != other.opType) {
            return false;
        }
        switch (this.opType) {
            case 5: {
                return this.columnIndex == other.columnIndex;
            }
            case 3: {
                return this.nodes == other.nodes;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                return this.column == other.getColumn() && this.rangeVariable == other.getRangeVariable();
            }
        }
        return false;
    }

    @Override
    void replaceRangeVariables(RangeVariable[] ranges, RangeVariable[] newRanges) {
        int i;
        for (i = 0; i < this.nodes.length; ++i) {
            this.nodes[i].replaceRangeVariables(ranges, newRanges);
        }
        for (i = 0; i < ranges.length; ++i) {
            if (this.rangeVariable != ranges[i]) continue;
            this.rangeVariable = newRanges[i];
            break;
        }
    }

    @Override
    void resetColumnReferences() {
        this.rangeVariable = null;
        this.columnIndex = -1;
    }

    @Override
    public boolean isIndexable(RangeVariable range) {
        if (this.opType == 2) {
            return this.rangeVariable == range;
        }
        return false;
    }

    @Override
    public boolean isUnresolvedParam() {
        return this.isParam && this.dataType == null;
    }

    @Override
    boolean isDynamicParam() {
        return this.isParam;
    }

    @Override
    void getJoinRangeVariables(RangeVariable[] ranges, HsqlList list) {
        if (this.opType == 2) {
            for (int i = 0; i < ranges.length; ++i) {
                if (ranges[i] != this.rangeVariable) continue;
                list.add(this.rangeVariable);
                return;
            }
        }
    }

    @Override
    double costFactor(Session session, RangeVariable range, int operation) {
        double factor;
        if (range.rangeTable instanceof TableDerived) {
            return 1024.0;
        }
        PersistentStore store = range.rangeTable.getRowStore(session);
        int indexType = range.rangeTable.indexTypeForColumn(session, this.columnIndex);
        switch (indexType) {
            case 2: {
                if (operation == 40) {
                    factor = 1.0;
                    break;
                }
                factor = (double)store.elementCount() / 2.0;
                break;
            }
            case 1: {
                if (operation == 40) {
                    factor = (double)store.elementCount() / 8.0;
                    if (!(factor > 1024.0)) break;
                    factor = 1024.0;
                    break;
                }
                factor = (double)store.elementCount() / 2.0;
                break;
            }
            default: {
                factor = store.elementCount();
            }
        }
        return factor < 16.0 ? 16.0 : factor;
    }

    @Override
    public Expression duplicate() {
        if (this.opType == 7) {
            return this;
        }
        return super.duplicate();
    }

    static {
        for (int i = 0; i < diagnosticsVariableTokens.length; ++i) {
            HsqlNameManager.HsqlName name = HsqlNameManager.newSystemObjectName(diagnosticsVariableTokens[i], 22);
            Type type = Type.SQL_INTEGER;
            if (diagnosticsVariableTokens[i] == "MORE") {
                type = Type.SQL_CHAR;
            }
            ColumnSchema col = new ColumnSchema(name, type, false, false, null);
            diagnosticsList.add(diagnosticsVariableTokens[i], col);
        }
    }
}

