/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.ConstraintCore;
import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDQL;
import org.hsqldb.QuerySpecification;
import org.hsqldb.RangeVariable;
import org.hsqldb.Row;
import org.hsqldb.Scanner;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;
import org.hsqldb.rights.Grantee;
import org.hsqldb.types.Type;

public final class Constraint
implements SchemaObject {
    ConstraintCore core;
    private HsqlNameManager.HsqlName name;
    int constType;
    boolean isForward;
    Expression check;
    private boolean isNotNull;
    int notNullColumnIndex;
    RangeVariable rangeVariable;
    OrderedHashSet mainColSet;
    OrderedHashSet refColSet;
    public static final Constraint[] emptyArray = new Constraint[0];

    private Constraint() {
    }

    public Constraint(HsqlNameManager.HsqlName name, Table t, Index index, int type) {
        this.name = name;
        this.constType = type;
        this.core = new ConstraintCore();
        this.core.mainTable = t;
        this.core.mainIndex = index;
        this.core.mainCols = index.getColumns();
        for (int i = 0; i < this.core.mainCols.length; ++i) {
            Type dataType = t.getColumn(this.core.mainCols[i]).getDataType();
            if (!dataType.isLobType()) continue;
            throw Error.error(5534);
        }
    }

    public Constraint(HsqlNameManager.HsqlName name, Table table, int[] cols, int type) {
        this.name = name;
        this.constType = type;
        this.core = new ConstraintCore();
        this.core.mainTable = table;
        this.core.mainCols = cols;
    }

    public Constraint(HsqlNameManager.HsqlName name, Constraint fkconstraint) {
        this.name = name;
        this.constType = 1;
        this.core = fkconstraint.core;
    }

    public Constraint(HsqlNameManager.HsqlName name, HsqlNameManager.HsqlName refTableName, OrderedHashSet refCols, HsqlNameManager.HsqlName mainTableName, OrderedHashSet mainCols, int type, int deleteAction, int updateAction, int matchType) {
        this.name = name;
        this.constType = type;
        this.mainColSet = mainCols;
        this.refColSet = refCols;
        this.core = new ConstraintCore();
        this.core.refTableName = refTableName;
        this.core.mainTableName = mainTableName;
        this.core.deleteAction = deleteAction;
        this.core.updateAction = updateAction;
        this.core.matchType = matchType;
        switch (this.core.deleteAction) {
            case 0: 
            case 2: 
            case 4: {
                this.core.hasDeleteAction = true;
            }
        }
        switch (this.core.updateAction) {
            case 0: 
            case 2: 
            case 4: {
                this.core.hasUpdateAction = true;
            }
        }
    }

    public Constraint(HsqlNameManager.HsqlName name, OrderedHashSet mainCols, int type) {
        this.name = name;
        this.constType = type;
        this.mainColSet = mainCols;
        this.core = new ConstraintCore();
    }

    public Constraint(HsqlNameManager.HsqlName uniqueName, HsqlNameManager.HsqlName mainName, HsqlNameManager.HsqlName refName, Table mainTable, Table refTable, int[] mainCols, int[] refCols, Index mainIndex, Index refIndex, int deleteAction, int updateAction) {
        this.name = refName;
        this.constType = 0;
        this.core = new ConstraintCore();
        this.core.uniqueName = uniqueName;
        this.core.mainName = mainName;
        this.core.refName = refName;
        this.core.mainTable = mainTable;
        this.core.refTable = refTable;
        this.core.mainCols = mainCols;
        this.core.refCols = refCols;
        this.core.mainIndex = mainIndex;
        this.core.refIndex = refIndex;
        this.core.deleteAction = deleteAction;
        this.core.updateAction = updateAction;
    }

    Constraint duplicate() {
        Constraint copy = new Constraint();
        copy.core = this.core.duplicate();
        copy.name = this.name;
        copy.constType = this.constType;
        copy.isForward = this.isForward;
        copy.check = this.check;
        copy.isNotNull = this.isNotNull;
        copy.notNullColumnIndex = this.notNullColumnIndex;
        copy.rangeVariable = this.rangeVariable;
        return copy;
    }

    void setColumnsIndexes(Table table) {
        if (this.constType == 0) {
            if (this.mainColSet == null) {
                this.core.mainCols = this.core.mainTable.getPrimaryKey();
                if (this.core.mainCols == null) {
                    throw Error.error(5581);
                }
            } else if (this.core.mainCols == null) {
                this.core.mainCols = this.core.mainTable.getColumnIndexes(this.mainColSet);
            }
            if (this.core.refCols == null) {
                this.core.refCols = table.getColumnIndexes(this.refColSet);
            }
            for (int i = 0; i < this.core.refCols.length; ++i) {
                Type dataType = table.getColumn(this.core.refCols[i]).getDataType();
                if (!dataType.isLobType()) continue;
                throw Error.error(5534);
            }
            if (this.core.mainCols.length != this.core.refCols.length) {
                throw Error.error(5593);
            }
        } else if (this.mainColSet != null) {
            this.core.mainCols = table.getColumnIndexes(this.mainColSet);
            for (int i = 0; i < this.core.mainCols.length; ++i) {
                Type dataType = table.getColumn(this.core.mainCols[i]).getDataType();
                if (!dataType.isLobType()) continue;
                throw Error.error(5534);
            }
        }
    }

    @Override
    public int getType() {
        return 5;
    }

    @Override
    public HsqlNameManager.HsqlName getName() {
        return this.name;
    }

    @Override
    public HsqlNameManager.HsqlName getCatalogName() {
        return this.name.schema.schema;
    }

    @Override
    public HsqlNameManager.HsqlName getSchemaName() {
        return this.name.schema;
    }

    @Override
    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        switch (this.constType) {
            case 3: {
                OrderedHashSet refs = new OrderedHashSet();
                this.check.collectObjectNames(refs);
                for (int j = refs.size() - 1; j >= 0; --j) {
                    HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)refs.get(j);
                    if (name.type != 9 && name.type != 3) continue;
                    refs.remove(j);
                }
                return refs;
            }
            case 0: {
                OrderedHashSet set = new OrderedHashSet();
                set.add(this.core.uniqueName);
                return set;
            }
        }
        return new OrderedHashSet();
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
    }

    @Override
    public String getSQL() {
        StringBuffer sb = new StringBuffer();
        switch (this.getConstraintType()) {
            case 4: {
                if (this.getMainColumns().length <= 1 && (this.getMainColumns().length != 1 || this.getName().isReservedName())) break;
                if (!this.getName().isReservedName()) {
                    sb.append("CONSTRAINT").append(' ');
                    sb.append(this.getName().statementName).append(' ');
                }
                sb.append("PRIMARY").append(' ').append("KEY");
                sb.append(this.getMain().getColumnListSQL(this.getMainColumns(), this.getMainColumns().length));
                break;
            }
            case 2: {
                if (!this.getName().isReservedName()) {
                    sb.append("CONSTRAINT").append(' ');
                    sb.append(this.getName().statementName);
                    sb.append(' ');
                }
                sb.append("UNIQUE");
                int[] col = this.getMainColumns();
                sb.append(this.getMain().getColumnListSQL(col, col.length));
                break;
            }
            case 0: {
                if (this.isForward) {
                    sb.append("ALTER").append(' ').append("TABLE").append(' ');
                    sb.append(this.getRef().getName().getSchemaQualifiedStatementName());
                    sb.append(' ').append("ADD").append(' ');
                    this.getFKStatement(sb);
                    break;
                }
                this.getFKStatement(sb);
                break;
            }
            case 3: {
                if (this.isNotNull()) break;
                if (!this.getName().isReservedName()) {
                    sb.append("CONSTRAINT").append(' ');
                    sb.append(this.getName().statementName).append(' ');
                }
                sb.append("CHECK").append('(');
                sb.append(this.check.getSQL());
                sb.append(')');
            }
        }
        return sb.toString();
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    private void getFKStatement(StringBuffer sb) {
        if (!this.getName().isReservedName()) {
            sb.append("CONSTRAINT").append(' ');
            sb.append(this.getName().statementName);
            sb.append(' ');
        }
        sb.append("FOREIGN").append(' ').append("KEY");
        int[] col = this.getRefColumns();
        sb.append(this.getRef().getColumnListSQL(col, col.length));
        sb.append(' ').append("REFERENCES").append(' ');
        sb.append(this.getMain().getName().getSchemaQualifiedStatementName());
        col = this.getMainColumns();
        sb.append(this.getMain().getColumnListSQL(col, col.length));
        if (this.getDeleteAction() != 3) {
            sb.append(' ').append("ON").append(' ').append("DELETE").append(' ');
            sb.append(this.getDeleteActionString());
        }
        if (this.getUpdateAction() != 3) {
            sb.append(' ').append("ON").append(' ').append("UPDATE").append(' ');
            sb.append(this.getUpdateActionString());
        }
    }

    public HsqlNameManager.HsqlName getMainTableName() {
        return this.core.mainTableName;
    }

    public HsqlNameManager.HsqlName getMainName() {
        return this.core.mainName;
    }

    public HsqlNameManager.HsqlName getRefName() {
        return this.core.refName;
    }

    public HsqlNameManager.HsqlName getUniqueName() {
        return this.core.uniqueName;
    }

    public int getConstraintType() {
        return this.constType;
    }

    public boolean isUniqueOrPK() {
        return this.constType == 2 || this.constType == 4;
    }

    public Table getMain() {
        return this.core.mainTable;
    }

    Index getMainIndex() {
        return this.core.mainIndex;
    }

    public Table getRef() {
        return this.core.refTable;
    }

    Index getRefIndex() {
        return this.core.refIndex;
    }

    private static String getActionString(int action) {
        switch (action) {
            case 1: {
                return "RESTRICT";
            }
            case 0: {
                return "CASCADE";
            }
            case 4: {
                return "SET DEFAULT";
            }
            case 2: {
                return "SET NULL";
            }
        }
        return "NO ACTION";
    }

    public int getDeleteAction() {
        return this.core.deleteAction;
    }

    public String getDeleteActionString() {
        return Constraint.getActionString(this.core.deleteAction);
    }

    public int getUpdateAction() {
        return this.core.updateAction;
    }

    public String getUpdateActionString() {
        return Constraint.getActionString(this.core.updateAction);
    }

    public boolean hasTriggeredAction() {
        if (this.constType == 0) {
            return this.hasCoreTriggeredAction();
        }
        return false;
    }

    public boolean hasCoreTriggeredAction() {
        switch (this.core.deleteAction) {
            case 0: 
            case 2: 
            case 4: {
                return true;
            }
        }
        switch (this.core.updateAction) {
            case 0: 
            case 2: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public int getDeferability() {
        return 7;
    }

    public int[] getMainColumns() {
        return this.core.mainCols;
    }

    public int[] getRefColumns() {
        return this.core.refCols;
    }

    public String getCheckSQL() {
        return this.check.getSQL();
    }

    public boolean isNotNull() {
        return this.isNotNull;
    }

    boolean hasColumnOnly(int colIndex) {
        switch (this.constType) {
            case 3: {
                return this.rangeVariable.usedColumns[colIndex] && ArrayUtil.countTrueElements(this.rangeVariable.usedColumns) == 1;
            }
            case 2: 
            case 4: {
                return this.core.mainCols.length == 1 && this.core.mainCols[0] == colIndex;
            }
            case 1: {
                return false;
            }
            case 0: {
                return this.core.refCols.length == 1 && this.core.refCols[0] == colIndex;
            }
        }
        throw Error.runtimeError(201, "Constraint");
    }

    boolean hasColumnPlus(int colIndex) {
        switch (this.constType) {
            case 3: {
                return this.rangeVariable.usedColumns[colIndex] && ArrayUtil.countTrueElements(this.rangeVariable.usedColumns) > 1;
            }
            case 2: 
            case 4: {
                return this.core.mainCols.length != 1 && ArrayUtil.find(this.core.mainCols, colIndex) != -1;
            }
            case 1: {
                return ArrayUtil.find(this.core.mainCols, colIndex) != -1;
            }
            case 0: {
                return this.core.refCols.length != 1 && ArrayUtil.find(this.core.refCols, colIndex) != -1;
            }
        }
        throw Error.runtimeError(201, "Constraint");
    }

    boolean hasColumn(int colIndex) {
        switch (this.constType) {
            case 3: {
                return this.rangeVariable.usedColumns[colIndex];
            }
            case 1: 
            case 2: 
            case 4: {
                return ArrayUtil.find(this.core.mainCols, colIndex) != -1;
            }
            case 0: {
                return ArrayUtil.find(this.core.refCols, colIndex) != -1;
            }
        }
        throw Error.runtimeError(201, "Constraint");
    }

    boolean isUniqueWithColumns(int[] cols) {
        switch (this.constType) {
            case 2: 
            case 4: {
                if (this.core.mainCols.length != cols.length) break;
                return ArrayUtil.haveEqualSets(this.core.mainCols, cols, cols.length);
            }
        }
        return false;
    }

    boolean isEquivalent(Table mainTable, int[] mainCols, Table refTable, int[] refCols) {
        switch (this.constType) {
            case 0: 
            case 1: {
                if (mainTable != this.core.mainTable || refTable != this.core.refTable) {
                    return false;
                }
                if (this.core.mainCols.length != mainCols.length || this.core.refCols.length != refCols.length) break;
                return ArrayUtil.areEqualSets(this.core.mainCols, mainCols) && ArrayUtil.areEqualSets(this.core.refCols, refCols);
            }
        }
        return false;
    }

    void updateTable(Session session, Table oldTable, Table newTable, int colIndex, int adjust) {
        if (oldTable == this.core.mainTable) {
            this.core.mainTable = newTable;
            if (this.core.mainIndex != null) {
                this.core.mainIndex = this.core.mainTable.getIndex(this.core.mainIndex.getName().name);
                this.core.mainCols = ArrayUtil.toAdjustedColumnArray(this.core.mainCols, colIndex, adjust);
            }
        }
        if (oldTable == this.core.refTable) {
            this.core.refTable = newTable;
            if (this.core.refIndex != null) {
                this.core.refIndex = this.core.refTable.getIndex(this.core.refIndex.getName().name);
                this.core.refCols = ArrayUtil.toAdjustedColumnArray(this.core.refCols, colIndex, adjust);
            }
        }
        if (this.constType == 3) {
            this.recompile(session, newTable);
        }
    }

    void checkInsert(Session session, Table table, Object[] data, boolean isNew) {
        switch (this.constType) {
            case 3: {
                if (!this.isNotNull) {
                    this.checkCheckConstraint(session, table, data);
                }
                return;
            }
            case 0: {
                PersistentStore store = this.core.mainTable.getRowStore(session);
                if (ArrayUtil.hasNull(data, this.core.refCols)) {
                    if (this.core.matchType == 59) {
                        return;
                    }
                    if (this.core.refCols.length == 1) {
                        return;
                    }
                    if (ArrayUtil.hasAllNull(data, this.core.refCols)) {
                        return;
                    }
                } else if (this.core.mainIndex.existsParent(session, store, data, this.core.refCols)) {
                    return;
                }
                throw this.getException(data);
            }
        }
    }

    void checkCheckConstraint(Session session, Table table, Object[] data) {
        RangeVariable.RangeIteratorBase it = session.sessionContext.getCheckIterator(this.rangeVariable);
        it.setCurrent(data);
        boolean nomatch = Boolean.FALSE.equals(this.check.getValue(session));
        it.setCurrent(null);
        if (nomatch) {
            Object[] info = new String[]{this.name.name, table.getName().name};
            throw Error.error(null, 157, 2, info);
        }
    }

    void checkCheckConstraint(Session session, Table table, ColumnSchema column, Object data) {
        session.sessionData.currentValue = data;
        boolean nomatch = Boolean.FALSE.equals(this.check.getValue(session));
        session.sessionData.currentValue = null;
        if (nomatch) {
            Object[] info = new String[]{this.name.statementName, table == null ? "" : table.getName().statementName, column == null ? "" : column.getName().statementName};
            throw Error.error(null, 157, 3, info);
        }
    }

    public HsqlException getException(Object[] data) {
        switch (this.constType) {
            case 3: {
                Object[] info = new String[]{this.name.statementName};
                return Error.error(null, 157, 2, info);
            }
            case 0: {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < this.core.refCols.length; ++i) {
                    Object o = data[this.core.refCols[i]];
                    sb.append(this.core.refTable.getColumnTypes()[this.core.refCols[i]].convertToString(o));
                    sb.append(',');
                }
                Object[] info = new String[]{this.name.statementName, this.core.refTable.getName().statementName, sb.toString()};
                return Error.error(null, 177, 2, info);
            }
            case 2: 
            case 4: {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < this.core.mainCols.length; ++i) {
                    Object o = data[this.core.mainCols[i]];
                    sb.append(this.core.mainTable.colTypes[this.core.mainCols[i]].convertToString(o));
                    sb.append(',');
                }
                return Error.error(null, 104, 2, new String[]{this.name.statementName, this.core.mainTable.getName().statementName, sb.toString()});
            }
        }
        throw Error.runtimeError(201, "Constraint");
    }

    RowIterator findFkRef(Session session, Object[] row) {
        if (row == null || ArrayUtil.hasNull(row, this.core.mainCols)) {
            return this.core.refIndex.emptyIterator();
        }
        PersistentStore store = this.core.refTable.getRowStore(session);
        return this.core.refIndex.findFirstRow(session, store, row, this.core.mainCols);
    }

    RowIterator findUniqueRows(Session session, Object[] row) {
        if (row == null || ArrayUtil.hasNull(row, this.core.mainCols)) {
            return this.core.mainIndex.emptyIterator();
        }
        PersistentStore store = this.core.mainTable.getRowStore(session);
        return this.core.mainIndex.findFirstRow(session, store, row, this.core.mainCols);
    }

    void checkReferencedRows(Session session, Table table) {
        Row row;
        RowIterator it = table.rowIterator(session);
        while ((row = it.getNextRow()) != null) {
            Object[] rowData = row.getData();
            this.checkInsert(session, table, rowData, false);
        }
    }

    public Expression getCheckExpression() {
        return this.check;
    }

    public OrderedHashSet getCheckColumnExpressions() {
        OrderedHashSet set = new OrderedHashSet();
        this.check.collectAllExpressions(set, Expression.columnExpressionSet, Expression.emptyExpressionSet);
        return set;
    }

    void recompile(Session session, Table newTable) {
        this.check = this.getNewCheckExpression(session);
        QuerySpecification checkSelect = Expression.getCheckSelect(session, newTable, this.check);
        this.rangeVariable = checkSelect.rangeVariables[0];
        this.rangeVariable.setForCheckConstraint();
    }

    private Expression getNewCheckExpression(Session session) {
        String ddl = this.check.getSQL();
        Scanner scanner = new Scanner(ddl);
        ParserDQL parser = new ParserDQL(session, scanner, null);
        parser.compileContext.setNextRangeVarIndex(0);
        parser.read();
        parser.isCheckOrTriggerCondition = true;
        Expression condition = parser.XreadBooleanValueExpression();
        return condition;
    }

    void prepareCheckConstraint(Session session, Table table) {
        this.check.checkValidCheckConstraint();
        if (table == null) {
            this.check.resolveTypes(session, null);
        } else {
            QuerySpecification checkSelect = Expression.getCheckSelect(session, table, this.check);
            this.rangeVariable = checkSelect.rangeVariables[0];
            this.rangeVariable.setForCheckConstraint();
        }
        if (this.check.getType() == 48 && this.check.getLeftNode().getType() == 47 && this.check.getLeftNode().getLeftNode().getType() == 2) {
            this.notNullColumnIndex = this.check.getLeftNode().getLeftNode().getColumnIndex();
            this.isNotNull = true;
        }
    }

    void checkCheckConstraint(Session session, Table table) {
        Expression newCheck;
        QuerySpecification checkSelect;
        Result r;
        if (table.getRowStore(session).elementCount() > 0L && (r = (checkSelect = Expression.getCheckSelect(session, table, newCheck = this.getNewCheckExpression(session))).getResult(session, 1)).getNavigator().getSize() != 0) {
            Object[] info = new String[]{this.name.statementName, table.getName().statementName};
            throw Error.error(null, 157, 2, info);
        }
    }
}

