/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.osgi.service.tracker.collections.internal.map;

import com.liferay.osgi.service.tracker.collections.ServiceReferenceServiceTuple;
import com.liferay.osgi.service.tracker.collections.internal.ServiceReferenceServiceTupleComparator;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerBucket;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerBucketFactory;
import java.util.Collections;
import java.util.Comparator;
import java.util.PriorityQueue;
import org.osgi.framework.ServiceReference;

public class SingleValueServiceTrackerBucketFactory<SR, TS>
implements ServiceTrackerBucketFactory<SR, TS, TS> {
    private final Comparator<ServiceReference<SR>> _comparator;

    public SingleValueServiceTrackerBucketFactory() {
        this._comparator = Collections.reverseOrder();
    }

    public SingleValueServiceTrackerBucketFactory(Comparator<ServiceReference<SR>> comparator) {
        this._comparator = comparator;
    }

    @Override
    public ServiceTrackerBucket<SR, TS, TS> create() {
        return new SingleBucket();
    }

    private class SingleBucket
    implements ServiceTrackerBucket<SR, TS, TS> {
        private TS _service = null;
        private final PriorityQueue<ServiceReferenceServiceTuple<SR, TS>> _serviceReferences;

        public SingleBucket() {
            ServiceReferenceServiceTupleComparator serviceReferenceServiceTupleComparator = new ServiceReferenceServiceTupleComparator(SingleValueServiceTrackerBucketFactory.this._comparator);
            this._serviceReferences = new PriorityQueue(1, serviceReferenceServiceTupleComparator);
        }

        @Override
        public TS getContent() {
            return this._service;
        }

        @Override
        public synchronized boolean isDisposable() {
            return this._serviceReferences.isEmpty();
        }

        @Override
        public synchronized void remove(ServiceReferenceServiceTuple<SR, TS> serviceReferenceServiceTuple) {
            this._serviceReferences.remove(serviceReferenceServiceTuple);
            ServiceReferenceServiceTuple headServiceReferenceServiceTuple = this._serviceReferences.peek();
            this._service = headServiceReferenceServiceTuple != null ? headServiceReferenceServiceTuple.getService() : null;
        }

        @Override
        public synchronized void store(ServiceReferenceServiceTuple<SR, TS> serviceReferenceServiceTuple) {
            this._serviceReferences.add(serviceReferenceServiceTuple);
            this._service = this._serviceReferences.peek().getService();
        }
    }
}

