/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.osgi.service.tracker.collections.internal.list;

import com.liferay.osgi.service.tracker.collections.ServiceReferenceServiceTuple;
import com.liferay.osgi.service.tracker.collections.internal.ServiceReferenceServiceTupleComparator;
import com.liferay.osgi.service.tracker.collections.internal.ServiceTrackerUtil;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ServiceTrackerListImpl<S, T>
implements ServiceTrackerList<S, T> {
    private final BundleContext _bundleContext;
    private final Comparator<ServiceReferenceServiceTuple<S, ?>> _comparator;
    private final List<ServiceReferenceServiceTuple<S, T>> _services = new CopyOnWriteArrayList<ServiceReferenceServiceTuple<S, T>>();
    private final ServiceTracker<S, T> _serviceTracker;
    private final ServiceTrackerCustomizer<S, T> _serviceTrackerCustomizer;

    public ServiceTrackerListImpl(BundleContext bundleContext, Class<S> clazz, String filterString, ServiceTrackerCustomizer<S, T> serviceTrackerCustomizer, Comparator<ServiceReference<S>> comparator) {
        this._bundleContext = bundleContext;
        this._serviceTrackerCustomizer = serviceTrackerCustomizer;
        this._comparator = comparator == null ? Collections.reverseOrder() : new ServiceReferenceServiceTupleComparator<S>(comparator);
        this._serviceTracker = ServiceTrackerUtil.createServiceTracker(this._bundleContext, clazz, filterString, new ServiceReferenceServiceTrackerCustomizer());
    }

    @Override
    public void close() {
        this._serviceTracker.close();
    }

    @Override
    public Iterator<T> iterator() {
        return new ServiceTrackerListIterator<S, T>(this._services.iterator());
    }

    @Override
    public void open() {
        this._serviceTracker.open();
    }

    @Override
    public int size() {
        return this._services.size();
    }

    private class ServiceReferenceServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<S, T> {
        private ServiceReferenceServiceTrackerCustomizer() {
        }

        public T addingService(ServiceReference<S> serviceReference) {
            return this._update(serviceReference, this.getService(serviceReference), false);
        }

        public void modifiedService(ServiceReference<S> serviceReference, T service) {
            if (ServiceTrackerListImpl.this._serviceTrackerCustomizer != null) {
                ServiceTrackerListImpl.this._serviceTrackerCustomizer.modifiedService(serviceReference, service);
            }
            this._update(serviceReference, service, false);
        }

        public void removedService(ServiceReference<S> serviceReference, T service) {
            if (ServiceTrackerListImpl.this._serviceTrackerCustomizer != null) {
                ServiceTrackerListImpl.this._serviceTrackerCustomizer.removedService(serviceReference, service);
            }
            this._update(serviceReference, service, true);
            ServiceTrackerListImpl.this._bundleContext.ungetService(serviceReference);
        }

        protected T getService(ServiceReference<S> serviceReference) {
            return ServiceTrackerListImpl.this._serviceTrackerCustomizer.addingService(serviceReference);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private T _update(ServiceReference<S> serviceReference, T service, boolean remove) {
            if (service == null) {
                return service;
            }
            ServiceReferenceServiceTuple serviceReferenceServiceTuple = new ServiceReferenceServiceTuple(serviceReference, service);
            List list = ServiceTrackerListImpl.this._services;
            synchronized (list) {
                int index = Collections.binarySearch(ServiceTrackerListImpl.this._services, serviceReferenceServiceTuple, ServiceTrackerListImpl.this._comparator);
                if (remove) {
                    if (index >= 0) {
                        ServiceTrackerListImpl.this._services.remove(index);
                    }
                } else if (index < 0) {
                    ServiceTrackerListImpl.this._services.add(-index - 1, serviceReferenceServiceTuple);
                }
            }
            return service;
        }
    }

    private static class ServiceTrackerListIterator<S, T>
    implements Iterator<T> {
        private final Iterator<ServiceReferenceServiceTuple<S, T>> _iterator;

        public ServiceTrackerListIterator(Iterator<ServiceReferenceServiceTuple<S, T>> iterator) {
            this._iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public T next() {
            ServiceReferenceServiceTuple<S, T> serviceReferenceServiceTuple = this._iterator.next();
            return serviceReferenceServiceTuple.getService();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

