/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.osgi.service.tracker.collections.internal;

import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ServiceTrackerUtil {
    public static <SR, TS> ServiceTracker<SR, TS> createServiceTracker(BundleContext bundleContext, Class<SR> clazz, String filterString, ServiceTrackerCustomizer<SR, TS> serviceTrackerCustomizer) {
        if (filterString != null) {
            try {
                Filter filter = bundleContext.createFilter("(&(objectClass=" + clazz.getName() + ")" + filterString + ")");
                return new ServiceTracker(bundleContext, filter, serviceTrackerCustomizer);
            }
            catch (InvalidSyntaxException ise) {
                ServiceTrackerUtil.throwException(ise);
                return null;
            }
        }
        return new ServiceTracker(bundleContext, clazz, serviceTrackerCustomizer);
    }

    public static <T> T throwException(Throwable throwable) {
        return ServiceTrackerUtil._throwException(throwable);
    }

    private static <T, E extends Throwable> T _throwException(Throwable throwable) throws E {
        throw throwable;
    }
}

