/*
 * Decompiled with CFR 0.152.
 */
package ch.inofix.contact.web.social;

import ch.inofix.contact.model.Contact;
import ch.inofix.contact.service.ContactLocalService;
import ch.inofix.contact.service.permission.ContactPermission;
import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.social.kernel.model.BaseSocialActivityInterpreter;
import com.liferay.social.kernel.model.SocialActivity;
import com.liferay.social.kernel.model.SocialActivityInterpreter;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=ch_inofix_contact_web_internal_portlet_ContactManagerPortlet"}, service={SocialActivityInterpreter.class})
public class ContactActivityInterpreter
extends BaseSocialActivityInterpreter {
    private static final String[] _CLASS_NAMES = new String[]{Contact.class.getName()};
    private ContactLocalService _contactLocalService;
    private ResourceBundleLoader _resourceBundleLoader;

    public String[] getClassNames() {
        return _CLASS_NAMES;
    }

    protected String getPath(SocialActivity activity, ServiceContext serviceContext) throws Exception {
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)Contact.class.getName());
        AssetRenderer assetRenderer = assetRendererFactory.getAssetRenderer(activity.getClassPK());
        String path = assetRenderer.getURLViewInContext(serviceContext.getLiferayPortletRequest(), serviceContext.getLiferayPortletResponse(), null);
        path = HttpUtil.addParameter((String)path, (String)"redirect", (String)serviceContext.getCurrentURL());
        return path;
    }

    protected ResourceBundleLoader getResourceBundleLoader() {
        return this._resourceBundleLoader;
    }

    protected String getTitlePattern(String groupName, SocialActivity activity) {
        int activityType = activity.getType();
        if (activityType == 1) {
            if (Validator.isNull((String)groupName)) {
                return "activity-contact-add-contact";
            }
            return "activity-contact-add-contact-in";
        }
        if (activityType == 10007) {
            if (Validator.isNull((String)groupName)) {
                return "activity-contact-move-to-trash";
            }
            return "activity-contact-move-to-trash-in";
        }
        if (activityType == 10008) {
            if (Validator.isNull((String)groupName)) {
                return "activity-contact-restore-from-trash";
            }
            return "activity-contact-restore-from-trash-in";
        }
        if (activityType == 2) {
            if (Validator.isNull((String)groupName)) {
                return "activity-contact-update-contact";
            }
            return "activity-contact-update-contact-in";
        }
        return "";
    }

    protected boolean hasPermissions(PermissionChecker permissionChecker, SocialActivity activity, String actionId, ServiceContext serviceContext) throws Exception {
        Contact contact = this._contactLocalService.getContact(activity.getClassPK());
        return ContactPermission.contains((PermissionChecker)permissionChecker, (long)contact.getContactId(), (String)actionId);
    }

    @Reference(unbind="-")
    protected void setContactLocalService(ContactLocalService contactLocalService) {
        this._contactLocalService = contactLocalService;
    }
}

