/*
 * Decompiled with CFR 0.152.
 */
package ch.inofix.contact.web.internal.asset;

import ch.inofix.contact.model.Contact;
import ch.inofix.contact.service.permission.ContactPermission;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.BaseJSPAssetRenderer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ContactAssetRenderer
extends BaseJSPAssetRenderer<Contact>
implements TrashRenderer {
    private static final Log _log = LogFactoryUtil.getLog(ContactAssetRenderer.class);
    private final Contact _contact;

    public ContactAssetRenderer(Contact contact) {
        this._contact = contact;
    }

    public Contact getAssetObject() {
        return this._contact;
    }

    public String getClassName() {
        return Contact.class.getName();
    }

    public long getClassPK() {
        return this._contact.getContactId();
    }

    public long getGroupId() {
        return this._contact.getGroupId();
    }

    public String getJspPath(HttpServletRequest request, String template) {
        if (template.equals("abstract") || template.equals("full_content")) {
            return "/asset/" + template + ".jsp";
        }
        return null;
    }

    public String getPortletId() {
        AssetRendererFactory assetRendererFactory = this.getAssetRendererFactory();
        return assetRendererFactory.getPortletId();
    }

    public int getStatus() {
        return this._contact.getStatus();
    }

    public String getSummary(PortletRequest portletRequest, PortletResponse portletResponse) {
        return "TODO: contact summary";
    }

    public String getTitle(Locale locale) {
        return this._contact.getName();
    }

    public String getType() {
        return "contact";
    }

    public PortletURL getURLEdit(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws Exception {
        PortletURL portletURL = this.locateContactManager(liferayPortletRequest);
        return portletURL;
    }

    public String getURLView(LiferayPortletResponse liferayPortletResponse, WindowState windowState) {
        try {
            long portletPlid = PortalUtil.getPlidFromPortletId((long)this._contact.getGroupId(), (boolean)false, (String)"ch_inofix_contact_web_internal_portlet_ContactManagerPortlet");
            LiferayPortletURL portletURL = liferayPortletResponse.createLiferayPortletURL(portletPlid, "ch_inofix_contact_web_internal_portlet_ContactManagerPortlet", "RENDER_PHASE");
            portletURL.setParameter("mvcPath", "/edit_contact.jsp");
            portletURL.setParameter("contactId", String.valueOf(this._contact.getContactId()));
            return portletURL.toString();
        }
        catch (Exception e) {
            _log.error((Object)e.getMessage());
            return null;
        }
    }

    public String getURLViewInContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, String noSuchEntryRedirect) {
        try {
            PortletURL portletURL = this.locateContactManager(liferayPortletRequest);
            return portletURL.toString();
        }
        catch (Exception e) {
            _log.error((Object)e.getMessage());
            return null;
        }
    }

    public long getUserId() {
        return this._contact.getUserId();
    }

    public String getUserName() {
        return this._contact.getUserName();
    }

    public String getUuid() {
        return this._contact.getUuid();
    }

    public boolean hasViewPermission(PermissionChecker permissionChecker) {
        return ContactPermission.contains((PermissionChecker)permissionChecker, (Contact)this._contact, (String)"VIEW");
    }

    public boolean include(HttpServletRequest request, HttpServletResponse response, String template) throws Exception {
        request.setAttribute("CONTACT", (Object)this._contact);
        return super.include(request, response, template);
    }

    private PortletURL locateContactManager(LiferayPortletRequest liferayPortletRequest) throws PortalException {
        long portletPlid = PortalUtil.getPlidFromPortletId((long)this._contact.getGroupId(), (boolean)false, (String)"ch_inofix_contact_web_internal_portlet_ContactManagerPortlet");
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)liferayPortletRequest, (String)"ch_inofix_contact_web_internal_portlet_ContactManagerPortlet", (long)portletPlid, (String)"RENDER_PHASE");
        portletURL.setParameter("mvcPath", "/edit_contact.jsp");
        portletURL.setParameter("contactId", String.valueOf(this._contact.getContactId()));
        return portletURL;
    }
}

