/*
 * Decompiled with CFR 0.152.
 */
package ch.inofix.contact.service.permission;

import ch.inofix.contact.model.Contact;
import ch.inofix.contact.service.ContactLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;

public class ContactPermission {
    private static final Log _log = LogFactoryUtil.getLog((String)ContactPermission.class.getName());

    public static void check(PermissionChecker permissionChecker, Contact contact, String actionId) throws PrincipalException {
        if (!ContactPermission.contains(permissionChecker, contact, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long contactId, String actionId) throws PrincipalException {
        if (!ContactPermission.contains(permissionChecker, contactId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, Contact contact, String actionId) {
        if (permissionChecker.hasOwnerPermission(contact.getCompanyId(), Contact.class.getName(), contact.getContactId(), contact.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(contact.getGroupId(), Contact.class.getName(), contact.getContactId(), actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long contactId, String actionId) {
        try {
            Contact contact = ContactLocalServiceUtil.getContact((long)contactId);
            return ContactPermission.contains(permissionChecker, contact, actionId);
        }
        catch (PortalException e) {
            _log.error((Throwable)e);
            return false;
        }
    }
}

