/*
 * Decompiled with CFR 0.152.
 */
package ch.inofix.contact.controller;

import ch.inofix.contact.exception.NoSuchContactException;
import ch.inofix.contact.internal.exportimport.util.ExportImportThreadLocal;
import ch.inofix.contact.model.Contact;
import ch.inofix.contact.service.ContactLocalService;
import com.liferay.exportimport.kernel.controller.ExportImportController;
import com.liferay.exportimport.kernel.controller.ImportController;
import com.liferay.exportimport.kernel.lar.MissingReferences;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataContextFactoryUtil;
import com.liferay.exportimport.kernel.lifecycle.ExportImportLifecycleManager;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.Validator;
import ezvcard.Ezvcard;
import ezvcard.VCard;
import ezvcard.VCardVersion;
import ezvcard.property.Categories;
import ezvcard.property.Uid;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.time.StopWatch;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=ch.inofix.contact.model.Contact"}, service={ExportImportController.class, ContactImportController.class})
public class ContactImportController
implements ImportController {
    private ContactLocalService _contactLocalService;
    private ExportImportLifecycleManager _exportImportLifecycleManager;
    private static final Log _log = LogFactoryUtil.getLog((String)ContactImportController.class.getName());

    public void importDataDeletions(ExportImportConfiguration exportImportConfiguration, File file) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void importFile(ExportImportConfiguration exportImportConfiguration, File file) throws Exception {
        PortletDataContext portletDataContext = null;
        try {
            ExportImportThreadLocal.setContactImportInProcess(true);
            this.doImportFile(file, exportImportConfiguration.getUserId(), exportImportConfiguration.getGroupId());
            ExportImportThreadLocal.setContactImportInProcess(false);
        }
        catch (Throwable t) {
            ExportImportThreadLocal.setContactImportInProcess(false);
            this._exportImportLifecycleManager.fireExportImportLifecycleEvent(4, this.getProcessFlag(), new Serializable[]{PortletDataContextFactoryUtil.clonePortletDataContext(portletDataContext), t});
            throw t;
        }
    }

    public MissingReferences validateFile(ExportImportConfiguration exportImportConfiguration, File file) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected void doImportFile(File file, long userId, long groupId) throws Exception {
        _log.info((Object)"doImportFile");
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setScopeGroupId(groupId);
        serviceContext.setUserId(userId);
        User user = UserLocalServiceUtil.getUser((long)userId);
        serviceContext.setCompanyId(user.getCompanyId());
        boolean updateExisting = true;
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        int numAdded = 0;
        int numIgnored = 0;
        int numImported = 0;
        int numProcessed = 0;
        int numUpdated = 0;
        List vCards = Ezvcard.parse((File)file).all();
        for (VCard vCard : vCards) {
            Uid uidObj = vCard.getUid();
            String uid = null;
            if (Validator.isNotNull((Object)uidObj)) {
                uid = (String)uidObj.getValue();
            } else {
                uid = UUID.randomUUID().toString();
                uidObj = new Uid(uid);
                vCard.setUid(uidObj);
            }
            String[] assetTagNames = ContactImportController.getAssetTagNames(vCard);
            serviceContext.setAssetTagNames(assetTagNames);
            String card = Ezvcard.write((VCard[])new VCard[]{vCard}).version(VCardVersion.V4_0).go();
            Contact contact = null;
            try {
                contact = this._contactLocalService.getContact(groupId, uid);
            }
            catch (NoSuchContactException noSuchContactException) {
                // empty catch block
            }
            if (contact == null) {
                this._contactLocalService.addContact(userId, card, uid, serviceContext);
                ++numImported;
            } else if (updateExisting) {
                this._contactLocalService.updateContact(userId, contact.getContactId(), card, uid, serviceContext);
                ++numUpdated;
            } else {
                ++numIgnored;
            }
            if (numProcessed % 100 == 0 && numProcessed > 0) {
                float completed = Integer.valueOf(numProcessed).floatValue() / Integer.valueOf(vCards.size()).floatValue() * 100.0f;
                _log.info((Object)("Processed " + numProcessed + " of " + vCards.size() + " cards in " + stopWatch.getTime() + " ms (" + completed + "%)."));
            }
            ++numProcessed;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Importing contacts takes " + stopWatch.getTime() + " ms."));
            _log.info((Object)("Added " + numAdded + " contacts as new, since they did not have a contactId."));
            _log.info((Object)("Ignored " + numIgnored + " contacts since they already exist in this instance."));
            _log.info((Object)("Imported " + numImported + " contacts since they did not exist in this instance."));
            _log.info((Object)("Updated " + numUpdated + " contacts since they already existed in this instance."));
        }
    }

    protected int getProcessFlag() {
        return 31;
    }

    @Reference(unbind="-")
    protected void setExportImportLifecycleManager(ExportImportLifecycleManager exportImportLifecycleManager) {
        this._exportImportLifecycleManager = exportImportLifecycleManager;
    }

    @Reference(unbind="-")
    protected void setContactLocalService(ContactLocalService contactLocalService) {
        this._contactLocalService = contactLocalService;
    }

    private static String[] getAssetTagNames(VCard vCard) {
        List categories = vCard.getCategoriesList();
        ArrayList assetTags = new ArrayList();
        for (Categories category : categories) {
            List values = category.getValues();
            assetTags.addAll(values);
        }
        String[] assetTagNames = new String[]{};
        return assetTags.toArray(assetTagNames);
    }
}

