/*
 * Decompiled with CFR 0.152.
 */
package com.github.mangstadt.vinnie.io;

import com.github.mangstadt.vinnie.SyntaxStyle;
import com.github.mangstadt.vinnie.Utils;
import com.github.mangstadt.vinnie.VObjectParameters;
import com.github.mangstadt.vinnie.VObjectProperty;
import com.github.mangstadt.vinnie.io.FoldedLineWriter;
import com.github.mangstadt.vinnie.validate.AllowedCharacters;
import com.github.mangstadt.vinnie.validate.VObjectValidator;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;

public class VObjectWriter
implements Closeable,
Flushable {
    private final FoldedLineWriter writer;
    private boolean caretEncodingEnabled = false;
    private SyntaxStyle syntaxStyle;
    private final AllowedCharacters allowedPropertyNameChars;
    private final AllowedCharacters allowedGroupChars;
    private final AllowedCharacters allowedParameterNameChars;
    private AllowedCharacters allowedParameterValueChars;
    private boolean parametersCopied;

    public VObjectWriter(Writer writer, SyntaxStyle syntaxStyle) {
        this.writer = new FoldedLineWriter(writer);
        this.syntaxStyle = syntaxStyle;
        this.allowedGroupChars = VObjectValidator.allowedCharactersGroup(syntaxStyle, false);
        this.allowedPropertyNameChars = VObjectValidator.allowedCharactersPropertyName(syntaxStyle, false);
        this.allowedParameterNameChars = VObjectValidator.allowedCharactersParameterName(syntaxStyle, false);
        this.allowedParameterValueChars = VObjectValidator.allowedCharactersParameterValue(syntaxStyle, false, false);
    }

    public FoldedLineWriter getFoldedLineWriter() {
        return this.writer;
    }

    public boolean isCaretEncodingEnabled() {
        return this.caretEncodingEnabled;
    }

    public void setCaretEncodingEnabled(boolean enable) {
        this.caretEncodingEnabled = enable;
        this.allowedParameterValueChars = VObjectValidator.allowedCharactersParameterValue(this.syntaxStyle, enable, false);
    }

    public SyntaxStyle getSyntaxStyle() {
        return this.syntaxStyle;
    }

    public void setSyntaxStyle(SyntaxStyle syntaxStyle) {
        this.syntaxStyle = syntaxStyle;
    }

    public void writeBeginComponent(String componentName) throws IOException {
        if (componentName == null || componentName.length() == 0) {
            throw new IllegalArgumentException("Component name cannot be null or empty.");
        }
        this.writeProperty("BEGIN", componentName);
    }

    public void writeEndComponent(String componentName) throws IOException {
        if (componentName == null || componentName.length() == 0) {
            throw new IllegalArgumentException("Component name cannot be null or empty.");
        }
        this.writeProperty("END", componentName);
    }

    public void writeVersion(String version) throws IOException {
        if (version == null || version.length() == 0) {
            throw new IllegalArgumentException("Version string cannot be null or empty.");
        }
        this.writeProperty("VERSION", version);
    }

    public void writeProperty(String name, String value) throws IOException {
        this.writeProperty(null, name, new VObjectParameters(), value);
    }

    public void writeProperty(VObjectProperty property) throws IOException {
        this.writeProperty(property.getGroup(), property.getName(), property.getParameters(), property.getValue());
    }

    public void writeProperty(String group, String name, VObjectParameters parameters, String value) throws IOException {
        this.validate(group, name, parameters);
        this.parametersCopied = false;
        if (value == null) {
            value = "";
        }
        switch (this.syntaxStyle) {
            case OLD: {
                if (!this.containsNewlines(value) || parameters.isQuotedPrintable()) break;
                parameters = this.copyParameters(parameters);
                parameters.put("ENCODING", "QUOTED-PRINTABLE");
                break;
            }
            case NEW: {
                value = Utils.escapeNewlines(value);
            }
        }
        boolean useQuotedPrintable = parameters.isQuotedPrintable();
        Charset quotedPrintableCharset = null;
        if (useQuotedPrintable) {
            try {
                quotedPrintableCharset = parameters.getCharset();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (quotedPrintableCharset == null) {
                quotedPrintableCharset = Charset.forName("UTF-8");
                parameters = this.copyParameters(parameters);
                parameters.replace("CHARSET", quotedPrintableCharset.name());
            }
        }
        if (group != null && !group.isEmpty()) {
            this.writer.append(group).append('.');
        }
        this.writer.append(name);
        for (Map.Entry<String, List<String>> parameter : parameters) {
            String parameterName = parameter.getKey();
            List<String> parameterValues = parameter.getValue();
            if (parameterValues.isEmpty()) continue;
            if (this.syntaxStyle == SyntaxStyle.OLD) {
                for (String parameterValue : parameterValues) {
                    parameterValue = this.sanitizeOldStyleParameterValue(parameterValue);
                    this.writer.append(';');
                    if (parameterName != null) {
                        this.writer.append(parameterName).append('=');
                    }
                    this.writer.append(parameterValue);
                }
                continue;
            }
            this.writer.append(';');
            if (parameterName != null) {
                this.writer.append(parameterName).append('=');
            }
            boolean first = true;
            for (String parameterValue : parameterValues) {
                parameterValue = this.sanitizeNewStyleParameterValue(parameterValue);
                if (!first) {
                    this.writer.append(',');
                }
                if (this.shouldQuoteParameterValue(parameterValue)) {
                    this.writer.append('\"').append(parameterValue).append('\"');
                } else {
                    this.writer.append(parameterValue);
                }
                first = false;
            }
        }
        this.writer.append(':');
        this.writer.write((CharSequence)value, useQuotedPrintable, quotedPrintableCharset);
        this.writer.writeln();
    }

    private void validate(String group, String name, VObjectParameters parameters) {
        if (group != null) {
            if (!this.allowedGroupChars.check(group)) {
                throw new IllegalArgumentException("Property \"" + name + "\" has its group set to \"" + group + "\".  This group name contains one or more invalid characters.  The following characters are not permitted: " + this.allowedGroupChars.flip());
            }
            if (this.beginsWithWhitespace(group)) {
                throw new IllegalArgumentException("Property \"" + name + "\" has its group set to \"" + group + "\".  This group name begins with one or more whitespace characters, which is not permitted.");
            }
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Property name cannot be empty.");
        }
        if (!this.allowedPropertyNameChars.check(name)) {
            throw new IllegalArgumentException("Property name \"" + name + "\" contains one or more invalid characters.  The following characters are not permitted: " + this.allowedPropertyNameChars.flip());
        }
        if (this.beginsWithWhitespace(name)) {
            throw new IllegalArgumentException("Property name \"" + name + "\" begins with one or more whitespace characters, which is not permitted.");
        }
        for (Map.Entry<String, List<String>> parameter : parameters) {
            String parameterName = parameter.getKey();
            if (parameterName == null && this.syntaxStyle == SyntaxStyle.NEW) {
                throw new IllegalArgumentException("Property \"" + name + "\" has a parameter whose name is null. This is not permitted with new style syntax.");
            }
            if (parameterName != null && !this.allowedParameterNameChars.check(parameterName)) {
                throw new IllegalArgumentException("Property \"" + name + "\" has a parameter named \"" + parameterName + "\".  This parameter's name contains one or more invalid characters.  The following characters are not permitted: " + this.allowedParameterNameChars.flip());
            }
            List<String> parameterValues = parameter.getValue();
            for (String parameterValue : parameterValues) {
                if (this.allowedParameterValueChars.check(parameterValue)) continue;
                throw new IllegalArgumentException("Property \"" + name + "\" has a parameter named \"" + parameterName + "\" whose value contains one or more invalid characters.  The following characters are not permitted: " + this.allowedParameterValueChars.flip());
            }
        }
    }

    private boolean containsNewlines(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\n': 
                case '\r': {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean shouldQuoteParameterValue(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case ',': 
                case ':': 
                case ';': {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean beginsWithWhitespace(String string) {
        if (string.length() == 0) {
            return false;
        }
        char first = string.charAt(0);
        return first == ' ' || first == '\t';
    }

    private String sanitizeNewStyleParameterValue(String value) {
        if (this.caretEncodingEnabled) {
            return this.applyCaretEncoding(value);
        }
        return value;
    }

    private String sanitizeOldStyleParameterValue(String value) {
        StringBuilder sb = null;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\\' || c == ';') {
                if (sb == null) {
                    sb = new StringBuilder(value.length() * 2);
                    sb.append(value, 0, i);
                }
                sb.append('\\');
            }
            if (sb == null) continue;
            sb.append(c);
        }
        return sb == null ? value : sb.toString();
    }

    private String applyCaretEncoding(String value) {
        StringBuilder sb = null;
        int prev = 0;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '^' || c == '\"' || c == '\r' || c == '\n') {
                if (c != '\n' || prev != 13) {
                    if (sb == null) {
                        sb = new StringBuilder(value.length() * 2);
                        sb.append(value, 0, i);
                    }
                    sb.append('^');
                    switch (c) {
                        case '\n': 
                        case '\r': {
                            sb.append('n');
                            break;
                        }
                        case '\"': {
                            sb.append('\'');
                            break;
                        }
                        default: {
                            sb.append(c);
                            break;
                        }
                    }
                }
            } else if (sb != null) {
                sb.append(c);
            }
            prev = c;
        }
        return sb == null ? value : sb.toString();
    }

    private VObjectParameters copyParameters(VObjectParameters parameters) {
        if (this.parametersCopied) {
            return parameters;
        }
        VObjectParameters copy = new VObjectParameters(parameters);
        this.parametersCopied = true;
        return copy;
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void close() throws IOException {
        this.writer.close();
    }
}

