/*
 * Decompiled with CFR 0.152.
 */
package ch.inofix.contact.service.persistence.impl;

import aQute.bnd.annotation.ProviderType;
import ch.inofix.contact.exception.NoSuchContactException;
import ch.inofix.contact.model.Contact;
import ch.inofix.contact.model.impl.ContactImpl;
import ch.inofix.contact.model.impl.ContactModelImpl;
import ch.inofix.contact.service.persistence.ContactPersistence;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.CompanyProvider;
import com.liferay.portal.kernel.service.persistence.CompanyProviderWrapper;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ProviderType
public class ContactPersistenceImpl
extends BasePersistenceImpl<Contact>
implements ContactPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = ContactImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(ContactModelImpl.ENTITY_CACHE_ENABLED, ContactModelImpl.FINDER_CACHE_ENABLED, ContactImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(ContactModelImpl.ENTITY_CACHE_ENABLED, ContactModelImpl.FINDER_CACHE_ENABLED, ContactImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(ContactModelImpl.ENTITY_CACHE_ENABLED, ContactModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_UUID = new FinderPath(ContactModelImpl.ENTITY_CACHE_ENABLED, ContactModelImpl.FINDER_CACHE_ENABLED, ContactImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid", new String[]{String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID = new FinderPath(ContactModelImpl.ENTITY_CACHE_ENABLED, ContactModelImpl.FINDER_CACHE_ENABLED, ContactImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid", new String[]{String.class.getName()}, 8L);
    public static final FinderPath FINDER_PATH_COUNT_BY_UUID = new FinderPath(ContactModelImpl.ENTITY_CACHE_ENABLED, ContactModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid", new String[]{String.class.getName()});
    private static final String _FINDER_COLUMN_UUID_UUID_1 = "contact.uuid IS NULL";
    private static final String _FINDER_COLUMN_UUID_UUID_2 = "contact.uuid = ?";
    private static final String _FINDER_COLUMN_UUID_UUID_3 = "(contact.uuid IS NULL OR contact.uuid = '')";
    public static final FinderPath FINDER_PATH_FETCH_BY_UUID_G = new FinderPath(ContactModelImpl.ENTITY_CACHE_ENABLED, ContactModelImpl.FINDER_CACHE_ENABLED, ContactImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByUUID_G", new String[]{String.class.getName(), Long.class.getName()}, 10L);
    public static final FinderPath FINDER_PATH_COUNT_BY_UUID_G = new FinderPath(ContactModelImpl.ENTITY_CACHE_ENABLED, ContactModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUUID_G", new String[]{String.class.getName(), Long.class.getName()});
    private static final String _FINDER_COLUMN_UUID_G_UUID_1 = "contact.uuid IS NULL AND ";
    private static final String _FINDER_COLUMN_UUID_G_UUID_2 = "contact.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_G_UUID_3 = "(contact.uuid IS NULL OR contact.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_G_GROUPID_2 = "contact.groupId = ?";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_UUID_C = new FinderPath(ContactModelImpl.ENTITY_CACHE_ENABLED, ContactModelImpl.FINDER_CACHE_ENABLED, ContactImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID_C = new FinderPath(ContactModelImpl.ENTITY_CACHE_ENABLED, ContactModelImpl.FINDER_CACHE_ENABLED, ContactImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, 9L);
    public static final FinderPath FINDER_PATH_COUNT_BY_UUID_C = new FinderPath(ContactModelImpl.ENTITY_CACHE_ENABLED, ContactModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid_C", new String[]{String.class.getName(), Long.class.getName()});
    private static final String _FINDER_COLUMN_UUID_C_UUID_1 = "contact.uuid IS NULL AND ";
    private static final String _FINDER_COLUMN_UUID_C_UUID_2 = "contact.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_C_UUID_3 = "(contact.uuid IS NULL OR contact.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_C_COMPANYID_2 = "contact.companyId = ?";
    public static final FinderPath FINDER_PATH_FETCH_BY_G_U = new FinderPath(ContactModelImpl.ENTITY_CACHE_ENABLED, ContactModelImpl.FINDER_CACHE_ENABLED, ContactImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByG_U", new String[]{Long.class.getName(), String.class.getName()}, 6L);
    public static final FinderPath FINDER_PATH_COUNT_BY_G_U = new FinderPath(ContactModelImpl.ENTITY_CACHE_ENABLED, ContactModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByG_U", new String[]{Long.class.getName(), String.class.getName()});
    private static final String _FINDER_COLUMN_G_U_GROUPID_2 = "contact.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_U_UID_1 = "contact.uid IS NULL";
    private static final String _FINDER_COLUMN_G_U_UID_2 = "contact.uid = ?";
    private static final String _FINDER_COLUMN_G_U_UID_3 = "(contact.uid IS NULL OR contact.uid = '')";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_GROUPID = new FinderPath(ContactModelImpl.ENTITY_CACHE_ENABLED, ContactModelImpl.FINDER_CACHE_ENABLED, ContactImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByGroupId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_GROUPID = new FinderPath(ContactModelImpl.ENTITY_CACHE_ENABLED, ContactModelImpl.FINDER_CACHE_ENABLED, ContactImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByGroupId", new String[]{Long.class.getName()}, 2L);
    public static final FinderPath FINDER_PATH_COUNT_BY_GROUPID = new FinderPath(ContactModelImpl.ENTITY_CACHE_ENABLED, ContactModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByGroupId", new String[]{Long.class.getName()});
    private static final String _FINDER_COLUMN_GROUPID_GROUPID_2 = "contact.groupId = ?";
    @ServiceReference(type=CompanyProviderWrapper.class)
    protected CompanyProvider companyProvider;
    @ServiceReference(type=EntityCache.class)
    protected EntityCache entityCache;
    @ServiceReference(type=FinderCache.class)
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_CONTACT = "SELECT contact FROM Contact contact";
    private static final String _SQL_SELECT_CONTACT_WHERE_PKS_IN = "SELECT contact FROM Contact contact WHERE contactId IN (";
    private static final String _SQL_SELECT_CONTACT_WHERE = "SELECT contact FROM Contact contact WHERE ";
    private static final String _SQL_COUNT_CONTACT = "SELECT COUNT(contact) FROM Contact contact";
    private static final String _SQL_COUNT_CONTACT_WHERE = "SELECT COUNT(contact) FROM Contact contact WHERE ";
    private static final String _FILTER_ENTITY_TABLE_FILTER_PK_COLUMN = "contact.contactId";
    private static final String _FILTER_SQL_SELECT_CONTACT_WHERE = "SELECT DISTINCT {contact.*} FROM inofix_cm_Contact contact WHERE ";
    private static final String _FILTER_SQL_SELECT_CONTACT_NO_INLINE_DISTINCT_WHERE_1 = "SELECT {inofix_cm_Contact.*} FROM (SELECT DISTINCT contact.contactId FROM inofix_cm_Contact contact WHERE ";
    private static final String _FILTER_SQL_SELECT_CONTACT_NO_INLINE_DISTINCT_WHERE_2 = ") TEMP_TABLE INNER JOIN inofix_cm_Contact ON TEMP_TABLE.contactId = inofix_cm_Contact.contactId";
    private static final String _FILTER_SQL_COUNT_CONTACT_WHERE = "SELECT COUNT(DISTINCT contact.contactId) AS COUNT_VALUE FROM inofix_cm_Contact contact WHERE ";
    private static final String _FILTER_ENTITY_ALIAS = "contact";
    private static final String _FILTER_ENTITY_TABLE = "inofix_cm_Contact";
    private static final String _ORDER_BY_ENTITY_ALIAS = "contact.";
    private static final String _ORDER_BY_ENTITY_TABLE = "inofix_cm_Contact.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Contact exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No Contact exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(ContactPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"uuid"});

    public List<Contact> findByUuid(String uuid) {
        return this.findByUuid(uuid, -1, -1, null);
    }

    public List<Contact> findByUuid(String uuid, int start, int end) {
        return this.findByUuid(uuid, start, end, null);
    }

    public List<Contact> findByUuid(String uuid, int start, int end, OrderByComparator<Contact> orderByComparator) {
        return this.findByUuid(uuid, start, end, orderByComparator, true);
    }

    public List<Contact> findByUuid(String uuid, int start, int end, OrderByComparator<Contact> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID;
            finderArgs = new Object[]{uuid};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_UUID;
            finderArgs = new Object[]{uuid, start, end, orderByComparator};
        }
        List<Contact> list = null;
        if (retrieveFromCache && (list = (List<Contact>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (Contact contact : list) {
                if (Objects.equals(uuid, contact.getUuid())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_CONTACT_WHERE);
            boolean bindUuid = false;
            if (uuid == null) {
                query.append(_FINDER_COLUMN_UUID_UUID_1);
            } else if (uuid.equals("")) {
                query.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                query.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY contact.contactId DESC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public Contact findByUuid_First(String uuid, OrderByComparator<Contact> orderByComparator) throws NoSuchContactException {
        Contact contact = this.fetchByUuid_First(uuid, orderByComparator);
        if (contact != null) {
            return contact;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append("}");
        throw new NoSuchContactException(msg.toString());
    }

    public Contact fetchByUuid_First(String uuid, OrderByComparator<Contact> orderByComparator) {
        List<Contact> list = this.findByUuid(uuid, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Contact findByUuid_Last(String uuid, OrderByComparator<Contact> orderByComparator) throws NoSuchContactException {
        Contact contact = this.fetchByUuid_Last(uuid, orderByComparator);
        if (contact != null) {
            return contact;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append("}");
        throw new NoSuchContactException(msg.toString());
    }

    public Contact fetchByUuid_Last(String uuid, OrderByComparator<Contact> orderByComparator) {
        int count = this.countByUuid(uuid);
        if (count == 0) {
            return null;
        }
        List<Contact> list = this.findByUuid(uuid, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Contact[] findByUuid_PrevAndNext(long contactId, String uuid, OrderByComparator<Contact> orderByComparator) throws NoSuchContactException {
        Contact contact = this.findByPrimaryKey(contactId);
        Session session = null;
        try {
            session = this.openSession();
            Contact[] array = new ContactImpl[]{this.getByUuid_PrevAndNext(session, contact, uuid, orderByComparator, true), contact, this.getByUuid_PrevAndNext(session, contact, uuid, orderByComparator, false)};
            Contact[] contactArray = array;
            return contactArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Contact getByUuid_PrevAndNext(Session session, Contact contact, String uuid, OrderByComparator<Contact> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_CONTACT_WHERE);
        boolean bindUuid = false;
        if (uuid == null) {
            query.append(_FINDER_COLUMN_UUID_UUID_1);
        } else if (uuid.equals("")) {
            query.append(_FINDER_COLUMN_UUID_UUID_3);
        } else {
            bindUuid = true;
            query.append(_FINDER_COLUMN_UUID_UUID_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY contact.contactId DESC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        if (bindUuid) {
            qPos.add(uuid);
        }
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)contact)) {
                qPos.add(value);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Contact)list.get(1);
        }
        return null;
    }

    public void removeByUuid(String uuid) {
        for (Contact contact : this.findByUuid(uuid, -1, -1, null)) {
            this.remove((BaseModel)contact);
        }
    }

    public int countByUuid(String uuid) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_UUID;
        Object[] finderArgs = new Object[]{uuid};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_CONTACT_WHERE);
            boolean bindUuid = false;
            if (uuid == null) {
                query.append(_FINDER_COLUMN_UUID_UUID_1);
            } else if (uuid.equals("")) {
                query.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                query.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Contact findByUUID_G(String uuid, long groupId) throws NoSuchContactException {
        Contact contact = this.fetchByUUID_G(uuid, groupId);
        if (contact == null) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("uuid=");
            msg.append(uuid);
            msg.append(", groupId=");
            msg.append(groupId);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)msg.toString());
            }
            throw new NoSuchContactException(msg.toString());
        }
        return contact;
    }

    public Contact fetchByUUID_G(String uuid, long groupId) {
        return this.fetchByUUID_G(uuid, groupId, true);
    }

    public Contact fetchByUUID_G(String uuid, long groupId, boolean retrieveFromCache) {
        Contact contact;
        Object[] finderArgs = new Object[]{uuid, groupId};
        Object result = null;
        if (retrieveFromCache) {
            result = this.finderCache.getResult(FINDER_PATH_FETCH_BY_UUID_G, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof Contact && (!Objects.equals(uuid, (contact = (Contact)result).getUuid()) || groupId != contact.getGroupId())) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_SELECT_CONTACT_WHERE);
            boolean bindUuid = false;
            if (uuid == null) {
                query.append("contact.uuid IS NULL AND ");
            } else if (uuid.equals("")) {
                query.append("(contact.uuid IS NULL OR contact.uuid = '') AND ");
            } else {
                bindUuid = true;
                query.append("contact.uuid = ? AND ");
            }
            query.append("contact.groupId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                qPos.add(groupId);
                List list = q.list();
                if (list.isEmpty()) {
                    this.finderCache.putResult(FINDER_PATH_FETCH_BY_UUID_G, finderArgs, (Object)list);
                } else {
                    Contact contact2 = (Contact)list.get(0);
                    result = contact2;
                    this.cacheResult(contact2);
                    if (contact2.getUuid() == null || !contact2.getUuid().equals(uuid) || contact2.getGroupId() != groupId) {
                        this.finderCache.putResult(FINDER_PATH_FETCH_BY_UUID_G, finderArgs, (Object)contact2);
                    }
                }
            }
            catch (Exception e) {
                this.finderCache.removeResult(FINDER_PATH_FETCH_BY_UUID_G, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Contact)result;
    }

    public Contact removeByUUID_G(String uuid, long groupId) throws NoSuchContactException {
        Contact contact = this.findByUUID_G(uuid, groupId);
        return (Contact)this.remove((BaseModel)contact);
    }

    public int countByUUID_G(String uuid, long groupId) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_UUID_G;
        Object[] finderArgs = new Object[]{uuid, groupId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_CONTACT_WHERE);
            boolean bindUuid = false;
            if (uuid == null) {
                query.append("contact.uuid IS NULL AND ");
            } else if (uuid.equals("")) {
                query.append("(contact.uuid IS NULL OR contact.uuid = '') AND ");
            } else {
                bindUuid = true;
                query.append("contact.uuid = ? AND ");
            }
            query.append("contact.groupId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                qPos.add(groupId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<Contact> findByUuid_C(String uuid, long companyId) {
        return this.findByUuid_C(uuid, companyId, -1, -1, null);
    }

    public List<Contact> findByUuid_C(String uuid, long companyId, int start, int end) {
        return this.findByUuid_C(uuid, companyId, start, end, null);
    }

    public List<Contact> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<Contact> orderByComparator) {
        return this.findByUuid_C(uuid, companyId, start, end, orderByComparator, true);
    }

    public List<Contact> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<Contact> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID_C;
            finderArgs = new Object[]{uuid, companyId};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_UUID_C;
            finderArgs = new Object[]{uuid, companyId, start, end, orderByComparator};
        }
        List<Contact> list = null;
        if (retrieveFromCache && (list = (List<Contact>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (Contact contact : list) {
                if (Objects.equals(uuid, contact.getUuid()) && companyId == contact.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            query.append(_SQL_SELECT_CONTACT_WHERE);
            boolean bindUuid = false;
            if (uuid == null) {
                query.append("contact.uuid IS NULL AND ");
            } else if (uuid.equals("")) {
                query.append("(contact.uuid IS NULL OR contact.uuid = '') AND ");
            } else {
                bindUuid = true;
                query.append("contact.uuid = ? AND ");
            }
            query.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY contact.contactId DESC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                qPos.add(companyId);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public Contact findByUuid_C_First(String uuid, long companyId, OrderByComparator<Contact> orderByComparator) throws NoSuchContactException {
        Contact contact = this.fetchByUuid_C_First(uuid, companyId, orderByComparator);
        if (contact != null) {
            return contact;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append(", companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchContactException(msg.toString());
    }

    public Contact fetchByUuid_C_First(String uuid, long companyId, OrderByComparator<Contact> orderByComparator) {
        List<Contact> list = this.findByUuid_C(uuid, companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Contact findByUuid_C_Last(String uuid, long companyId, OrderByComparator<Contact> orderByComparator) throws NoSuchContactException {
        Contact contact = this.fetchByUuid_C_Last(uuid, companyId, orderByComparator);
        if (contact != null) {
            return contact;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append(", companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchContactException(msg.toString());
    }

    public Contact fetchByUuid_C_Last(String uuid, long companyId, OrderByComparator<Contact> orderByComparator) {
        int count = this.countByUuid_C(uuid, companyId);
        if (count == 0) {
            return null;
        }
        List<Contact> list = this.findByUuid_C(uuid, companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Contact[] findByUuid_C_PrevAndNext(long contactId, String uuid, long companyId, OrderByComparator<Contact> orderByComparator) throws NoSuchContactException {
        Contact contact = this.findByPrimaryKey(contactId);
        Session session = null;
        try {
            session = this.openSession();
            Contact[] array = new ContactImpl[]{this.getByUuid_C_PrevAndNext(session, contact, uuid, companyId, orderByComparator, true), contact, this.getByUuid_C_PrevAndNext(session, contact, uuid, companyId, orderByComparator, false)};
            Contact[] contactArray = array;
            return contactArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Contact getByUuid_C_PrevAndNext(Session session, Contact contact, String uuid, long companyId, OrderByComparator<Contact> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        query.append(_SQL_SELECT_CONTACT_WHERE);
        boolean bindUuid = false;
        if (uuid == null) {
            query.append("contact.uuid IS NULL AND ");
        } else if (uuid.equals("")) {
            query.append("(contact.uuid IS NULL OR contact.uuid = '') AND ");
        } else {
            bindUuid = true;
            query.append("contact.uuid = ? AND ");
        }
        query.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY contact.contactId DESC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        if (bindUuid) {
            qPos.add(uuid);
        }
        qPos.add(companyId);
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)contact)) {
                qPos.add(value);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Contact)list.get(1);
        }
        return null;
    }

    public void removeByUuid_C(String uuid, long companyId) {
        for (Contact contact : this.findByUuid_C(uuid, companyId, -1, -1, null)) {
            this.remove((BaseModel)contact);
        }
    }

    public int countByUuid_C(String uuid, long companyId) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_UUID_C;
        Object[] finderArgs = new Object[]{uuid, companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_CONTACT_WHERE);
            boolean bindUuid = false;
            if (uuid == null) {
                query.append("contact.uuid IS NULL AND ");
            } else if (uuid.equals("")) {
                query.append("(contact.uuid IS NULL OR contact.uuid = '') AND ");
            } else {
                bindUuid = true;
                query.append("contact.uuid = ? AND ");
            }
            query.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                qPos.add(companyId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Contact findByG_U(long groupId, String uid) throws NoSuchContactException {
        Contact contact = this.fetchByG_U(groupId, uid);
        if (contact == null) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("groupId=");
            msg.append(groupId);
            msg.append(", uid=");
            msg.append(uid);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)msg.toString());
            }
            throw new NoSuchContactException(msg.toString());
        }
        return contact;
    }

    public Contact fetchByG_U(long groupId, String uid) {
        return this.fetchByG_U(groupId, uid, true);
    }

    public Contact fetchByG_U(long groupId, String uid, boolean retrieveFromCache) {
        Contact contact;
        Object[] finderArgs = new Object[]{groupId, uid};
        Object result = null;
        if (retrieveFromCache) {
            result = this.finderCache.getResult(FINDER_PATH_FETCH_BY_G_U, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof Contact && (groupId != (contact = (Contact)result).getGroupId() || !Objects.equals(uid, contact.getUid()))) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_SELECT_CONTACT_WHERE);
            query.append(_FINDER_COLUMN_G_U_GROUPID_2);
            boolean bindUid = false;
            if (uid == null) {
                query.append(_FINDER_COLUMN_G_U_UID_1);
            } else if (uid.equals("")) {
                query.append(_FINDER_COLUMN_G_U_UID_3);
            } else {
                bindUid = true;
                query.append(_FINDER_COLUMN_G_U_UID_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                if (bindUid) {
                    qPos.add(uid);
                }
                if ((list = q.list()).isEmpty()) {
                    this.finderCache.putResult(FINDER_PATH_FETCH_BY_G_U, finderArgs, (Object)list);
                } else {
                    Contact contact2 = (Contact)list.get(0);
                    result = contact2;
                    this.cacheResult(contact2);
                    if (contact2.getGroupId() != groupId || contact2.getUid() == null || !contact2.getUid().equals(uid)) {
                        this.finderCache.putResult(FINDER_PATH_FETCH_BY_G_U, finderArgs, (Object)contact2);
                    }
                }
            }
            catch (Exception e) {
                this.finderCache.removeResult(FINDER_PATH_FETCH_BY_G_U, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Contact)result;
    }

    public Contact removeByG_U(long groupId, String uid) throws NoSuchContactException {
        Contact contact = this.findByG_U(groupId, uid);
        return (Contact)this.remove((BaseModel)contact);
    }

    public int countByG_U(long groupId, String uid) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_G_U;
        Object[] finderArgs = new Object[]{groupId, uid};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_CONTACT_WHERE);
            query.append(_FINDER_COLUMN_G_U_GROUPID_2);
            boolean bindUid = false;
            if (uid == null) {
                query.append(_FINDER_COLUMN_G_U_UID_1);
            } else if (uid.equals("")) {
                query.append(_FINDER_COLUMN_G_U_UID_3);
            } else {
                bindUid = true;
                query.append(_FINDER_COLUMN_G_U_UID_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                if (bindUid) {
                    qPos.add(uid);
                }
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<Contact> findByGroupId(long groupId) {
        return this.findByGroupId(groupId, -1, -1, null);
    }

    public List<Contact> findByGroupId(long groupId, int start, int end) {
        return this.findByGroupId(groupId, start, end, null);
    }

    public List<Contact> findByGroupId(long groupId, int start, int end, OrderByComparator<Contact> orderByComparator) {
        return this.findByGroupId(groupId, start, end, orderByComparator, true);
    }

    public List<Contact> findByGroupId(long groupId, int start, int end, OrderByComparator<Contact> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_GROUPID;
            finderArgs = new Object[]{groupId};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_GROUPID;
            finderArgs = new Object[]{groupId, start, end, orderByComparator};
        }
        List<Contact> list = null;
        if (retrieveFromCache && (list = (List<Contact>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (Contact contact : list) {
                if (groupId == contact.getGroupId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_CONTACT_WHERE);
            query.append("contact.groupId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY contact.contactId DESC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public Contact findByGroupId_First(long groupId, OrderByComparator<Contact> orderByComparator) throws NoSuchContactException {
        Contact contact = this.fetchByGroupId_First(groupId, orderByComparator);
        if (contact != null) {
            return contact;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("groupId=");
        msg.append(groupId);
        msg.append("}");
        throw new NoSuchContactException(msg.toString());
    }

    public Contact fetchByGroupId_First(long groupId, OrderByComparator<Contact> orderByComparator) {
        List<Contact> list = this.findByGroupId(groupId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Contact findByGroupId_Last(long groupId, OrderByComparator<Contact> orderByComparator) throws NoSuchContactException {
        Contact contact = this.fetchByGroupId_Last(groupId, orderByComparator);
        if (contact != null) {
            return contact;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("groupId=");
        msg.append(groupId);
        msg.append("}");
        throw new NoSuchContactException(msg.toString());
    }

    public Contact fetchByGroupId_Last(long groupId, OrderByComparator<Contact> orderByComparator) {
        int count = this.countByGroupId(groupId);
        if (count == 0) {
            return null;
        }
        List<Contact> list = this.findByGroupId(groupId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Contact[] findByGroupId_PrevAndNext(long contactId, long groupId, OrderByComparator<Contact> orderByComparator) throws NoSuchContactException {
        Contact contact = this.findByPrimaryKey(contactId);
        Session session = null;
        try {
            session = this.openSession();
            Contact[] array = new ContactImpl[]{this.getByGroupId_PrevAndNext(session, contact, groupId, orderByComparator, true), contact, this.getByGroupId_PrevAndNext(session, contact, groupId, orderByComparator, false)};
            Contact[] contactArray = array;
            return contactArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Contact getByGroupId_PrevAndNext(Session session, Contact contact, long groupId, OrderByComparator<Contact> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_CONTACT_WHERE);
        query.append("contact.groupId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY contact.contactId DESC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(groupId);
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)contact)) {
                qPos.add(value);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Contact)list.get(1);
        }
        return null;
    }

    public List<Contact> filterFindByGroupId(long groupId) {
        return this.filterFindByGroupId(groupId, -1, -1, null);
    }

    public List<Contact> filterFindByGroupId(long groupId, int start, int end) {
        return this.filterFindByGroupId(groupId, start, end, null);
    }

    public List<Contact> filterFindByGroupId(long groupId, int start, int end, OrderByComparator<Contact> orderByComparator) {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            return this.findByGroupId(groupId, start, end, orderByComparator);
        }
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
        if (this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_CONTACT_WHERE);
        } else {
            query.append(_FILTER_SQL_SELECT_CONTACT_NO_INLINE_DISTINCT_WHERE_1);
        }
        query.append("contact.groupId = ?");
        if (!this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_CONTACT_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            if (this.getDB().isSupportsInlineDistinct()) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator, true);
            } else {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_TABLE, orderByComparator, true);
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            query.append(" ORDER BY contact.contactId DESC");
        } else {
            query.append(" ORDER BY inofix_cm_Contact.contactId DESC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)query.toString(), (String)Contact.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN, (long)groupId);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            if (this.getDB().isSupportsInlineDistinct()) {
                q.addEntity(_FILTER_ENTITY_ALIAS, ContactImpl.class);
            } else {
                q.addEntity(_FILTER_ENTITY_TABLE, ContactImpl.class);
            }
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public Contact[] filterFindByGroupId_PrevAndNext(long contactId, long groupId, OrderByComparator<Contact> orderByComparator) throws NoSuchContactException {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            return this.findByGroupId_PrevAndNext(contactId, groupId, orderByComparator);
        }
        Contact contact = this.findByPrimaryKey(contactId);
        Session session = null;
        try {
            session = this.openSession();
            Contact[] array = new ContactImpl[]{this.filterGetByGroupId_PrevAndNext(session, contact, groupId, orderByComparator, true), contact, this.filterGetByGroupId_PrevAndNext(session, contact, groupId, orderByComparator, false)};
            Contact[] contactArray = array;
            return contactArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Contact filterGetByGroupId_PrevAndNext(Session session, Contact contact, long groupId, OrderByComparator<Contact> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        if (this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_CONTACT_WHERE);
        } else {
            query.append(_FILTER_SQL_SELECT_CONTACT_NO_INLINE_DISTINCT_WHERE_1);
        }
        query.append("contact.groupId = ?");
        if (!this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_CONTACT_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    query.append(_ORDER_BY_ENTITY_ALIAS);
                } else {
                    query.append(_ORDER_BY_ENTITY_TABLE);
                }
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    query.append(_ORDER_BY_ENTITY_ALIAS);
                } else {
                    query.append(_ORDER_BY_ENTITY_TABLE);
                }
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            query.append(" ORDER BY contact.contactId DESC");
        } else {
            query.append(" ORDER BY inofix_cm_Contact.contactId DESC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)query.toString(), (String)Contact.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN, (long)groupId);
        SQLQuery q = session.createSynchronizedSQLQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        if (this.getDB().isSupportsInlineDistinct()) {
            q.addEntity(_FILTER_ENTITY_ALIAS, ContactImpl.class);
        } else {
            q.addEntity(_FILTER_ENTITY_TABLE, ContactImpl.class);
        }
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(groupId);
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)contact)) {
                qPos.add(value);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Contact)list.get(1);
        }
        return null;
    }

    public void removeByGroupId(long groupId) {
        for (Contact contact : this.findByGroupId(groupId, -1, -1, null)) {
            this.remove((BaseModel)contact);
        }
    }

    public int countByGroupId(long groupId) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_GROUPID;
        Object[] finderArgs = new Object[]{groupId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_CONTACT_WHERE);
            query.append("contact.groupId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int filterCountByGroupId(long groupId) {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            return this.countByGroupId(groupId);
        }
        StringBundler query = new StringBundler(2);
        query.append(_FILTER_SQL_COUNT_CONTACT_WHERE);
        query.append("contact.groupId = ?");
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)query.toString(), (String)Contact.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN, (long)groupId);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            Long count = (Long)q.uniqueResult();
            int n = count.intValue();
            return n;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public ContactPersistenceImpl() {
        this.setModelClass(Contact.class);
    }

    public void cacheResult(Contact contact) {
        this.entityCache.putResult(ContactModelImpl.ENTITY_CACHE_ENABLED, ContactImpl.class, (Serializable)Long.valueOf(contact.getPrimaryKey()), (Serializable)contact);
        this.finderCache.putResult(FINDER_PATH_FETCH_BY_UUID_G, new Object[]{contact.getUuid(), contact.getGroupId()}, (Object)contact);
        this.finderCache.putResult(FINDER_PATH_FETCH_BY_G_U, new Object[]{contact.getGroupId(), contact.getUid()}, (Object)contact);
        contact.resetOriginalValues();
    }

    public void cacheResult(List<Contact> contacts) {
        for (Contact contact : contacts) {
            if (this.entityCache.getResult(ContactModelImpl.ENTITY_CACHE_ENABLED, ContactImpl.class, (Serializable)Long.valueOf(contact.getPrimaryKey())) == null) {
                this.cacheResult(contact);
                continue;
            }
            contact.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(ContactImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(Contact contact) {
        this.entityCache.removeResult(ContactModelImpl.ENTITY_CACHE_ENABLED, ContactImpl.class, (Serializable)Long.valueOf(contact.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((ContactModelImpl)contact);
    }

    public void clearCache(List<Contact> contacts) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Contact contact : contacts) {
            this.entityCache.removeResult(ContactModelImpl.ENTITY_CACHE_ENABLED, ContactImpl.class, (Serializable)Long.valueOf(contact.getPrimaryKey()));
            this.clearUniqueFindersCache((ContactModelImpl)contact);
        }
    }

    protected void cacheUniqueFindersCache(ContactModelImpl contactModelImpl, boolean isNew) {
        if (isNew) {
            Object[] args = new Object[]{contactModelImpl.getUuid(), contactModelImpl.getGroupId()};
            this.finderCache.putResult(FINDER_PATH_COUNT_BY_UUID_G, args, (Object)1L);
            this.finderCache.putResult(FINDER_PATH_FETCH_BY_UUID_G, args, (Object)contactModelImpl);
            args = new Object[]{contactModelImpl.getGroupId(), contactModelImpl.getUid()};
            this.finderCache.putResult(FINDER_PATH_COUNT_BY_G_U, args, (Object)1L);
            this.finderCache.putResult(FINDER_PATH_FETCH_BY_G_U, args, (Object)contactModelImpl);
        } else {
            Object[] args;
            if ((contactModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_UUID_G.getColumnBitmask()) != 0L) {
                args = new Object[]{contactModelImpl.getUuid(), contactModelImpl.getGroupId()};
                this.finderCache.putResult(FINDER_PATH_COUNT_BY_UUID_G, args, (Object)1L);
                this.finderCache.putResult(FINDER_PATH_FETCH_BY_UUID_G, args, (Object)contactModelImpl);
            }
            if ((contactModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_G_U.getColumnBitmask()) != 0L) {
                args = new Object[]{contactModelImpl.getGroupId(), contactModelImpl.getUid()};
                this.finderCache.putResult(FINDER_PATH_COUNT_BY_G_U, args, (Object)1L);
                this.finderCache.putResult(FINDER_PATH_FETCH_BY_G_U, args, (Object)contactModelImpl);
            }
        }
    }

    protected void clearUniqueFindersCache(ContactModelImpl contactModelImpl) {
        Object[] args = new Object[]{contactModelImpl.getUuid(), contactModelImpl.getGroupId()};
        this.finderCache.removeResult(FINDER_PATH_COUNT_BY_UUID_G, args);
        this.finderCache.removeResult(FINDER_PATH_FETCH_BY_UUID_G, args);
        if ((contactModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_UUID_G.getColumnBitmask()) != 0L) {
            args = new Object[]{contactModelImpl.getOriginalUuid(), contactModelImpl.getOriginalGroupId()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_UUID_G, args);
            this.finderCache.removeResult(FINDER_PATH_FETCH_BY_UUID_G, args);
        }
        args = new Object[]{contactModelImpl.getGroupId(), contactModelImpl.getUid()};
        this.finderCache.removeResult(FINDER_PATH_COUNT_BY_G_U, args);
        this.finderCache.removeResult(FINDER_PATH_FETCH_BY_G_U, args);
        if ((contactModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_G_U.getColumnBitmask()) != 0L) {
            args = new Object[]{contactModelImpl.getOriginalGroupId(), contactModelImpl.getOriginalUid()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_G_U, args);
            this.finderCache.removeResult(FINDER_PATH_FETCH_BY_G_U, args);
        }
    }

    public Contact create(long contactId) {
        ContactImpl contact = new ContactImpl();
        contact.setNew(true);
        contact.setPrimaryKey(contactId);
        String uuid = PortalUUIDUtil.generate();
        contact.setUuid(uuid);
        contact.setCompanyId(this.companyProvider.getCompanyId());
        return contact;
    }

    public Contact remove(long contactId) throws NoSuchContactException {
        return this.remove(Long.valueOf(contactId));
    }

    public Contact remove(Serializable primaryKey) throws NoSuchContactException {
        Session session = null;
        try {
            session = this.openSession();
            Contact contact = (Contact)session.get(ContactImpl.class, primaryKey);
            if (contact == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchContactException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            Contact contact2 = (Contact)this.remove((BaseModel)contact);
            return contact2;
        }
        catch (NoSuchContactException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Contact removeImpl(Contact contact) {
        contact = this.toUnwrappedModel(contact);
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)contact)) {
                contact = (Contact)session.get(ContactImpl.class, contact.getPrimaryKeyObj());
            }
            if (contact != null) {
                session.delete((Object)contact);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (contact != null) {
            this.clearCache(contact);
        }
        return contact;
    }

    public Contact updateImpl(Contact contact) {
        contact = this.toUnwrappedModel(contact);
        boolean isNew = contact.isNew();
        ContactModelImpl contactModelImpl = (ContactModelImpl)contact;
        if (Validator.isNull((String)contact.getUuid())) {
            String uuid = PortalUUIDUtil.generate();
            contact.setUuid(uuid);
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date now = new Date();
        if (isNew && contact.getCreateDate() == null) {
            if (serviceContext == null) {
                contact.setCreateDate(now);
            } else {
                contact.setCreateDate(serviceContext.getCreateDate(now));
            }
        }
        if (!contactModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                contact.setModifiedDate(now);
            } else {
                contact.setModifiedDate(serviceContext.getModifiedDate(now));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (contact.isNew()) {
                session.save((Object)contact);
                contact.setNew(false);
            } else {
                contact = (Contact)session.merge((Object)contact);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (isNew || !ContactModelImpl.COLUMN_BITMASK_ENABLED) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else {
            Object[] args;
            if ((contactModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID.getColumnBitmask()) != 0L) {
                args = new Object[]{contactModelImpl.getOriginalUuid()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_UUID, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID, args);
                args = new Object[]{contactModelImpl.getUuid()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_UUID, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID, args);
            }
            if ((contactModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID_C.getColumnBitmask()) != 0L) {
                args = new Object[]{contactModelImpl.getOriginalUuid(), contactModelImpl.getOriginalCompanyId()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_UUID_C, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID_C, args);
                args = new Object[]{contactModelImpl.getUuid(), contactModelImpl.getCompanyId()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_UUID_C, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID_C, args);
            }
            if ((contactModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_GROUPID.getColumnBitmask()) != 0L) {
                args = new Object[]{contactModelImpl.getOriginalGroupId()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_GROUPID, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_GROUPID, args);
                args = new Object[]{contactModelImpl.getGroupId()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_GROUPID, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_GROUPID, args);
            }
        }
        this.entityCache.putResult(ContactModelImpl.ENTITY_CACHE_ENABLED, ContactImpl.class, (Serializable)Long.valueOf(contact.getPrimaryKey()), (Serializable)contact, false);
        this.clearUniqueFindersCache(contactModelImpl);
        this.cacheUniqueFindersCache(contactModelImpl, isNew);
        contact.resetOriginalValues();
        return contact;
    }

    protected Contact toUnwrappedModel(Contact contact) {
        if (contact instanceof ContactImpl) {
            return contact;
        }
        ContactImpl contactImpl = new ContactImpl();
        contactImpl.setNew(contact.isNew());
        contactImpl.setPrimaryKey(contact.getPrimaryKey());
        contactImpl.setUuid(contact.getUuid());
        contactImpl.setContactId(contact.getContactId());
        contactImpl.setGroupId(contact.getGroupId());
        contactImpl.setCompanyId(contact.getCompanyId());
        contactImpl.setUserId(contact.getUserId());
        contactImpl.setUserName(contact.getUserName());
        contactImpl.setCreateDate(contact.getCreateDate());
        contactImpl.setModifiedDate(contact.getModifiedDate());
        contactImpl.setStatus(contact.getStatus());
        contactImpl.setParentContactId(contact.getParentContactId());
        contactImpl.setCard(contact.getCard());
        contactImpl.setUid(contact.getUid());
        return contactImpl;
    }

    public Contact findByPrimaryKey(Serializable primaryKey) throws NoSuchContactException {
        Contact contact = this.fetchByPrimaryKey(primaryKey);
        if (contact == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchContactException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return contact;
    }

    public Contact findByPrimaryKey(long contactId) throws NoSuchContactException {
        return this.findByPrimaryKey(Long.valueOf(contactId));
    }

    public Contact fetchByPrimaryKey(Serializable primaryKey) {
        Serializable serializable = this.entityCache.getResult(ContactModelImpl.ENTITY_CACHE_ENABLED, ContactImpl.class, primaryKey);
        if (serializable == nullModel) {
            return null;
        }
        Contact contact = (Contact)serializable;
        if (contact == null) {
            Session session = null;
            try {
                session = this.openSession();
                contact = (Contact)session.get(ContactImpl.class, primaryKey);
                if (contact != null) {
                    this.cacheResult(contact);
                } else {
                    this.entityCache.putResult(ContactModelImpl.ENTITY_CACHE_ENABLED, ContactImpl.class, primaryKey, (Serializable)nullModel);
                }
            }
            catch (Exception e) {
                this.entityCache.removeResult(ContactModelImpl.ENTITY_CACHE_ENABLED, ContactImpl.class, primaryKey);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return contact;
    }

    public Contact fetchByPrimaryKey(long contactId) {
        return this.fetchByPrimaryKey(Long.valueOf(contactId));
    }

    public Map<Serializable, Contact> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        Session session;
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, Contact> map = new HashMap<Serializable, Contact>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            Contact contact = this.fetchByPrimaryKey(primaryKey);
            if (contact != null) {
                map.put(primaryKey, contact);
            }
            return map;
        }
        HashSet<Serializable> uncachedPrimaryKeys = null;
        for (Serializable serializable : primaryKeys) {
            Serializable serializable2 = this.entityCache.getResult(ContactModelImpl.ENTITY_CACHE_ENABLED, ContactImpl.class, serializable);
            if (serializable2 == nullModel) continue;
            if (serializable2 == null) {
                if (uncachedPrimaryKeys == null) {
                    uncachedPrimaryKeys = new HashSet<Serializable>();
                }
                uncachedPrimaryKeys.add(serializable);
                continue;
            }
            map.put(serializable, (Contact)serializable2);
        }
        if (uncachedPrimaryKeys == null) {
            return map;
        }
        StringBundler query = new StringBundler(uncachedPrimaryKeys.size() * 2 + 1);
        query.append(_SQL_SELECT_CONTACT_WHERE_PKS_IN);
        for (Serializable serializable : uncachedPrimaryKeys) {
            query.append(String.valueOf(serializable));
            query.append(",");
        }
        query.setIndex(query.index() - 1);
        query.append(")");
        String string = query.toString();
        Session session2 = null;
        try {
            session = this.openSession();
            Query q = session.createQuery(string);
            for (Contact contact : q.list()) {
                map.put(contact.getPrimaryKeyObj(), contact);
                this.cacheResult(contact);
                uncachedPrimaryKeys.remove(contact.getPrimaryKeyObj());
            }
            for (Serializable serializable : uncachedPrimaryKeys) {
                this.entityCache.putResult(ContactModelImpl.ENTITY_CACHE_ENABLED, ContactImpl.class, serializable, (Serializable)nullModel);
            }
        }
        catch (Exception e) {
            try {
                throw this.processException(e);
            }
            catch (Throwable throwable) {
                this.closeSession(session2);
                throw throwable;
            }
        }
        this.closeSession(session);
        return map;
    }

    public List<Contact> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<Contact> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<Contact> findAll(int start, int end, OrderByComparator<Contact> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<Contact> findAll(int start, int end, OrderByComparator<Contact> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (retrieveFromCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_CONTACT);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_CONTACT;
                if (pagination) {
                    sql = sql.concat(" ORDER BY contact.contactId DESC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (Contact contact : this.findAll()) {
            this.remove((BaseModel)contact);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_CONTACT);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return ContactModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
    }

    public void destroy() {
        this.entityCache.removeCache(ContactImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

