/*
 * Decompiled with CFR 0.152.
 */
package ch.inofix.contact.service.impl;

import aQute.bnd.annotation.ProviderType;
import ch.inofix.contact.model.Contact;
import ch.inofix.contact.service.base.ContactServiceBaseImpl;
import ch.inofix.contact.service.permission.ContactManagerPermission;
import ch.inofix.contact.service.permission.ContactPermission;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.TempFileEntryUtil;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@ProviderType
public class ContactServiceImpl
extends ContactServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog((String)ContactServiceImpl.class.getName());

    public Contact addContact(String card, String uid, ServiceContext serviceContext) throws PortalException {
        ContactManagerPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "ADD_CONTACT");
        return this.contactLocalService.addContact(this.getUserId(), card, uid, serviceContext);
    }

    public FileEntry addTempFileEntry(long groupId, String folderName, String fileName, InputStream inputStream, String mimeType) throws PortalException {
        ContactManagerPermission.check(this.getPermissionChecker(), groupId, "EXPORT_IMPORT_CONTACTS");
        return TempFileEntryUtil.addTempFileEntry((long)groupId, (long)this.getUserId(), (String)DigesterUtil.digestHex((String)"SHA-256", (String[])new String[]{folderName}), (String)fileName, (InputStream)inputStream, (String)mimeType);
    }

    public Contact createContact() throws PortalException {
        return this.contactLocalService.createContact(0L);
    }

    public List<Contact> deleteAllContacts(long groupId) throws PortalException {
        ContactManagerPermission.check(this.getPermissionChecker(), groupId, "DELETE_GROUP_CONTACTS");
        return this.contactLocalService.deleteGroupContacts(groupId);
    }

    public Contact deleteContact(long contactId) throws PortalException {
        ContactPermission.check(this.getPermissionChecker(), contactId, "DELETE");
        Contact contact = this.contactLocalService.deleteContact(contactId);
        return contact;
    }

    public void deleteTempFileEntry(long groupId, String folderName, String fileName) throws PortalException {
        ContactManagerPermission.check(this.getPermissionChecker(), groupId, "EXPORT_IMPORT_CONTACTS");
        TempFileEntryUtil.deleteTempFileEntry((long)groupId, (long)this.getUserId(), (String)DigesterUtil.digestHex((String)"SHA-256", (String[])new String[]{folderName}), (String)fileName);
    }

    public Contact getContact(long contactId) throws PortalException {
        ContactPermission.check(this.getPermissionChecker(), contactId, "VIEW");
        return this.contactLocalService.getContact(contactId);
    }

    public String[] getTempFileNames(long groupId, String folderName) throws PortalException {
        ContactManagerPermission.check(this.getPermissionChecker(), groupId, "EXPORT_IMPORT_CONTACTS");
        return TempFileEntryUtil.getTempFileNames((long)groupId, (long)this.getUserId(), (String)DigesterUtil.digestHex((String)"SHA-256", (String[])new String[]{folderName}));
    }

    public long importContactsInBackground(ExportImportConfiguration exportImportConfiguration, InputStream inputStream) throws PortalException {
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        long targetGroupId = MapUtil.getLong((Map)settingsMap, (String)"targetGroupId");
        ContactManagerPermission.check(this.getPermissionChecker(), targetGroupId, "IMPORT_CONTACTS");
        return this.contactLocalService.importContactsInBackground(this.getUserId(), exportImportConfiguration, inputStream);
    }

    public Hits search(long userId, long groupId, String keywords, int start, int end, Sort sort) throws PortalException {
        return this.contactLocalService.search(userId, groupId, keywords, start, end, sort);
    }

    public Hits search(long userId, long groupId, long ownerUserId, String company, String fullName, int status, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, Sort sort) throws PortalException {
        return this.contactLocalService.search(userId, groupId, ownerUserId, company, fullName, status, params, andSearch, start, end, sort);
    }

    public Contact updateContact(long contactId, String card, String uid, ServiceContext serviceContext) throws PortalException {
        ContactPermission.check(this.getPermissionChecker(), contactId, "UPDATE");
        return this.contactLocalService.updateContact(this.getUserId(), contactId, card, uid, serviceContext);
    }
}

