/*
 * Decompiled with CFR 0.152.
 */
package ch.inofix.contact.service.impl;

import aQute.bnd.annotation.ProviderType;
import ch.inofix.contact.background.task.ContactImportBackgroundTaskExecutor;
import ch.inofix.contact.model.Contact;
import ch.inofix.contact.service.base.ContactLocalServiceBaseImpl;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.exportimport.kernel.controller.ExportImportControllerRegistryUtil;
import com.liferay.exportimport.kernel.controller.ImportController;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskManagerUtil;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

@ProviderType
public class ContactLocalServiceImpl
extends ContactLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog((String)ContactLocalServiceImpl.class.getName());

    @Indexable(type=IndexableType.REINDEX)
    public Contact addContact(long userId, String card, String uid, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long groupId = serviceContext.getScopeGroupId();
        long contactId = this.counterLocalService.increment();
        Contact contact = this.contactPersistence.create(contactId);
        contact.setUuid(serviceContext.getUuid());
        contact.setGroupId(groupId);
        contact.setCompanyId(user.getCompanyId());
        contact.setUserId(user.getUserId());
        contact.setUserName(user.getFullName());
        contact.setExpandoBridgeAttributes(serviceContext);
        contact.setCard(card);
        contact.setUid(uid);
        contact = (Contact)this.contactPersistence.update((BaseModel)contact);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addContactResources(contact, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addContactResources(contact, serviceContext.getModelPermissions());
        }
        this.updateAsset(userId, contact, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds(), serviceContext.getAssetPriority());
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        extraDataJSONObject.put("title", contact.getName());
        this.socialActivityLocalService.addActivity(userId, groupId, Contact.class.getName(), contactId, 1, extraDataJSONObject.toString(), 0L);
        return contact;
    }

    public void addContactResources(Contact contact, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        this.resourceLocalService.addResources(contact.getCompanyId(), contact.getGroupId(), contact.getUserId(), Contact.class.getName(), contact.getContactId(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addContactResources(Contact contact, ModelPermissions modelPermissions) throws PortalException {
        this.resourceLocalService.addModelResources(contact.getCompanyId(), contact.getGroupId(), contact.getUserId(), Contact.class.getName(), contact.getContactId(), modelPermissions);
    }

    public void addContactResources(long contactId, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        Contact contact = this.contactPersistence.findByPrimaryKey(contactId);
        this.addContactResources(contact, addGroupPermissions, addGuestPermissions);
    }

    public void addContactResources(long contactId, ModelPermissions modelPermissions) throws PortalException {
        Contact contact = this.contactPersistence.findByPrimaryKey(contactId);
        this.addContactResources(contact, modelPermissions);
    }

    @Override
    public Contact deleteContact(long contactId) throws PortalException {
        Contact contact = this.contactPersistence.findByPrimaryKey(contactId);
        return this.deleteContact(contact);
    }

    public List<Contact> deleteGroupContacts(long groupId) throws PortalException {
        List contactList = this.contactPersistence.findByGroupId(groupId);
        for (Contact contact : contactList) {
            try {
                this.deleteContact(contact);
            }
            catch (Exception e) {
                _log.error((Throwable)e);
            }
        }
        return contactList;
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public Contact deleteContact(Contact contact) throws PortalException {
        this.contactPersistence.remove((BaseModel)contact);
        this.resourceLocalService.deleteResource(contact.getCompanyId(), Contact.class.getName(), 4, contact.getContactId());
        this.assetEntryLocalService.deleteEntry(Contact.class.getName(), contact.getContactId());
        return contact;
    }

    @Deprecated
    public Contact getContact(long groupId, String uid) throws PortalException {
        return this.contactPersistence.findByG_U(groupId, uid);
    }

    public List<Contact> getGroupContacts(long groupId) throws PortalException {
        return this.contactPersistence.findByGroupId(groupId);
    }

    public void importContacts(ExportImportConfiguration exportImportConfiguration, File file) throws PortalException {
        try {
            ImportController contactImportController = ExportImportControllerRegistryUtil.getImportController((String)Contact.class.getName());
            contactImportController.importFile(exportImportConfiguration, file);
        }
        catch (PortalException pe) {
            Throwable cause = pe.getCause();
            if (cause instanceof LocaleException) {
                throw (PortalException)cause;
            }
            throw pe;
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public void importContacts(ExportImportConfiguration exportImportConfiguration, InputStream inputStream) throws PortalException {
        File file = null;
        try {
            file = FileUtil.createTempFile((String)"lar");
            FileUtil.write((File)file, (InputStream)inputStream);
            this.importContacts(exportImportConfiguration, file);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        finally {
            FileUtil.delete((File)file);
        }
    }

    public long importContactsInBackground(long userId, ExportImportConfiguration exportImportConfiguration, File file) throws PortalException {
        HashMap<String, Long> taskContextMap = new HashMap<String, Long>();
        taskContextMap.put("exportImportConfigurationId", exportImportConfiguration.getExportImportConfigurationId());
        BackgroundTask backgroundTask = BackgroundTaskManagerUtil.addBackgroundTask((long)userId, (long)exportImportConfiguration.getGroupId(), (String)exportImportConfiguration.getName(), (String)ContactImportBackgroundTaskExecutor.class.getName(), taskContextMap, (ServiceContext)new ServiceContext());
        backgroundTask.addAttachment(userId, file.getName(), file);
        return backgroundTask.getBackgroundTaskId();
    }

    public long importContactsInBackground(long userId, ExportImportConfiguration exportImportConfiguration, InputStream inputStream) throws PortalException {
        File file = null;
        try {
            file = FileUtil.createTempFile((String)"lar");
            FileUtil.write((File)file, (InputStream)inputStream);
            long l = this.importContactsInBackground(userId, exportImportConfiguration, file);
            return l;
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        finally {
            FileUtil.delete((File)file);
        }
    }

    public Hits search(long userId, long groupId, String keywords, int start, int end, Sort sort) throws PortalException {
        if (sort == null) {
            sort = new Sort("modified", true);
        }
        String company = null;
        String fullName = null;
        boolean andOperator = false;
        if (Validator.isNotNull((String)keywords)) {
            company = keywords;
            fullName = keywords;
        } else {
            andOperator = true;
        }
        return this.search(userId, groupId, 0L, company, fullName, -1, null, andOperator, start, end, sort);
    }

    public Hits search(long userId, long groupId, long ownerUserId, String company, String fullName, int status, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, Sort sort) throws PortalException {
        if (sort == null) {
            sort = new Sort("modified", true);
        }
        Indexer indexer = IndexerRegistryUtil.getIndexer((String)Contact.class.getName());
        SearchContext searchContext = this.buildSearchContext(userId, groupId, ownerUserId, company, fullName, status, params, andSearch, start, end, sort);
        return indexer.search(searchContext);
    }

    public void updateAsset(long userId, Contact contact, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds, Double priority) throws PortalException {
        boolean visible = true;
        Date publishDate = contact.getCreateDate();
        String description = "TODO: contact description";
        String summary = HtmlUtil.extractText((String)StringUtil.shorten((String)contact.getCard(), (int)500));
        String className = Contact.class.getName();
        long classPK = contact.getContactId();
        AssetEntry assetEntry = this.assetEntryLocalService.updateEntry(userId, contact.getGroupId(), contact.getCreateDate(), contact.getModifiedDate(), className, classPK, contact.getUuid(), 0L, assetCategoryIds, assetTagNames, true, visible, null, null, publishDate, null, "text/html", contact.getName(), description, summary, null, null, 0, 0, priority);
        this.assetLinkLocalService.updateLinks(userId, assetEntry.getEntryId(), assetLinkEntryIds, 0);
    }

    @Indexable(type=IndexableType.REINDEX)
    public Contact updateContact(long userId, long contactId, String card, String uid, ServiceContext serviceContext) throws PortalException {
        long groupId = serviceContext.getScopeGroupId();
        Contact contact = this.contactPersistence.findByPrimaryKey(contactId);
        contact.setGroupId(groupId);
        contact.setExpandoBridgeAttributes(serviceContext);
        contact.setCard(card);
        this.contactPersistence.update((BaseModel)contact);
        this.updateAsset(userId, contact, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds(), serviceContext.getAssetPriority());
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        extraDataJSONObject.put("title", contact.getName());
        this.socialActivityLocalService.addActivity(userId, groupId, Contact.class.getName(), contact.getContactId(), 2, extraDataJSONObject.toString(), 0L);
        return contact;
    }

    public void updateContactResources(Contact contact, ModelPermissions modelPermissions) throws PortalException {
        this.resourceLocalService.updateResources(contact.getCompanyId(), contact.getGroupId(), Contact.class.getName(), contact.getContactId(), modelPermissions);
    }

    public void updateContactResources(Contact contact, String[] groupPermissions, String[] guestPermissions) throws PortalException {
        this.resourceLocalService.updateResources(contact.getCompanyId(), contact.getGroupId(), Contact.class.getName(), contact.getContactId(), groupPermissions, guestPermissions);
    }

    protected SearchContext buildSearchContext(long userId, long groupId, long ownerUserId, String company, String fullName, int status, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, Sort sort) throws PortalException {
        String keywords;
        SearchContext searchContext = new SearchContext();
        searchContext.setAttribute("status", (Serializable)Integer.valueOf(status));
        if (Validator.isNotNull((String)company)) {
            searchContext.setAttribute("company", (Serializable)((Object)company));
        }
        if (Validator.isNotNull((String)fullName)) {
            searchContext.setAttribute("fullName", (Serializable)((Object)fullName));
        }
        searchContext.setAttribute("paginationType", (Serializable)((Object)"more"));
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        searchContext.setCompanyId(group.getCompanyId());
        if (ownerUserId > 0L) {
            searchContext.setOwnerUserId(ownerUserId);
        }
        searchContext.setEnd(end);
        if (groupId > 0L) {
            searchContext.setGroupIds(new long[]{groupId});
        }
        searchContext.setSorts(new Sort[]{sort});
        searchContext.setStart(start);
        searchContext.setUserId(userId);
        searchContext.setAndSearch(andSearch);
        if (params != null && Validator.isNotNull((String)(keywords = (String)params.remove("keywords")))) {
            searchContext.setKeywords(keywords);
        }
        QueryConfig queryConfig = new QueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        searchContext.setQueryConfig(queryConfig);
        if (sort != null) {
            searchContext.setSorts(new Sort[]{sort});
        }
        searchContext.setStart(start);
        return searchContext;
    }
}

