/*
 * Decompiled with CFR 0.152.
 */
package ch.inofix.contact.internal.exportimport.data.handler;

import ch.inofix.contact.model.Contact;
import ch.inofix.contact.service.ContactLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.exportimport.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class ContactStagedModelDataHandler
extends BaseStagedModelDataHandler<Contact> {
    public static final String[] CLASS_NAMES = new String[]{Contact.class.getName()};
    private ContactLocalService _contactLocalService;
    private static final Log _log = LogFactoryUtil.getLog(ContactStagedModelDataHandler.class);

    public void deleteStagedModel(Contact contact) throws PortalException {
        this._contactLocalService.deleteContact(contact);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        Contact contact = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (contact != null) {
            this.deleteStagedModel(contact);
        }
    }

    public Contact fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return this._contactLocalService.fetchContactByUuidAndGroupId(uuid, groupId);
    }

    public List<Contact> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._contactLocalService.getContactsByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(Contact contact) {
        return String.valueOf(contact.getContactId());
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, Contact contact) throws Exception {
        Element contactElement = portletDataContext.getExportDataElement((ClassedModel)contact);
        portletDataContext.addClassedModel(contactElement, ExportImportPathUtil.getModelPath((StagedModel)contact), (ClassedModel)contact);
    }

    protected void doImportMissingReference(PortletDataContext portletDataContext, String uuid, long groupId, long contactId) throws Exception {
        Contact existingContact = (Contact)this.fetchMissingReference(uuid, groupId);
        if (existingContact == null) {
            return;
        }
        Map contactIds = portletDataContext.getNewPrimaryKeysMap(Contact.class);
        contactIds.put(contactId, existingContact.getContactId());
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, Contact contact) throws Exception {
        long userId = portletDataContext.getUserId(contact.getUserUuid());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)contact);
        Contact importedContact = null;
        if (portletDataContext.isDataStrategyMirror()) {
            Contact existingContact = this.fetchStagedModelByUuidAndGroupId(contact.getUuid(), portletDataContext.getScopeGroupId());
            if (existingContact == null) {
                serviceContext.setUuid(contact.getUuid());
                importedContact = this._contactLocalService.addContact(userId, contact.getCard(), contact.getUid(), serviceContext);
            } else {
                importedContact = this._contactLocalService.updateContact(userId, contact.getContactId(), contact.getCard(), contact.getUid(), serviceContext);
            }
        } else {
            importedContact = this._contactLocalService.addContact(userId, contact.getCard(), contact.getUid(), serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)contact, (ClassedModel)importedContact);
    }

    @Reference(unbind="-")
    protected void setContactLocalService(ContactLocalService contactLocalService) {
        this._contactLocalService = contactLocalService;
    }
}

