/*
 * Decompiled with CFR 0.152.
 */
package ch.inofix.contact.background.task;

import ch.inofix.contact.background.task.BaseExportImportBackgroundTaskExecutor;
import ch.inofix.contact.service.ContactLocalServiceUtil;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskResult;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.util.FileUtil;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.Callable;

public class ContactImportBackgroundTaskExecutor
extends BaseExportImportBackgroundTaskExecutor {
    private static final Log _log = LogFactoryUtil.getLog(ContactImportBackgroundTaskExecutor.class);

    public ContactImportBackgroundTaskExecutor() {
        this.setIsolationLevel(3);
    }

    public BackgroundTaskExecutor clone() {
        ContactImportBackgroundTaskExecutor contactImportBackgroundTaskExecutor = new ContactImportBackgroundTaskExecutor();
        contactImportBackgroundTaskExecutor.setBackgroundTaskStatusMessageTranslator(this.getBackgroundTaskStatusMessageTranslator());
        contactImportBackgroundTaskExecutor.setIsolationLevel(this.getIsolationLevel());
        return contactImportBackgroundTaskExecutor;
    }

    public BackgroundTaskResult execute(BackgroundTask backgroundTask) throws Exception {
        ExportImportConfiguration exportImportConfiguration = this.getExportImportConfiguration(backgroundTask);
        List attachmentsFileEntries = backgroundTask.getAttachmentsFileEntries();
        File file = null;
        for (FileEntry attachmentsFileEntry : attachmentsFileEntries) {
            try {
                file = FileUtil.createTempFile((String)"lar");
                FileUtil.write((File)file, (InputStream)attachmentsFileEntry.getContentStream());
                _log.info((Object)file.getAbsoluteFile());
                TransactionInvokerUtil.invoke((TransactionConfig)transactionConfig, (Callable)new ContactImportCallable(exportImportConfiguration, file));
            }
            catch (Throwable t) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)t, t);
                } else if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Unable to import contacts: " + t.getMessage()));
                }
                throw new SystemException(t);
            }
            finally {
                FileUtil.delete((File)file);
            }
        }
        return BackgroundTaskResult.SUCCESS;
    }

    private static class ContactImportCallable
    implements Callable<Void> {
        private final ExportImportConfiguration _exportImportConfiguration;
        private final File _file;

        public ContactImportCallable(ExportImportConfiguration exportImportConfiguration, File file) {
            this._exportImportConfiguration = exportImportConfiguration;
            this._file = file;
        }

        @Override
        public Void call() throws PortalException {
            ContactLocalServiceUtil.importContacts((ExportImportConfiguration)this._exportImportConfiguration, (File)this._file);
            return null;
        }
    }
}

