/*
 * Decompiled with CFR 0.152.
 */
package ch.inofix.contact.web.internal.search;

import ch.inofix.contact.model.Contact;
import ch.inofix.contact.web.internal.search.ContactDisplayTerms;
import ch.inofix.contact.web.internal.search.ContactSearchTerms;
import com.liferay.portal.kernel.dao.search.DisplayTerms;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;

public class ContactSearch
extends SearchContainer<Contact> {
    public static final String EMPTY_RESULTS_MESSAGE = "no-contacts-were-found";
    static List<String> headerNames = new ArrayList<String>();
    static Map<String, String> orderableHeaders = new HashMap<String, String>();
    private static Log _log;

    public ContactSearch(PortletRequest portletRequest, PortletURL iteratorURL) {
        this(portletRequest, "cur", iteratorURL);
    }

    public ContactSearch(PortletRequest portletRequest, String curParam, PortletURL iteratorURL) {
        super(portletRequest, (DisplayTerms)new ContactDisplayTerms(portletRequest), (DisplayTerms)new ContactSearchTerms(portletRequest), curParam, DEFAULT_DELTA, iteratorURL, headerNames, EMPTY_RESULTS_MESSAGE);
        PortletConfig portletConfig = (PortletConfig)portletRequest.getAttribute("javax.portlet.config");
        ContactDisplayTerms displayTerms = (ContactDisplayTerms)this.getDisplayTerms();
        ContactSearchTerms searchTerms = (ContactSearchTerms)this.getSearchTerms();
        String portletId = PortletProviderUtil.getPortletId((String)User.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW);
        String portletName = portletConfig.getPortletName();
        if (!portletId.equals(portletName)) {
            displayTerms.setStatus(0);
            searchTerms.setStatus(0);
        }
        iteratorURL.setParameter("company", String.valueOf(displayTerms.getCompany()));
        iteratorURL.setParameter("contactId", String.valueOf(displayTerms.getContactId()));
        iteratorURL.setParameter("createDate", String.valueOf(displayTerms.getCreateDate()));
        iteratorURL.setParameter("email", String.valueOf(displayTerms.getEmail()));
        iteratorURL.setParameter("fax", String.valueOf(displayTerms.getFax()));
        iteratorURL.setParameter("fullName", String.valueOf(displayTerms.getFullName()));
        iteratorURL.setParameter("modifiedDate", String.valueOf(displayTerms.getModifiedDate()));
        iteratorURL.setParameter("name", String.valueOf(displayTerms.getName()));
        iteratorURL.setParameter("phone", String.valueOf(displayTerms.getPhone()));
        iteratorURL.setParameter("userName", String.valueOf(displayTerms.getUserName()));
        try {
            PortalPreferences preferences = PortletPreferencesFactoryUtil.getPortalPreferences((PortletRequest)portletRequest);
            String orderByCol = ParamUtil.getString((PortletRequest)portletRequest, (String)"orderByCol");
            String orderByType = ParamUtil.getString((PortletRequest)portletRequest, (String)"orderByType");
            if (Validator.isNotNull((String)orderByCol) && Validator.isNotNull((String)orderByType)) {
                preferences.setValue(portletId, "contacts-order-by-col", orderByCol);
                preferences.setValue(portletId, "contacts-order-by-type", orderByType);
            } else {
                orderByCol = preferences.getValue(portletId, "contacts-order-by-col", "modified-date");
                orderByType = preferences.getValue(portletId, "contacts-order-by-type", "asc");
            }
            this.setOrderableHeaders(orderableHeaders);
            if (Validator.isNotNull((String)orderableHeaders.get(orderByCol))) {
                this.setOrderByCol(orderableHeaders.get(orderByCol));
            } else {
                _log.error((Object)(orderByCol + " is not an orderable header."));
                this.setOrderByCol(orderByCol);
            }
            this.setOrderByType(orderByType);
        }
        catch (Exception e) {
            _log.error((Throwable)e);
        }
    }

    static {
        headerNames.add("city");
        headerNames.add("company");
        headerNames.add("contact-id");
        headerNames.add("country");
        headerNames.add("create-date");
        headerNames.add("email");
        headerNames.add("full-name");
        headerNames.add("modified-date");
        headerNames.add("name");
        headerNames.add("phone");
        headerNames.add("portrait");
        headerNames.add("url");
        headerNames.add("user-name");
        orderableHeaders.put("city", "city_sortable");
        orderableHeaders.put("company", "company_sortable");
        orderableHeaders.put("contact-id", "contact-id");
        orderableHeaders.put("country", "country_sortable");
        orderableHeaders.put("create-date", "createDate_Number_sortable");
        orderableHeaders.put("email", "email_sortable");
        orderableHeaders.put("full-name", "fullName_sortable");
        orderableHeaders.put("modified-date", "modifiedDate_Number_sortable");
        orderableHeaders.put("name", "name");
        orderableHeaders.put("phone", "phone");
        orderableHeaders.put("url", "url_sortable");
        orderableHeaders.put("user-name", "userName_sortable");
        _log = LogFactoryUtil.getLog(ContactSearch.class);
    }
}

