/*
 * Decompiled with CFR 0.152.
 */
package ch.inofix.contact.web.internal.portlet;

import aQute.bnd.annotation.metatype.Configurable;
import ch.inofix.contact.exception.ImageFileFormatException;
import ch.inofix.contact.exception.KeyFileFormatException;
import ch.inofix.contact.exception.NoSuchContactException;
import ch.inofix.contact.exception.SoundFileFormatException;
import ch.inofix.contact.internal.exportimport.configuration.ExportImportContactsConfigurationSettingsMapFactory;
import ch.inofix.contact.model.Contact;
import ch.inofix.contact.service.ContactService;
import ch.inofix.contact.web.configuration.ContactManagerConfiguration;
import ch.inofix.contact.web.internal.portlet.util.PortletUtil;
import com.liferay.document.library.kernel.exception.FileSizeException;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.exportimport.kernel.configuration.ExportImportConfigurationSettingsMapFactory;
import com.liferay.exportimport.kernel.exception.LARFileException;
import com.liferay.exportimport.kernel.exception.LARFileSizeException;
import com.liferay.exportimport.kernel.exception.LARTypeException;
import com.liferay.exportimport.kernel.exception.LayoutImportException;
import com.liferay.exportimport.kernel.lar.ExportImportHelper;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.MissingReferences;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.service.ExportImportConfigurationLocalService;
import com.liferay.exportimport.kernel.service.ExportImportService;
import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskManagerUtil;
import com.liferay.portal.kernel.exception.LayoutPrototypeException;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.NoSuchBackgroundTaskException;
import com.liferay.portal.kernel.exception.NoSuchResourceException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.JSONPortletResponseUtil;
import com.liferay.portal.kernel.portlet.PortletConfigFactoryUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCPortlet;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.upload.UploadException;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.upload.UploadRequestSizeException;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.Validator;
import ezvcard.Ezvcard;
import ezvcard.VCard;
import ezvcard.VCardVersion;
import ezvcard.property.Uid;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"com.liferay.portlet.css-class-wrapper=ifx-portlet portlet-contact-manager", "com.liferay.portlet.display-category=category.inofix", "com.liferay.portlet.footer-portlet-javascript=/js/main.js", "com.liferay.portlet.header-portlet-css=/css/main.css", "com.liferay.portlet.instanceable=false", "javax.portlet.display-name=Contact Manager", "javax.portlet.init-param.template-path=/", "javax.portlet.init-param.view-template=/view.jsp", "javax.portlet.resource-bundle=content.Language", "javax.portlet.security-role-ref=power-user,user"}, service={Portlet.class})
public class ContactManagerPortlet
extends MVCPortlet {
    private ContactService _contactService;
    private DLFileEntryLocalService _dlFileEntryLocalService;
    private ExportImportConfigurationLocalService _exportImportConfigurationLocalService;
    private ExportImportService _exportImportService;
    private volatile ContactManagerConfiguration _contactManagerConfiguration;
    private static final Log _log = LogFactoryUtil.getLog((String)ContactManagerPortlet.class.getName());

    public void doView(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        renderRequest.setAttribute(ContactManagerConfiguration.class.getName(), (Object)this._contactManagerConfiguration);
        super.doView(renderRequest, renderResponse);
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add_temp")) {
                this.addTempFileEntry(actionRequest, ExportImportHelper.TEMP_FOLDER_NAME);
                this.validateFile(actionRequest, actionResponse, ExportImportHelper.TEMP_FOLDER_NAME);
                this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteContacts(actionRequest, actionResponse);
                this.addSuccessMessage(actionRequest, actionResponse);
            } else if (cmd.equals("deleteBackgroundTasks")) {
                this.deleteBackgroundTasks(actionRequest, actionResponse);
                this.addSuccessMessage(actionRequest, actionResponse);
            } else if (cmd.equals("delete_temp")) {
                this.deleteTempFileEntry(actionRequest, actionResponse, ExportImportHelper.TEMP_FOLDER_NAME);
                this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
            } else if (cmd.equals("import")) {
                this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
                this.importContacts(actionRequest, ExportImportHelper.TEMP_FOLDER_NAME);
                HashMap<String, String[]> parameters = new HashMap<String, String[]>();
                String mvcPath = ParamUtil.getString((PortletRequest)actionRequest, (String)"mvcPath");
                String tabs1 = ParamUtil.getString((PortletRequest)actionRequest, (String)"tabs1");
                String tabs2 = ParamUtil.getString((PortletRequest)actionRequest, (String)"tabs2");
                parameters.put("mvcPath", new String[]{mvcPath});
                parameters.put("tabs1", new String[]{tabs1});
                parameters.put("tabs2", new String[]{tabs2});
                actionResponse.setRenderParameters(parameters);
            } else if (cmd.equals("update")) {
                this.updateContact(actionRequest, actionResponse);
                this.addSuccessMessage(actionRequest, actionResponse);
            }
        }
        catch (Exception e) {
            if (cmd.equals("add_temp") || cmd.equals("delete_temp")) {
                this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
            }
            if (e instanceof LARFileException || e instanceof LARFileSizeException || e instanceof LARTypeException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
            if (e instanceof LayoutPrototypeException || e instanceof LocaleException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
            }
            _log.error((Object)e, (Throwable)e);
            SessionErrors.add((PortletRequest)actionRequest, (String)LayoutImportException.class.getName());
        }
    }

    public void render(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        try {
            this.getContact((PortletRequest)renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchResourceException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e.getClass());
            }
            throw new PortletException((Throwable)e);
        }
        super.render(renderRequest, renderResponse);
    }

    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws PortletException {
        try {
            String resourceID = resourceRequest.getResourceID();
            if (resourceID.equals("download")) {
                throw new UnsupportedOperationException();
            }
            if (resourceID.equals("exportContacts")) {
                throw new UnsupportedOperationException();
            }
            if (resourceID.equals("importContacts")) {
                this.importContacts(resourceRequest, resourceResponse);
            } else {
                super.serveResource(resourceRequest, resourceResponse);
            }
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    @Activate
    @Modified
    protected void activate(Map<Object, Object> properties) {
        this._contactManagerConfiguration = (ContactManagerConfiguration)Configurable.createConfigurable(ContactManagerConfiguration.class, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTempFileEntry(ActionRequest actionRequest, String folderName) throws Exception {
        UploadPortletRequest uploadPortletRequest = PortalUtil.getUploadPortletRequest((PortletRequest)actionRequest);
        this.checkExceededSizeLimit((HttpServletRequest)uploadPortletRequest);
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        this.deleteTempFileEntry(groupId, folderName);
        InputStream inputStream = null;
        try {
            String sourceFileName = uploadPortletRequest.getFileName("file");
            inputStream = uploadPortletRequest.getFileAsStream("file");
            String contentType = uploadPortletRequest.getContentType("file");
            this._contactService.addTempFileEntry(groupId, folderName, sourceFileName, inputStream, contentType);
        }
        catch (Exception e) {
            block7: {
                try {
                    UploadException uploadException = (UploadException)actionRequest.getAttribute("UPLOAD_EXCEPTION");
                    if (uploadException != null) {
                        Throwable cause = uploadException.getCause();
                        if (uploadException.isExceededFileSizeLimit()) {
                            throw new FileSizeException(cause);
                        }
                        if (uploadException.isExceededUploadRequestSizeLimit()) {
                            throw new UploadRequestSizeException(cause);
                        }
                        break block7;
                    }
                    throw e;
                }
                catch (Throwable throwable) {
                    StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
                    throw throwable;
                }
            }
            StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
        }
        StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
    }

    protected void checkExceededSizeLimit(HttpServletRequest request) throws PortalException {
        UploadException uploadException = (UploadException)request.getAttribute("UPLOAD_EXCEPTION");
        if (uploadException != null) {
            Throwable cause = uploadException.getCause();
            if (uploadException.isExceededFileSizeLimit() || uploadException.isExceededUploadRequestSizeLimit()) {
                throw new LARFileSizeException(cause);
            }
            throw new PortalException(cause);
        }
    }

    protected void deleteBackgroundTasks(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        _log.info((Object)"deleteBackgroundTasks");
        try {
            long[] backgroundTaskIds;
            for (long backgroundTaskId : backgroundTaskIds = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"deleteBackgroundTaskIds")) {
                BackgroundTaskManagerUtil.deleteBackgroundTask((long)backgroundTaskId);
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchBackgroundTaskException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                actionResponse.setRenderParameter("mvcPath", "/error.jsp");
            }
            throw e;
        }
        String tabs1 = ParamUtil.getString((PortletRequest)actionRequest, (String)"tabs1");
        String tabs2 = ParamUtil.getString((PortletRequest)actionRequest, (String)"tabs2");
        actionResponse.setRenderParameter("tabs1", tabs1);
        actionResponse.setRenderParameter("tabs2", tabs2);
    }

    protected void deleteContacts(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        _log.info((Object)"deleteContacts");
        long contactId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"contactId");
        long[] contactIds = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"deleteContactIds");
        if (contactId > 0L) {
            contactIds = new long[]{contactId};
        }
        for (long id : contactIds) {
            this._contactService.deleteContact(id);
        }
    }

    protected void deleteTempFileEntry(ActionRequest actionRequest, ActionResponse actionResponse, String folderName) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        try {
            String fileName = ParamUtil.getString((PortletRequest)actionRequest, (String)"fileName");
            this._contactService.deleteTempFileEntry(themeDisplay.getScopeGroupId(), folderName, fileName);
            jsonObject.put("deleted", (Object)Boolean.TRUE);
        }
        catch (Exception e) {
            String errorMessage = themeDisplay.translate("an-unexpected-error-occurred-while-deleting-the-file");
            jsonObject.put("deleted", (Object)Boolean.FALSE);
            jsonObject.put("errorMessage", errorMessage);
        }
        JSONPortletResponseUtil.writeJSON((PortletRequest)actionRequest, (PortletResponse)actionResponse, (Object)jsonObject);
    }

    protected void deleteTempFileEntry(long groupId, String folderName) throws PortalException {
        String[] tempFileNames;
        for (String tempFileEntryName : tempFileNames = this._contactService.getTempFileNames(groupId, folderName)) {
            this._contactService.deleteTempFileEntry(groupId, folderName, tempFileEntryName);
        }
    }

    protected void doDispatch(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        if (SessionErrors.contains((PortletRequest)renderRequest, (Class[])PrincipalException.getNestedClasses()) || SessionErrors.contains((PortletRequest)renderRequest, NoSuchContactException.class)) {
            this.include("/error.jsp", renderRequest, renderResponse);
        } else {
            super.doDispatch(renderRequest, renderResponse);
        }
    }

    protected void getContact(PortletRequest portletRequest) throws Exception {
        long contactId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"contactId");
        if (contactId <= 0L) {
            return;
        }
        Contact contact = this._contactService.getContact(contactId);
        portletRequest.setAttribute("CONTACT", (Object)contact);
    }

    protected String getEditContactURL(ActionRequest actionRequest, ActionResponse actionResponse, Contact contact) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String editContactURL = this.getRedirect(actionRequest, actionResponse);
        if (Validator.isNull((String)editContactURL)) {
            editContactURL = PortalUtil.getLayoutFullURL((ThemeDisplay)themeDisplay);
        }
        String namespace = actionResponse.getNamespace();
        String windowState = actionResponse.getWindowState().toString();
        editContactURL = HttpUtil.setParameter((String)editContactURL, (String)"p_p_id", (String)"ch_inofix_contact_web_internal_portlet_ContactManagerPortlet");
        editContactURL = HttpUtil.setParameter((String)editContactURL, (String)"p_p_state", (String)windowState);
        editContactURL = HttpUtil.setParameter((String)editContactURL, (String)(namespace + "mvcPath"), (String)(this.templatePath + "edit_contact.jsp"));
        editContactURL = HttpUtil.setParameter((String)editContactURL, (String)(namespace + "redirect"), (String)this.getRedirect(actionRequest, actionResponse));
        editContactURL = HttpUtil.setParameter((String)editContactURL, (String)(namespace + "backURL"), (String)ParamUtil.getString((PortletRequest)actionRequest, (String)"backURL"));
        editContactURL = HttpUtil.setParameter((String)editContactURL, (String)(namespace + "contactId"), (long)contact.getContactId());
        return editContactURL;
    }

    protected ExportImportConfiguration getExportImportConfiguration(ActionRequest actionRequest) throws Exception {
        String taskName;
        ExportImportConfiguration exportImportConfiguration;
        _log.info((Object)"getExportImportConfiguration");
        Map exportContactsSettingsMap = null;
        long exportImportConfigurationId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"exportImportConfigurationId");
        if (exportImportConfigurationId > 0L && (exportImportConfiguration = this._exportImportConfigurationLocalService.fetchExportImportConfiguration(exportImportConfigurationId)) != null) {
            exportContactsSettingsMap = exportImportConfiguration.getSettingsMap();
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (exportContactsSettingsMap == null) {
            String fileName = ParamUtil.getString((PortletRequest)actionRequest, (String)"exportFileName");
            if (Validator.isNull((String)fileName)) {
                fileName = LanguageUtil.get((Locale)actionRequest.getLocale(), (String)"task-records");
            }
            exportContactsSettingsMap = ExportImportContactsConfigurationSettingsMapFactory.buildExportContactsSettingsMap((long)themeDisplay.getUserId(), (long)themeDisplay.getPlid(), (long)themeDisplay.getScopeGroupId(), (String)"ch_inofix_contact_web_internal_portlet_ContactManagerPortlet", (Map)actionRequest.getParameterMap(), (Locale)themeDisplay.getLocale(), (TimeZone)themeDisplay.getTimeZone(), (String)fileName);
        }
        if (Validator.isNull((String)(taskName = ParamUtil.getString((PortletRequest)actionRequest, (String)"name")))) {
            taskName = "Contacts";
        }
        return this._exportImportConfigurationLocalService.addDraftExportImportConfiguration(themeDisplay.getUserId(), taskName, 0, exportContactsSettingsMap);
    }

    protected PortletConfig getPortletConfig(ResourceRequest resourceRequest) {
        String portletId = PortalUtil.getPortletId((PortletRequest)resourceRequest);
        return PortletConfigFactoryUtil.get((String)portletId);
    }

    protected PortletRequestDispatcher getPortletRequestDispatcher(ResourceRequest resourceRequest, String path) {
        PortletConfig portletConfig = this.getPortletConfig(resourceRequest);
        PortletContext portletContext = portletConfig.getPortletContext();
        return portletContext.getRequestDispatcher(path);
    }

    protected String getRedirect(ActionRequest actionRequest, ActionResponse actionResponse) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importContacts(ActionRequest actionRequest, String folderName) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        FileEntry fileEntry = ExportImportHelperUtil.getTempFileEntry((long)groupId, (long)themeDisplay.getUserId(), (String)folderName);
        InputStream inputStream = null;
        try {
            inputStream = this._dlFileEntryLocalService.getFileAsStream(fileEntry.getFileEntryId(), fileEntry.getVersion(), false);
            this.importContacts(actionRequest, fileEntry.getTitle(), inputStream);
            this.deleteTempFileEntry(groupId, folderName);
        }
        catch (Throwable throwable) {
            StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
            throw throwable;
        }
        StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
    }

    protected void importContacts(ActionRequest actionRequest, String fileName, InputStream inputStream) throws Exception {
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        ExportImportConfiguration exportImportConfiguration = this.getExportImportConfiguration(actionRequest);
        exportImportConfiguration.setName("Contacts");
        exportImportConfiguration.setGroupId(groupId);
        HashMap<String, Long> settingsMap = new HashMap<String, Long>();
        settingsMap.put("targetGroupId", groupId);
        String settings = JSONFactoryUtil.serialize(settingsMap);
        exportImportConfiguration.setSettings(settings);
        this._contactService.importContactsInBackground(exportImportConfiguration, inputStream);
    }

    protected void importContacts(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)resourceRequest, (String)"cmd");
        PortletRequestDispatcher portletRequestDispatcher = null;
        portletRequestDispatcher = cmd.equals("import") ? this.getPortletRequestDispatcher(resourceRequest, "/import/processes_list/view.jsp") : this.getPortletRequestDispatcher(resourceRequest, "/import/new_import/import_contacts_resources.jsp");
        portletRequestDispatcher.include((PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
    }

    @Reference
    protected void setContactService(ContactService contactService) {
        this._contactService = contactService;
    }

    @Reference
    protected void setDLFileEntryLocalService(DLFileEntryLocalService dlFileEntryLocalService) {
        this._dlFileEntryLocalService = dlFileEntryLocalService;
    }

    @Reference(unbind="-")
    protected void setExportImportConfigurationLocalService(ExportImportConfigurationLocalService exportImportConfigurationLocalService) {
        this._exportImportConfigurationLocalService = exportImportConfigurationLocalService;
    }

    @Reference(unbind="-")
    protected void setExportImportService(ExportImportService exportImportService) {
        this._exportImportService = exportImportService;
    }

    protected void updateContact(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)Contact.class.getName(), (PortletRequest)actionRequest);
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)actionRequest);
        UploadPortletRequest uploadPortletRequest = PortalUtil.getUploadPortletRequest((PortletRequest)actionRequest);
        long contactId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"contactId");
        Contact contact = null;
        String card = "";
        String uid = null;
        if (contactId > 0L) {
            contact = this._contactService.getContact(contactId);
            uid = contact.getUid();
            card = contact.getCard();
        } else {
            VCard vCard = new VCard();
            vCard.setUid(Uid.random());
            uid = (String)vCard.getUid().getValue();
            card = Ezvcard.write((VCard[])new VCard[]{vCard}).version(VCardVersion.V4_0).go();
        }
        File[] keyFiles = uploadPortletRequest.getFiles("key.file");
        File[] logoFiles = uploadPortletRequest.getFiles("logo.file");
        File[] photoFiles = uploadPortletRequest.getFiles("photo.file");
        File[] soundFiles = uploadPortletRequest.getFiles("sound.file");
        HashMap<String, File[]> map = new HashMap<String, File[]>();
        if (keyFiles != null) {
            map.put("key.file", keyFiles);
        }
        if (logoFiles != null) {
            map.put("logo.file", logoFiles);
        }
        if (photoFiles != null) {
            map.put("photo.file", photoFiles);
        }
        if (soundFiles != null) {
            map.put("sound.file", soundFiles);
        }
        try {
            VCard vCard = Ezvcard.parse((String)card).first();
            vCard = PortletUtil.getVCard(request, vCard, map);
            card = Ezvcard.write((VCard[])new VCard[]{vCard}).version(VCardVersion.V4_0).go();
        }
        catch (ImageFileFormatException iffe) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"the-image-file-format-is-not-supported");
            uploadPortletRequest.setAttribute("CONTACT", (Object)contact);
            return;
        }
        catch (KeyFileFormatException kffe) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"the-key-file-format-is-not-supported");
            uploadPortletRequest.setAttribute("CONTACT", (Object)contact);
            return;
        }
        catch (SoundFileFormatException sffe) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"the-sound-file-format-is-not-supported");
            uploadPortletRequest.setAttribute("CONTACT", (Object)contact);
            return;
        }
        contact = contactId <= 0L ? this._contactService.addContact(card, uid, serviceContext) : this._contactService.updateContact(contactId, card, uid, serviceContext);
        String redirect = this.getEditContactURL(actionRequest, actionResponse, contact);
        actionRequest.setAttribute("REDIRECT", (Object)redirect);
        actionRequest.setAttribute("CONTACT", (Object)contact);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateFile(ActionRequest actionRequest, ActionResponse actionResponse, String folderName) throws Exception {
        Map weakMissingReferences;
        InputStream inputStream;
        ThemeDisplay themeDisplay;
        block4: {
            themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
            FileEntry fileEntry = ExportImportHelperUtil.getTempFileEntry((long)groupId, (long)themeDisplay.getUserId(), (String)folderName);
            inputStream = null;
            try {
                inputStream = this._dlFileEntryLocalService.getFileAsStream(fileEntry.getFileEntryId(), fileEntry.getVersion(), false);
                MissingReferences missingReferences = this.validateFile(actionRequest, inputStream);
                weakMissingReferences = missingReferences.getWeakMissingReferences();
                if (!weakMissingReferences.isEmpty()) break block4;
            }
            catch (Throwable throwable) {
                StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
                throw throwable;
            }
            StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
            return;
        }
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        if (weakMissingReferences != null && !weakMissingReferences.isEmpty()) {
            jsonObject.put("warningMessages", StagingUtil.getWarningMessagesJSONArray((Locale)themeDisplay.getLocale(), (Map)weakMissingReferences));
        }
        JSONPortletResponseUtil.writeJSON((PortletRequest)actionRequest, (PortletResponse)actionResponse, (Object)jsonObject);
        StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
    }

    protected MissingReferences validateFile(ActionRequest actionRequest, InputStream inputStream) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        boolean privateLayout = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayout");
        Map importLayoutSettingsMap = ExportImportConfigurationSettingsMapFactory.buildImportLayoutSettingsMap((long)themeDisplay.getUserId(), (long)groupId, (boolean)privateLayout, null, (Map)actionRequest.getParameterMap(), (Locale)themeDisplay.getLocale(), (TimeZone)themeDisplay.getTimeZone());
        ExportImportConfiguration exportImportConfiguration = this._exportImportConfigurationLocalService.addDraftExportImportConfiguration(themeDisplay.getUserId(), 1, importLayoutSettingsMap);
        return this._exportImportService.validateImportLayoutsFile(exportImportConfiguration, inputStream);
    }
}

