/*
 * Decompiled with CFR 0.152.
 */
package ch.inofix.contact.web.internal.asset;

import ch.inofix.contact.model.Contact;
import ch.inofix.contact.service.ContactLocalService;
import ch.inofix.contact.service.permission.ContactManagerPermission;
import ch.inofix.contact.service.permission.ContactPermission;
import ch.inofix.contact.web.internal.asset.ContactAssetRenderer;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.BaseAssetRendererFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.servlet.ServletContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=ch_inofix_contact_web_internal_portlet_ContactManagerPortlet"}, service={AssetRendererFactory.class})
public class ContactAssetRendererFactory
extends BaseAssetRendererFactory<Contact> {
    public static final String TYPE = "contact";
    private static final Log _log = LogFactoryUtil.getLog(ContactAssetRendererFactory.class);
    private ContactLocalService _contactLocalService;
    private ServletContext _servletContext;

    public ContactAssetRendererFactory() {
        this.setCategorizable(true);
        this.setClassName(Contact.class.getName());
        this.setLinkable(true);
        this.setPortletId("ch_inofix_contact_web_internal_portlet_ContactManagerPortlet");
        this.setSearchable(true);
        this.setSelectable(true);
    }

    public AssetRenderer<Contact> getAssetRenderer(long classPK, int type) throws PortalException {
        Contact contact = this._contactLocalService.getContact(classPK);
        ContactAssetRenderer contactAssetRenderer = new ContactAssetRenderer(contact);
        contactAssetRenderer.setAssetRendererType(type);
        contactAssetRenderer.setServletContext(this._servletContext);
        return contactAssetRenderer;
    }

    public String getClassName() {
        return Contact.class.getName();
    }

    public String getType() {
        return TYPE;
    }

    public PortletURL getURLAdd(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        User user = themeDisplay.getUser();
        Group group = user.getGroup();
        if (group != null) {
            long portletPlid = PortalUtil.getPlidFromPortletId((long)group.getGroupId(), (boolean)false, (String)"ch_inofix_contact_web_internal_portlet_ContactManagerPortlet");
            LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)liferayPortletRequest, (String)"ch_inofix_contact_web_internal_portlet_ContactManagerPortlet", (long)portletPlid, (String)"RENDER_PHASE");
            portletURL.setParameter("mvcPath", "/edit_contact.jsp");
            String redirect = (String)liferayPortletRequest.getAttribute("redirect");
            if (Validator.isNotNull((String)redirect)) {
                portletURL.setParameter("redirect", redirect);
            }
            return portletURL;
        }
        return null;
    }

    public boolean hasAddPermission(PermissionChecker permissionChecker, long groupId, long classTypeId) throws Exception {
        return ContactManagerPermission.contains((PermissionChecker)permissionChecker, (long)groupId, (String)"ADD_CONTACT");
    }

    public boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws Exception {
        Contact contact = this._contactLocalService.getContact(classPK);
        return ContactPermission.contains((PermissionChecker)permissionChecker, (long)contact.getContactId(), (String)actionId);
    }

    @Reference(target="(osgi.web.symbolicname=ch.inofix.contact.web)", unbind="-")
    public void setServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
    }

    @Reference(unbind="-")
    protected void setContactLocalService(ContactLocalService contactLocalService) {
        this._contactLocalService = contactLocalService;
    }
}

