/*
 * Decompiled with CFR 0.152.
 */
package ch.inofix.contact.search;

import ch.inofix.contact.model.Contact;
import ch.inofix.contact.service.ContactLocalService;
import ch.inofix.contact.service.permission.ContactPermission;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.LinkedHashMap;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={Indexer.class})
public class ContactIndexer
extends BaseIndexer<Contact> {
    public static final String CLASS_NAME = Contact.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(ContactIndexer.class);
    private ContactLocalService _contactLocalService;
    @Reference
    private IndexWriterHelper _indexWriterHelper;

    public ContactIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"assetTagNames", "companyId", "entryClassName", "entryClassPK", "groupId", "modified", "scopeGroupId", "title", "uid", "url"});
        this.setFilterSearch(true);
        this.setPermissionAware(true);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        return ContactPermission.contains(permissionChecker, entryClassPK, "VIEW");
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        this.addStatus(contextBooleanFilter, searchContext);
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        String expandoAttributes;
        this.addSearchTerm(searchQuery, searchContext, "company", false);
        this.addSearchTerm(searchQuery, searchContext, "fullName", false);
        LinkedHashMap params = (LinkedHashMap)searchContext.getAttribute("params");
        if (params != null && Validator.isNotNull((String)(expandoAttributes = (String)params.get("expandoAttributes")))) {
            this.addSearchExpando(searchQuery, searchContext, expandoAttributes);
        }
    }

    protected void doDelete(Contact contact) throws Exception {
        this.deleteDocument(contact.getCompanyId(), contact.getContactId());
    }

    protected Document doGetDocument(Contact contact) throws Exception {
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)contact);
        document.addTextSortable("city", contact.getAddress().getLocality());
        document.addTextSortable("company", contact.getCompany());
        document.addNumberSortable("contactId", Long.valueOf(contact.getContactId()));
        document.addText("content", contact.getCard());
        document.addTextSortable("country", contact.getAddress().getCountry());
        document.addDateSortable("createDate", contact.getCreateDate());
        document.addText("description", "TODO: contact description");
        document.addTextSortable("email", contact.getEmail().getAddress());
        document.addTextSortable("fullName", contact.getFullName(false));
        document.addDateSortable("modifiedDate", contact.getModifiedDate());
        document.addTextSortable("name", contact.getName());
        document.addTextSortable("phone", contact.getPhone().getNumber());
        document.addNumber("status", contact.getStatus());
        document.addText("title", contact.getName());
        document.addTextSortable("url", contact.getUrl());
        document.addKeyword("vCardUID", contact.getUid());
        document.addTextSortable("x-salutation", contact.getSalutation());
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) throws Exception {
        Summary summary = this.createSummary(document, "title", "content");
        return summary;
    }

    protected void doReindex(Contact contact) throws Exception {
        Document document = this.getDocument(contact);
        this._indexWriterHelper.updateDocument(this.getSearchEngineId(), contact.getCompanyId(), document, this.isCommitImmediately());
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexContacts(companyId);
    }

    protected void doReindex(String className, long classPK) throws Exception {
        Contact contact = this._contactLocalService.getContact(classPK);
        this.doReindex(contact);
    }

    protected void reindexContacts(long companyId) throws PortalException {
        final IndexableActionableDynamicQuery indexableActionableDynamicQuery = this._contactLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                Property statusProperty = PropertyFactoryUtil.forName((String)"status");
                Object[] statuses = new Integer[]{0, 8};
                dynamicQuery.add(statusProperty.in(statuses));
            }
        });
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<Contact>(){

            public void performAction(Contact contact) {
                block2: {
                    try {
                        Document document = ContactIndexer.this.getDocument(contact);
                        indexableActionableDynamicQuery.addDocuments(new Document[]{document});
                    }
                    catch (PortalException pe) {
                        if (!_log.isWarnEnabled()) break block2;
                        _log.warn((Object)("Unable to index bookmarks contact " + contact.getContactId()), (Throwable)pe);
                    }
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }

    @Reference(unbind="-")
    protected void setContactLocalService(ContactLocalService contactLocalService) {
        this._contactLocalService = contactLocalService;
    }
}

