/*
 * Decompiled with CFR 0.152.
 */
package ch.inofix.contact.model.impl;

import aQute.bnd.annotation.ProviderType;
import ch.inofix.contact.dto.AddressDTO;
import ch.inofix.contact.dto.CategoriesDTO;
import ch.inofix.contact.dto.EmailDTO;
import ch.inofix.contact.dto.ExpertiseDTO;
import ch.inofix.contact.dto.FileDTO;
import ch.inofix.contact.dto.HobbyDTO;
import ch.inofix.contact.dto.ImppDTO;
import ch.inofix.contact.dto.InterestDTO;
import ch.inofix.contact.dto.LanguageDTO;
import ch.inofix.contact.dto.NoteDTO;
import ch.inofix.contact.dto.PhoneDTO;
import ch.inofix.contact.dto.StructuredNameDTO;
import ch.inofix.contact.dto.UriDTO;
import ch.inofix.contact.dto.UrlDTO;
import ch.inofix.contact.model.impl.ContactBaseImpl;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import ezvcard.Ezvcard;
import ezvcard.VCard;
import ezvcard.parameter.AddressType;
import ezvcard.parameter.EmailType;
import ezvcard.parameter.ExpertiseLevel;
import ezvcard.parameter.HobbyLevel;
import ezvcard.parameter.ImageType;
import ezvcard.parameter.ImppType;
import ezvcard.parameter.InterestLevel;
import ezvcard.parameter.KeyType;
import ezvcard.parameter.SoundType;
import ezvcard.parameter.TelephoneType;
import ezvcard.property.Address;
import ezvcard.property.CalendarRequestUri;
import ezvcard.property.CalendarUri;
import ezvcard.property.Categories;
import ezvcard.property.Email;
import ezvcard.property.Expertise;
import ezvcard.property.FormattedName;
import ezvcard.property.FreeBusyUrl;
import ezvcard.property.Gender;
import ezvcard.property.Hobby;
import ezvcard.property.Impp;
import ezvcard.property.Interest;
import ezvcard.property.Key;
import ezvcard.property.Kind;
import ezvcard.property.Language;
import ezvcard.property.Logo;
import ezvcard.property.Nickname;
import ezvcard.property.Note;
import ezvcard.property.Organization;
import ezvcard.property.Photo;
import ezvcard.property.RawProperty;
import ezvcard.property.Sound;
import ezvcard.property.StructuredName;
import ezvcard.property.Telephone;
import ezvcard.property.Timezone;
import ezvcard.property.Url;
import ezvcard.util.DataUri;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

@ProviderType
public class ContactImpl
extends ContactBaseImpl {
    private AddressDTO getAddress(Address address) {
        AddressDTO addressDTO = new AddressDTO();
        if (address != null) {
            addressDTO.setCountry(address.getCountry());
            addressDTO.setLabel(address.getLabel());
            addressDTO.setLanguage(address.getLanguage());
            addressDTO.setLocality(address.getLocality());
            addressDTO.setPoBox(address.getPoBox());
            addressDTO.setPostalCode(address.getPostalCode());
            addressDTO.setRegion(address.getRegion());
            addressDTO.setStreetAddress(address.getStreetAddress());
            addressDTO.setTimezone(address.getTimezone());
            StringBuilder sb = new StringBuilder();
            List types = address.getTypes();
            if (types.size() > 0) {
                for (AddressType type : types) {
                    sb.append(type.getValue());
                }
            } else {
                sb.append("other");
            }
            addressDTO.setType(sb.toString());
        }
        return addressDTO;
    }

    public AddressDTO getAddress() {
        List addresses = this.getVCard().getAddresses();
        if (addresses != null) {
            for (Address address : addresses) {
                Integer pref = address.getPref();
                if (pref == null || pref != 1) continue;
                return this.getAddress(address);
            }
        }
        Address address = (Address)this.getVCard().getProperty(Address.class);
        return this.getAddress(address);
    }

    public List<AddressDTO> getAddresses() {
        ArrayList<AddressDTO> addressDTOs = new ArrayList<AddressDTO>();
        List addresses = this.getVCard().getAddresses();
        for (Address address : addresses) {
            AddressDTO addressDTO = this.getAddress(address);
            addressDTOs.add(addressDTO);
        }
        if (addressDTOs.size() == 0) {
            addressDTOs.add(new AddressDTO());
        }
        return addressDTOs;
    }

    public String getCompany() {
        List values;
        String str = "";
        List organizations = this.getVCard().getOrganizations();
        if (organizations.size() > 0 && (values = ((Organization)organizations.get(0)).getValues()).size() > 0) {
            str = (String)values.get(0);
        }
        return str;
    }

    public List<UriDTO> getCalendarRequestUris() {
        ArrayList<UriDTO> uriDTOs = new ArrayList<UriDTO>();
        List calendarRequestUris = this.getVCard().getCalendarRequestUris();
        for (CalendarRequestUri calendarRequestUri : calendarRequestUris) {
            UriDTO uriDTO = new UriDTO();
            uriDTO.setUri((String)calendarRequestUri.getValue());
            uriDTO.setType(calendarRequestUri.getType());
            uriDTOs.add(uriDTO);
        }
        if (uriDTOs.size() == 0) {
            uriDTOs.add(new UriDTO());
        }
        return uriDTOs;
    }

    public List<UriDTO> getCalendarUris() {
        ArrayList<UriDTO> uriDTOs = new ArrayList<UriDTO>();
        List calendarUris = this.getVCard().getCalendarUris();
        for (CalendarUri calendarUri : calendarUris) {
            UriDTO uriDTO = new UriDTO();
            uriDTO.setUri((String)calendarUri.getValue());
            uriDTO.setType(calendarUri.getType());
            uriDTOs.add(uriDTO);
        }
        if (uriDTOs.size() == 0) {
            uriDTOs.add(new UriDTO());
        }
        return uriDTOs;
    }

    public List<CategoriesDTO> getCategoriesList() {
        ArrayList<CategoriesDTO> categoriesDTOs = new ArrayList<CategoriesDTO>();
        List categoriesList = this.getVCard().getCategoriesList();
        for (Categories categories : categoriesList) {
            CategoriesDTO categoriesDTO = new CategoriesDTO();
            StringBuilder sb = new StringBuilder();
            List values = categories.getValues();
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                sb.append((String)iterator.next());
                if (!iterator.hasNext()) continue;
                sb.append(", ");
            }
            categoriesDTO.setValue(sb.toString());
            categoriesDTO.setType(categories.getType());
            categoriesDTOs.add(categoriesDTO);
        }
        if (categoriesDTOs.size() == 0) {
            categoriesDTOs.add(new CategoriesDTO());
        }
        return categoriesDTOs;
    }

    public String getDepartment() {
        List values;
        String str = "";
        List organizations = this.getVCard().getOrganizations();
        if (organizations.size() > 0 && (values = ((Organization)organizations.get(0)).getValues()).size() > 1) {
            str = (String)values.get(1);
        }
        return str;
    }

    public EmailDTO getEmail() {
        List emails = this.getVCard().getEmails();
        if (emails != null) {
            for (Email email : emails) {
                Integer pref = email.getPref();
                if (pref == null || pref != 1) continue;
                return this.getEmail(email);
            }
        }
        Email email = (Email)this.getVCard().getProperty(Email.class);
        return this.getEmail(email);
    }

    private EmailDTO getEmail(Email email) {
        EmailDTO emailDTO = new EmailDTO();
        if (email != null) {
            emailDTO.setAddress((String)email.getValue());
            StringBuilder sb = new StringBuilder();
            Set types = SetUtil.fromList((List)email.getTypes());
            if (types.size() > 0) {
                for (EmailType type : types) {
                    sb.append(type.getValue());
                }
            } else {
                sb.append("other");
            }
            emailDTO.setType(sb.toString());
        }
        return emailDTO;
    }

    public List<EmailDTO> getEmails() {
        ArrayList<EmailDTO> emailDTOs = new ArrayList<EmailDTO>();
        List emails = this.getVCard().getEmails();
        for (Email email : emails) {
            EmailDTO emailDTO = this.getEmail(email);
            emailDTOs.add(emailDTO);
        }
        if (emailDTOs.size() == 0) {
            emailDTOs.add(new EmailDTO());
        }
        return emailDTOs;
    }

    public List<ExpertiseDTO> getExpertises() {
        List expertises = this.getVCard().getExpertise();
        ArrayList<ExpertiseDTO> expertiseDTOs = new ArrayList<ExpertiseDTO>();
        for (Expertise expertise : expertises) {
            ExpertiseDTO expertiseDTO = new ExpertiseDTO();
            expertiseDTO.setValue((String)expertise.getValue());
            ExpertiseLevel level = expertise.getLevel();
            if (level != null) {
                expertiseDTO.setLevel(level.getValue());
            }
            expertiseDTOs.add(expertiseDTO);
        }
        if (expertiseDTOs.size() == 0) {
            expertiseDTOs.add(new ExpertiseDTO());
        }
        return expertiseDTOs;
    }

    public String getFamilyName() {
        String familyName = null;
        StructuredName sn = this.getVCard().getStructuredName();
        if (sn != null) {
            familyName = sn.getFamily();
        }
        return familyName;
    }

    public String getFirstName() {
        String firstName = null;
        StructuredName sn = this.getVCard().getStructuredName();
        if (sn != null) {
            firstName = sn.getGiven();
        }
        return firstName;
    }

    public String getFormattedName() {
        String formattedName = "";
        FormattedName fn = this.getVCard().getFormattedName();
        if (fn != null) {
            formattedName = (String)fn.getValue();
        }
        return formattedName;
    }

    public List<UrlDTO> getFreeBusyUrls() {
        ArrayList<UrlDTO> urlDTOs = new ArrayList<UrlDTO>();
        List urls = this.getVCard().getFbUrls();
        for (FreeBusyUrl url : urls) {
            UrlDTO urlDTO = new UrlDTO();
            urlDTO.setAddress((String)url.getValue());
            urlDTO.setType(url.getType());
            urlDTOs.add(urlDTO);
        }
        if (urlDTOs.size() == 0) {
            urlDTOs.add(new UrlDTO());
        }
        return urlDTOs;
    }

    public String getFullName() {
        return this.getFullName(false);
    }

    public String getFullName(boolean firstLast) {
        Organization organization;
        String fullName;
        StringBuilder sb = new StringBuilder();
        StructuredName sn = this.getVCard().getStructuredName();
        if (sn != null) {
            if (firstLast) {
                sb.append(sn.getGiven());
                sb.append(" ");
                sb.append(sn.getFamily());
            } else {
                sb.append(sn.getFamily());
                sb.append(", ");
                sb.append(sn.getGiven());
            }
        }
        if (Validator.isNull((String)(fullName = sb.toString())) && (organization = this.getVCard().getOrganization()) != null) {
            List values = organization.getValues();
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                sb.append((String)iterator.next());
                if (!iterator.hasNext()) continue;
                sb.append(", ");
            }
        }
        return fullName;
    }

    public String getGender() {
        String str = "U";
        Gender gender = this.getVCard().getGender();
        if (gender != null) {
            str = gender.getGender();
        }
        return str;
    }

    public List<HobbyDTO> getHobbies() {
        List hobbies = this.getVCard().getHobbies();
        ArrayList<HobbyDTO> hobbyDTOs = new ArrayList<HobbyDTO>();
        for (Hobby hobby : hobbies) {
            HobbyDTO hobbyDTO = new HobbyDTO();
            hobbyDTO.setValue((String)hobby.getValue());
            HobbyLevel level = hobby.getLevel();
            if (level != null) {
                hobbyDTO.setLevel(level.getValue());
            }
            hobbyDTOs.add(hobbyDTO);
        }
        if (hobbyDTOs.size() == 0) {
            hobbyDTOs.add(new HobbyDTO());
        }
        return hobbyDTOs;
    }

    public List<ImppDTO> getImpps() {
        ArrayList<ImppDTO> imppDTOs = new ArrayList<ImppDTO>();
        List impps = this.getVCard().getImpps();
        for (Impp impp : impps) {
            ImppDTO imppDTO = new ImppDTO();
            StringBuilder sb = new StringBuilder();
            List types = impp.getTypes();
            if (types.size() > 0) {
                for (ImppType type : types) {
                    sb.append(type.getValue());
                }
            } else {
                sb.append("other");
            }
            imppDTO.setProtocol(impp.getProtocol());
            imppDTO.setType(sb.toString());
            String protocol = impp.getProtocol();
            String uri = impp.getUri().toString();
            uri = uri.replace(protocol + ":", "");
            imppDTO.setUri(uri);
            imppDTOs.add(imppDTO);
        }
        if (imppDTOs.size() == 0) {
            imppDTOs.add(new ImppDTO());
        }
        return imppDTOs;
    }

    public List<InterestDTO> getInterests() {
        List interests = this.getVCard().getInterests();
        ArrayList<InterestDTO> interestDTOs = new ArrayList<InterestDTO>();
        for (Interest interest : interests) {
            InterestDTO interestDTO = new InterestDTO();
            interestDTO.setValue((String)interest.getValue());
            InterestLevel level = interest.getLevel();
            if (level != null) {
                interestDTO.setLevel(level.getValue());
            }
            interestDTOs.add(interestDTO);
        }
        if (interestDTOs.size() == 0) {
            interestDTOs.add(new InterestDTO());
        }
        return interestDTOs;
    }

    public List<FileDTO> getKeys() {
        ArrayList<FileDTO> fileDTOs = new ArrayList<FileDTO>();
        List keys = this.getVCard().getKeys();
        for (Key key : keys) {
            FileDTO fileDTO = new FileDTO();
            fileDTO.setUrl(key.getUrl());
            KeyType contentType = (KeyType)key.getContentType();
            if (Validator.isNotNull((Object)contentType)) {
                DataUri dataUri = new DataUri(contentType.getMediaType(), key.getData());
                fileDTO.setData(dataUri.toString());
            }
            fileDTOs.add(fileDTO);
        }
        if (fileDTOs.size() == 0) {
            fileDTOs.add(new FileDTO());
        }
        return fileDTOs;
    }

    public String getKind() {
        String str = "individual";
        Kind kind = this.getVCard().getKind();
        if (kind != null) {
            str = (String)kind.getValue();
        }
        return str;
    }

    public List<LanguageDTO> getLanguages() {
        List languages = this.getVCard().getLanguages();
        ArrayList<LanguageDTO> languageDTOs = new ArrayList<LanguageDTO>();
        for (Language language : languages) {
            LanguageDTO languageDTO = new LanguageDTO();
            languageDTO.setKey((String)language.getValue());
            languageDTOs.add(languageDTO);
        }
        return languageDTOs;
    }

    public List<FileDTO> getLogos() {
        ArrayList<FileDTO> fileDTOs = new ArrayList<FileDTO>();
        List logos = this.getVCard().getLogos();
        for (Logo logo : logos) {
            FileDTO fileDTO = new FileDTO();
            fileDTO.setUrl(logo.getUrl());
            ImageType contentType = (ImageType)logo.getContentType();
            if (Validator.isNotNull((Object)contentType)) {
                DataUri dataUri = new DataUri(contentType.getMediaType(), logo.getData());
                fileDTO.setData(dataUri.toString());
            }
            fileDTOs.add(fileDTO);
        }
        if (fileDTOs.size() == 0) {
            fileDTOs.add(new FileDTO());
        }
        return fileDTOs;
    }

    public String getName() {
        String name = null;
        name = Validator.isNull((String)this.getFamilyName()) && Validator.isNull((String)this.getFirstName()) ? this.getCompany() : this.getFullName(false);
        return name;
    }

    public String getNickname() {
        StringBuilder sb = new StringBuilder();
        Nickname nickname = this.getVCard().getNickname();
        if (nickname != null) {
            List values = nickname.getValues();
            for (String value : values) {
                sb.append(value);
                sb.append(" ");
            }
        }
        return sb.toString();
    }

    public List<NoteDTO> getNotes() {
        List notes = this.getVCard().getNotes();
        ArrayList<NoteDTO> noteDTOs = new ArrayList<NoteDTO>();
        for (Note note : notes) {
            NoteDTO noteDTO = new NoteDTO();
            noteDTO.setValue((String)note.getValue());
            noteDTOs.add(noteDTO);
        }
        if (noteDTOs.size() == 0) {
            noteDTOs.add(new NoteDTO());
        }
        return noteDTOs;
    }

    public String getOffice() {
        List values;
        String str = "";
        List organizations = this.getVCard().getOrganizations();
        if (organizations.size() > 0 && (values = ((Organization)organizations.get(0)).getValues()).size() > 2) {
            str = (String)values.get(2);
        }
        return str;
    }

    public PhoneDTO getPhone() {
        List phones = this.getVCard().getTelephoneNumbers();
        if (phones != null) {
            for (Telephone phone : phones) {
                Integer pref = phone.getPref();
                if (pref == null || pref != 1) continue;
                return this.getPhone(phone);
            }
        }
        Telephone phone = (Telephone)this.getVCard().getProperty(Telephone.class);
        return this.getPhone(phone);
    }

    private PhoneDTO getPhone(Telephone phone) {
        PhoneDTO phoneDTO = new PhoneDTO();
        if (phone != null) {
            phoneDTO.setNumber(phone.getText());
            StringBuilder sb = new StringBuilder();
            Set types = SetUtil.fromList((List)phone.getTypes());
            if (types.size() > 0) {
                for (TelephoneType type : types) {
                    sb.append(type.getValue());
                }
            } else {
                sb.append("other");
            }
            phoneDTO.setType(sb.toString());
        }
        return phoneDTO;
    }

    public List<PhoneDTO> getPhones() {
        ArrayList<PhoneDTO> phoneDTOs = new ArrayList<PhoneDTO>();
        List phones = this.getVCard().getTelephoneNumbers();
        for (Telephone phone : phones) {
            PhoneDTO phoneDTO = this.getPhone(phone);
            phoneDTOs.add(phoneDTO);
        }
        if (phoneDTOs.size() == 0) {
            phoneDTOs.add(new PhoneDTO());
        }
        return phoneDTOs;
    }

    public List<FileDTO> getPhotos() {
        ArrayList<FileDTO> fileDTOs = new ArrayList<FileDTO>();
        List photos = this.getVCard().getPhotos();
        for (Photo photo : photos) {
            FileDTO fileDTO = new FileDTO();
            fileDTO.setUrl(photo.getUrl());
            ImageType contentType = (ImageType)photo.getContentType();
            if (Validator.isNotNull((Object)contentType)) {
                DataUri dataUri = new DataUri(contentType.getMediaType(), photo.getData());
                fileDTO.setData(dataUri.toString());
            }
            fileDTOs.add(fileDTO);
        }
        if (fileDTOs.size() == 0) {
            fileDTOs.add(new FileDTO());
        }
        return fileDTOs;
    }

    public String getPortrait() {
        String portrait = null;
        List photos = this.getVCard().getPhotos();
        List logos = this.getVCard().getLogos();
        if (logos.size() > 0) {
            portrait = this.getLogos().get(0).getData();
        } else if (photos.size() > 0) {
            portrait = this.getPhotos().get(0).getData();
        }
        return portrait;
    }

    public String getSalutation() {
        String salutation = "";
        VCard vCard = this.getVCard();
        RawProperty rawProperty = vCard.getExtendedProperty("x-salutation");
        if (rawProperty != null) {
            salutation = (String)rawProperty.getValue();
        }
        return salutation;
    }

    public List<FileDTO> getSounds() {
        ArrayList<FileDTO> fileDTOs = new ArrayList<FileDTO>();
        List sounds = this.getVCard().getSounds();
        for (Sound sound : sounds) {
            FileDTO fileDTO = new FileDTO();
            fileDTO.setUrl(sound.getUrl());
            SoundType contentType = (SoundType)sound.getContentType();
            if (Validator.isNotNull((Object)contentType)) {
                DataUri dataUri = new DataUri(contentType.getMediaType(), sound.getData());
                fileDTO.setData(dataUri.toString());
            }
            fileDTOs.add(fileDTO);
        }
        if (fileDTOs.size() == 0) {
            fileDTOs.add(new FileDTO());
        }
        return fileDTOs;
    }

    private StructuredNameDTO getStructuredName(StructuredName structuredName) {
        StructuredNameDTO structuredNameDTO = new StructuredNameDTO();
        if (structuredName != null) {
            StringBuilder sb = new StringBuilder();
            List additionalNames = structuredName.getAdditionalNames();
            if (additionalNames.size() > 0) {
                for (Object additionalName : additionalNames) {
                    sb.append((String)additionalName);
                    sb.append(" ");
                }
            }
            structuredNameDTO.setAdditional(sb.toString());
            structuredNameDTO.setFamily(structuredName.getFamily());
            structuredNameDTO.setGiven(structuredName.getGiven());
            sb = new StringBuilder();
            List prefixes = structuredName.getPrefixes();
            if (prefixes.size() > 0) {
                for (String prefix : prefixes) {
                    sb.append(prefix);
                    sb.append(" ");
                }
            }
            structuredNameDTO.setPrefix(sb.toString());
            sb = new StringBuilder();
            List suffixes = structuredName.getSuffixes();
            if (suffixes.size() > 0) {
                for (String suffix : suffixes) {
                    sb.append(suffix);
                    sb.append(" ");
                }
            }
            structuredNameDTO.setSuffix(sb.toString());
        }
        return structuredNameDTO;
    }

    public StructuredNameDTO getStructuredName() {
        return this.getStructuredName(this.getVCard().getStructuredName());
    }

    public VCard getVCard() {
        String str = this.getCard();
        VCard vCard = null;
        vCard = Validator.isNotNull((String)str) ? Ezvcard.parse((String)str).first() : new VCard();
        return vCard;
    }

    public String getTimezone() {
        String str = "";
        Timezone timezone = this.getVCard().getTimezone();
        if (timezone != null) {
            str = timezone.getText();
        }
        return str;
    }

    public String getUrl() {
        String url = null;
        List<UrlDTO> urls = this.getUrls();
        if (urls.size() > 0) {
            url = urls.get(0).getAddress();
        }
        return url;
    }

    public List<UrlDTO> getUrls() {
        ArrayList<UrlDTO> urlDTOs = new ArrayList<UrlDTO>();
        List urls = this.getVCard().getUrls();
        for (Url url : urls) {
            UrlDTO urlDTO = this.getUrl(url);
            urlDTOs.add(urlDTO);
        }
        if (urlDTOs.size() == 0) {
            urlDTOs.add(new UrlDTO());
        }
        return urlDTOs;
    }

    private UrlDTO getUrl(Url url) {
        UrlDTO urlDTO = new UrlDTO();
        if (url != null) {
            urlDTO.setAddress((String)url.getValue());
            urlDTO.setType(url.getType());
        }
        return urlDTO;
    }
}

