/*
 * Decompiled with CFR 0.152.
 */
package ch.inofix.contact.background.task;

import ch.inofix.contact.background.task.ContactExportBackgroundTaskExecutor;
import ch.inofix.contact.background.task.ContactImportBackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutor;
import com.liferay.portal.kernel.util.HashMapDictionary;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(immediate=true, service={BackgroundTaskExecutorConfigurator.class})
public class BackgroundTaskExecutorConfigurator {
    private final Set<ServiceRegistration<BackgroundTaskExecutor>> _serviceRegistrations = new HashSet<ServiceRegistration<BackgroundTaskExecutor>>();

    @Activate
    protected void activate(BundleContext bundleContext) {
        ContactExportBackgroundTaskExecutor contactExportBackgroundTaskExecutor = new ContactExportBackgroundTaskExecutor();
        this.registerBackgroundTaskExecutor(bundleContext, (BackgroundTaskExecutor)contactExportBackgroundTaskExecutor);
        ContactImportBackgroundTaskExecutor contactImportBackgroundTaskExecutor = new ContactImportBackgroundTaskExecutor();
        this.registerBackgroundTaskExecutor(bundleContext, (BackgroundTaskExecutor)contactImportBackgroundTaskExecutor);
    }

    @Deactivate
    protected void deactivate() {
        for (ServiceRegistration<BackgroundTaskExecutor> serviceRegistration : this._serviceRegistrations) {
            serviceRegistration.unregister();
        }
    }

    protected void registerBackgroundTaskExecutor(BundleContext bundleContext, BackgroundTaskExecutor backgroundTaskExecutor) {
        HashMapDictionary properties = new HashMapDictionary();
        Class<?> clazz = backgroundTaskExecutor.getClass();
        properties.put("background.task.executor.class.name", clazz.getName());
        ServiceRegistration serviceRegistration = bundleContext.registerService(BackgroundTaskExecutor.class, (Object)backgroundTaskExecutor, (Dictionary)properties);
        this._serviceRegistrations.add((ServiceRegistration<BackgroundTaskExecutor>)serviceRegistration);
    }
}

